/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ComparisonUtil {
    private static final int UNIMPORTANT_LINE_CHAR_COUNT = Registry.intValue((String)"diff.unimportant.line.char.count");

    public static boolean isValidRanges(@NotNull CharSequence content1, @NotNull CharSequence content2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull List<Range> lineRanges) {
        if (content1 == null) {
            ComparisonUtil.$$$reportNull$$$0(0);
        }
        if (content2 == null) {
            ComparisonUtil.$$$reportNull$$$0(1);
        }
        if (lineOffsets1 == null) {
            ComparisonUtil.$$$reportNull$$$0(2);
        }
        if (lineOffsets2 == null) {
            ComparisonUtil.$$$reportNull$$$0(3);
        }
        if (lineRanges == null) {
            ComparisonUtil.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.exists(lineRanges, range2 -> !ComparisonUtil.isValidLineRange(lineOffsets1, range2.start1, range2.end1) || !ComparisonUtil.isValidLineRange(lineOffsets2, range2.start2, range2.end2))) {
            return false;
        }
        DiffIterable iterable = DiffIterableUtil.create(lineRanges, lineOffsets1.getLineCount(), lineOffsets2.getLineCount());
        for (Range range3 : iterable.iterateUnchanged()) {
            List<String> lines2;
            List<String> lines1 = DiffUtil.getLines(content1, lineOffsets1, range3.start1, range3.end1);
            if (lines1.equals(lines2 = DiffUtil.getLines(content2, lineOffsets2, range3.start2, range3.end2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidLineRange(LineOffsets lineOffsets, int start2, int end) {
        return start2 >= 0 && start2 <= end && end <= lineOffsets.getLineCount();
    }

    @Contract(pure=true)
    public static boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            ComparisonUtil.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            ComparisonUtil.$$$reportNull$$$0(6);
        }
        if (policy == null) {
            ComparisonUtil.$$$reportNull$$$0(7);
        }
        switch (policy) {
            case DEFAULT: {
                return StringUtil.equals((CharSequence)text1, (CharSequence)text2);
            }
            case TRIM_WHITESPACES: {
                return ComparisonUtil.equalsTrimWhitespaces(text1, text2);
            }
            case IGNORE_WHITESPACES: {
                return StringUtil.equalsIgnoreWhitespaces((CharSequence)text1, (CharSequence)text2);
            }
        }
        throw new IllegalArgumentException(policy.name());
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        boolean lastLine1;
        if (s1 == null) {
            ComparisonUtil.$$$reportNull$$$0(8);
        }
        if (s2 == null) {
            ComparisonUtil.$$$reportNull$$$0(9);
        }
        int index1 = 0;
        int index2 = 0;
        do {
            CharSequence line2;
            lastLine1 = false;
            boolean lastLine2 = false;
            int end1 = StringUtil.indexOf((CharSequence)s1, (char)'\n', (int)index1) + 1;
            int end2 = StringUtil.indexOf((CharSequence)s2, (char)'\n', (int)index2) + 1;
            if (end1 == 0) {
                end1 = s1.length();
                lastLine1 = true;
            }
            if (end2 == 0) {
                end2 = s2.length();
                lastLine2 = true;
            }
            if (lastLine1 ^ lastLine2) {
                return false;
            }
            CharSequence line1 = s1.subSequence(index1, end1);
            if (!StringUtil.equalsTrimWhitespaces((CharSequence)line1, (CharSequence)(line2 = s2.subSequence(index2, end2)))) {
                return false;
            }
            index1 = end1;
            index2 = end2;
        } while (!lastLine1);
        return true;
    }

    public static int getUnimportantLineCharCount() {
        return UNIMPORTANT_LINE_CHAR_COUNT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRanges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/comparison/ComparisonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquals";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "equalsTrimWhitespaces";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

