/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffChangeUi;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffModel {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final List<SimpleDiffChange> myValidChanges;
    @NotNull
    private final List<SimpleDiffChange> myAllChanges;
    @NotNull
    private ThreeState myIsContentsEqual;
    @NotNull
    private final List<SimpleDiffChangeUi> myPresentations;

    public SimpleDiffModel(@NotNull SimpleDiffViewer viewer) {
        if (viewer == null) {
            SimpleDiffModel.$$$reportNull$$$0(0);
        }
        this.myValidChanges = new ArrayList<SimpleDiffChange>();
        this.myAllChanges = new ArrayList<SimpleDiffChange>();
        this.myIsContentsEqual = ThreeState.UNSURE;
        this.myPresentations = new ArrayList<SimpleDiffChangeUi>();
        this.myViewer = viewer;
    }

    @NotNull
    public ThreeState isContentsEqual() {
        ThreeState threeState = this.myIsContentsEqual;
        if (threeState == null) {
            SimpleDiffModel.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    @NotNull
    public List<SimpleDiffChange> getChanges() {
        List<SimpleDiffChange> list2 = this.myValidChanges;
        if (list2 == null) {
            SimpleDiffModel.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public List<SimpleDiffChange> getAllChanges() {
        List list2 = ContainerUtil.filter(this.myAllChanges, it -> !it.isDestroyed());
        if (list2 == null) {
            SimpleDiffModel.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setChanges(@NotNull List<SimpleDiffChange> changes, boolean isContentsEqual) {
        if (changes == null) {
            SimpleDiffModel.$$$reportNull$$$0(4);
        }
        this.clear();
        for (int i = 0; i < changes.size(); ++i) {
            SimpleDiffChange change = changes.get(i);
            SimpleDiffChange previousChange = i != 0 ? changes.get(i - 1) : null;
            SimpleDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter(previousChange);
            this.myPresentations.add(changeUi);
        }
        this.myValidChanges.addAll(changes);
        this.myAllChanges.addAll(changes);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.clear();
        this.myAllChanges.clear();
        this.myPresentations.clear();
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void destroyChange(@NotNull SimpleDiffChange change) {
        SimpleDiffChangeUi changeUi;
        if (change == null) {
            SimpleDiffModel.$$$reportNull$$$0(5);
        }
        if ((changeUi = (SimpleDiffChangeUi)this.myPresentations.set(change.getIndex(), null)) != null) {
            changeUi.destroyHighlighter();
        }
        this.myValidChanges.remove(change);
        change.markDestroyed();
    }

    public void updateGutterActions(boolean force) {
        for (SimpleDiffChangeUi changeUi : this.myPresentations) {
            if (changeUi == null) continue;
            changeUi.updateGutterActions(force);
        }
    }

    public void handleBeforeDocumentChange(@NotNull Side side, @NotNull DocumentEvent e) {
        if (side == null) {
            SimpleDiffModel.$$$reportNull$$$0(6);
        }
        if (e == null) {
            SimpleDiffModel.$$$reportNull$$$0(7);
        }
        if (this.myValidChanges.isEmpty()) {
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleDiffChange> invalidated = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myValidChanges) {
            if (!change.processDocumentChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalidated.add(change);
            SimpleDiffChangeUi changeUi = this.myPresentations.get(change.getIndex());
            if (changeUi == null) continue;
            changeUi.invalidate();
        }
        this.myValidChanges.removeAll(invalidated);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "isContentsEqual";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "destroyChange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeDocumentChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

