/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class PluginManagerColumnInfo
extends ColumnInfo<IdeaPluginDescriptor, String> {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DOWNLOADS = 1;
    public static final int COLUMN_RATE = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_CATEGORY = 4;
    public static final String[] COLUMNS = new String[]{IdeBundle.message((String)"column.plugins.name", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.downloads", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.rate", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.date", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.category", (Object[])new Object[0])};
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private final int columnIdx;

    public PluginManagerColumnInfo(int columnIdx) {
        super(COLUMNS[columnIdx]);
        this.columnIdx = columnIdx;
    }

    public String valueOf(IdeaPluginDescriptor base) {
        if (this.columnIdx == 0) {
            return base.getName();
        }
        if (this.columnIdx == 1) {
            return base instanceof PluginNode ? ((PluginNode)base).getDownloads() : null;
        }
        if (this.columnIdx == 3) {
            long date;
            long l = date = base instanceof PluginNode ? ((PluginNode)base).getDate() : 0L;
            if (date != 0L) {
                return DateFormatUtil.formatDate((long)date);
            }
            return IdeBundle.message((String)"plugin.info.not.available", (Object[])new Object[0]);
        }
        if (this.columnIdx == 4) {
            return base.getCategory();
        }
        if (this.columnIdx == 2) {
            return ((PluginNode)base).getRating();
        }
        return "";
    }

    public Comparator<IdeaPluginDescriptor> getComparator() {
        return this.getColumnComparator();
    }

    protected Comparator<IdeaPluginDescriptor> getColumnComparator() {
        return (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
    }

    public static String getFormattedSize(String size) {
        if (size.equals("-1")) {
            return IdeBundle.message((String)"plugin.info.unknown", (Object[])new Object[0]);
        }
        return StringUtil.formatFileSize((long)Long.parseLong(size));
    }

    public Class<?> getColumnClass() {
        return this.columnIdx == 1 ? Integer.class : String.class;
    }

    public TableCellRenderer getRenderer(IdeaPluginDescriptor o) {
        return this.columnIdx == 2 ? new PluginRateTableCellRenderer() : new PluginTableCellRenderer((PluginNode)o);
    }

    private static class PluginTableCellRenderer
    extends DefaultTableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final PluginNode myPluginNode;

        private PluginTableCellRenderer(PluginNode pluginNode) {
            this.myLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.myPluginNode = pluginNode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component orig = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            Color bg = orig.getBackground();
            Object grayedFg = isSelected ? orig.getForeground() : JBColor.GRAY;
            this.myLabel.setForeground((Color)grayedFg);
            this.myLabel.setBackground(bg);
            this.myLabel.setOpaque(true);
            if (column == 3) {
                long date = this.myPluginNode.getDate();
                this.myLabel.setText(date != 0L && date != Long.MAX_VALUE ? DateFormatUtil.formatDate((long)date) : IdeBundle.message((String)"label.category.n.a", (Object[])new Object[0]));
                this.myLabel.setHorizontalAlignment(4);
            } else if (column == 1) {
                String downloads = this.myPluginNode.getDownloads();
                this.myLabel.setText(!StringUtil.isEmpty((String)downloads) ? downloads : IdeBundle.message((String)"label.category.n.a", (Object[])new Object[0]));
                this.myLabel.setHorizontalAlignment(4);
            } else if (column == 4) {
                String category = this.myPluginNode.getCategory();
                if (StringUtil.isEmpty((String)category)) {
                    category = this.myPluginNode.getRepositoryName();
                }
                this.myLabel.setText(!StringUtil.isEmpty((String)category) ? category : IdeBundle.message((String)"label.category.n.a", (Object[])new Object[0]));
            }
            if (this.myPluginNode.getStatus() == PluginNode.Status.INSTALLED) {
                PluginId pluginId = this.myPluginNode.getPluginId();
                boolean hasNewerVersion = ourState.hasNewerVersion(pluginId);
                if (hasNewerVersion && !isSelected) {
                    this.myLabel.setBackground(LightColors.BLUE);
                }
            }
            return this.myLabel;
        }
    }

    private static class PluginRateTableCellRenderer
    extends DefaultTableCellRenderer {
        private final RatesPanel myPanel = new RatesPanel();

        private PluginRateTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component orig = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            this.myPanel.setBackground(orig.getBackground());
            if (value2 != null) {
                this.myPanel.setRate((String)value2);
            }
            return this.myPanel;
        }
    }
}

