/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.CountComponent;
import com.intellij.ide.plugins.CountIcon;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginHostsConfigurable;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginListLayout;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponentWithProgress;
import com.intellij.ide.plugins.newui.PluginsTab;
import com.intellij.ide.plugins.newui.SearchPopup;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.SearchUpDownPopupController;
import com.intellij.ide.plugins.newui.TabbedPaneHeaderComponent;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.NoMargin,
Configurable.TopComponentProvider {
    private static final Logger LOG = Logger.getInstance(PluginManagerConfigurable.class);
    public static final String ID = "preferences.pluginManager";
    public static final String SELECTION_TAB_KEY = "PluginConfigurable.selectionTab";
    public static final Color MAIN_BG_COLOR = JBColor.namedColor((String)"Plugins.background", (Color)new JBColor(() -> JBColor.isBright() ? UIUtil.getListBackground() : new Color(0x313335)));
    public static final Color SEARCH_BG_COLOR = JBColor.namedColor((String)"Plugins.SearchField.background", (Color)MAIN_BG_COLOR);
    public static final Color SEARCH_FIELD_BORDER_COLOR = JBColor.namedColor((String)"Plugins.SearchField.borderColor", (Color)new JBColor(0xC5C5C5, 0x515151));
    private static final int MARKETPLACE_TAB = 0;
    private static final int INSTALLED_TAB = 1;
    public static final int ITEMS_PER_GROUP = 9;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    private static final DecimalFormat K_FORMAT = new DecimalFormat("###.#K");
    private static final DecimalFormat M_FORMAT = new DecimalFormat("###.#M");
    private TabbedPaneHeaderComponent myTabHeaderComponent;
    private MultiPanel myCardPanel;
    private PluginsTab myMarketplaceTab;
    private PluginsTab myInstalledTab;
    private PluginsGroupComponentWithProgress myMarketplacePanel;
    private PluginsGroupComponent myInstalledPanel;
    private Runnable myMarketplaceRunnable;
    private SearchResultPanel myMarketplaceSearchPanel;
    private SearchResultPanel myInstalledSearchPanel;
    private final LinkLabel<Object> myUpdateAll = new LinkLabel(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null);
    private final JLabel myUpdateCounter = new CountComponent();
    private final CountIcon myCountIcon = new CountIcon();
    private final MyPluginModel myPluginModel = new MyPluginModel(){

        @Override
        public List<IdeaPluginDescriptor> getAllRepoPlugins() {
            return PluginManagerConfigurable.this.getRepositoryPlugins();
        }
    };
    private PluginUpdatesService myPluginUpdatesService;
    private List<IdeaPluginDescriptor> myAllRepositoryPluginsList;
    private Map<PluginId, IdeaPluginDescriptor> myAllRepositoryPluginsMap;
    private Map<String, List<IdeaPluginDescriptor>> myCustomRepositoryPluginsMap;
    private final Object myRepositoriesLock = new Object();
    private List<String> myTagsSorted;
    private List<String> myVendorsSorted;
    private DefaultActionGroup myMarketplaceSortByGroup;
    private java.util.function.Consumer<MarketplaceSortByAction> myMarketplaceSortByCallback;
    private LinkComponent myMarketplaceSortByAction;
    private DefaultActionGroup myInstalledSearchGroup;
    private java.util.function.Consumer<InstalledSearchOptionAction> myInstalledSearchCallback;
    private boolean myInstalledSearchSetState = true;
    private Collection<PluginDownloader> myInitUpdates;

    public PluginManagerConfigurable() {
    }

    @Deprecated
    public PluginManagerConfigurable(PluginManagerUISettings uiSettings) {
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    }

    @NotNull
    public Component getCenterComponent(@NotNull Configurable.TopComponentController controller) {
        if (controller == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(0);
        }
        this.myPluginModel.setTopController(controller);
        TabbedPaneHeaderComponent tabbedPaneHeaderComponent = this.myTabHeaderComponent;
        if (tabbedPaneHeaderComponent == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(1);
        }
        return tabbedPaneHeaderComponent;
    }

    @Nullable
    public JComponent createComponent() {
        this.myTabHeaderComponent = new TabbedPaneHeaderComponent(this.createGearActions(), index -> {
            this.myCardPanel.select(index, true);
            PluginManagerConfigurable.storeSelectionTab(index);
            String query = (index == 0 ? this.myInstalledTab : this.myMarketplaceTab).getSearchQuery();
            (index == 0 ? this.myMarketplaceTab : this.myInstalledTab).setSearchQuery(query);
        });
        this.myUpdateAll.setVisible(false);
        this.myUpdateCounter.setVisible(false);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.marketplace", (Object[])new Object[0]), null);
        this.myTabHeaderComponent.addTab(IdeBundle.message((String)"plugin.manager.tab.installed", (Object[])new Object[0]), this.myCountIcon);
        java.util.function.Consumer<Integer> callback2 = countValue -> {
            int count = countValue == null ? 0 : countValue;
            String text2 = String.valueOf(count);
            boolean visible = count > 0;
            this.myUpdateAll.setEnabled(true);
            this.myUpdateAll.setVisible(visible);
            this.myUpdateCounter.setText(text2);
            this.myUpdateCounter.setVisible(visible);
            this.myCountIcon.setText(text2);
            this.myTabHeaderComponent.update();
        };
        if (this.myInitUpdates != null) {
            callback2.accept(this.myInitUpdates.size());
        }
        this.myPluginUpdatesService = PluginUpdatesService.connectConfigurable(callback2);
        this.myPluginModel.setPluginUpdatesService(this.myPluginUpdatesService);
        boolean selectInstalledTab = !ContainerUtil.isEmpty(this.myInitUpdates);
        this.createMarketplaceTab();
        this.createInstalledTab();
        this.myCardPanel = new MultiPanel(){

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginManagerConfigurable.this.myMarketplaceTab.createPanel();
                }
                if (key == 1) {
                    return PluginManagerConfigurable.this.myInstalledTab.createPanel();
                }
                return super.create(key);
            }
        };
        this.myCardPanel.setMinimumSize((Dimension)new JBDimension(580, 380));
        this.myCardPanel.setPreferredSize((Dimension)new JBDimension(800, 600));
        this.myTabHeaderComponent.setListener();
        int selectionTab = selectInstalledTab ? 1 : PluginManagerConfigurable.getStoredSelectionTab();
        this.myTabHeaderComponent.setSelection(selectionTab);
        this.myCardPanel.select(selectionTab, true);
        if (selectInstalledTab) {
            this.myInstalledTab.setSearchQuery("/outdated");
        }
        return this.myCardPanel;
    }

    @NotNull
    private DefaultActionGroup createGearActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"plugin.manager.repositories", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)PluginManagerConfigurable.this.myCardPanel, (Configurable)new PluginHostsConfigurable())) {
                    PluginManagerConfigurable.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$3", "actionPerformed"));
            }
        });
        actions.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.http.proxy.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (HttpConfigurable.editConfigurable((JComponent)PluginManagerConfigurable.this.myCardPanel)) {
                    PluginManagerConfigurable.this.resetPanels();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$4", "actionPerformed"));
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new InstallFromDiskAction());
        actions.addSeparator();
        actions.add((AnAction)new ChangePluginStateAction(false));
        actions.add((AnAction)new ChangePluginStateAction(true));
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    private static void showRightBottomPopup(final @NotNull Component component2, @NotNull @Nls String title, @NotNull ActionGroup group) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(3);
        }
        if (title == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(4);
        }
        if (group == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(5);
        }
        GroupByActionGroup actions = new GroupByActionGroup();
        actions.addSeparator("  " + title);
        actions.addAll(group);
        DataContext context = DataManager.getInstance().getDataContext(component2);
        final PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, (ActionGroup)actions, context, false, false, false, true, null, -1, null, null){

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer(this){

                    protected SeparatorWithText createSeparator() {
                        return new SeparatorWithText(){
                            {
                                this.setTextForeground((Color)JBColor.BLACK);
                                this.setCaptionCentered(false);
                            }

                            protected void paintLine(Graphics g, int x, int y, int width) {
                            }
                        };
                    }

                    protected void setSeparatorFont(Font font) {
                        this.mySeparatorComponent.setFont(font);
                    }

                    protected Border getDefaultItemComponentBorder() {
                        return new EmptyBorder((Insets)JBInsets.create((int)UIUtil.getListCellVPadding(), (int)15));
                    }
                };
            }
        };
        popup2.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                Point location2 = component2.getLocationOnScreen();
                Dimension size = popup2.getSize();
                popup2.setLocation(new Point(location2.x + component2.getWidth() - size.width, location2.y + component2.getHeight()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/plugins/PluginManagerConfigurable$6", "beforeShown"));
            }
        });
        popup2.show(component2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPanels() {
        Object object = this.myRepositoriesLock;
        synchronized (object) {
            this.myAllRepositoryPluginsList = null;
            this.myAllRepositoryPluginsMap = null;
            this.myCustomRepositoryPluginsMap = null;
        }
        this.myTagsSorted = null;
        this.myVendorsSorted = null;
        this.myPluginUpdatesService.recalculateUpdates();
        if (this.myMarketplacePanel == null) {
            return;
        }
        int selectionTab = this.myTabHeaderComponent.getSelectionTab();
        if (selectionTab == 0) {
            this.myMarketplaceRunnable.run();
        } else {
            this.myMarketplacePanel.setVisibleRunnable(this.myMarketplaceRunnable);
        }
    }

    private static int getStoredSelectionTab() {
        int value2 = PropertiesComponent.getInstance().getInt(SELECTION_TAB_KEY, 0);
        return value2 < 0 || value2 > 1 ? 0 : value2;
    }

    private static void storeSelectionTab(int value2) {
        PropertiesComponent.getInstance().setValue(SELECTION_TAB_KEY, value2, 0);
    }

    private void createMarketplaceTab() {
        this.myMarketplaceTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(250);
                this.mySearchTextField.setHistoryPropertyName("MarketplacePluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    7.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurable.this.myPluginModel, searchListener, true);
                PluginManagerConfigurable.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    7.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    7.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurable.this.myMarketplacePanel = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginListLayout()), eventHandler, (com.intellij.util.Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((com.intellij.util.Function)d -> new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, (IdeaPluginDescriptor)d, (LinkListener<Object>)this.mySearchListener, true)));
                PluginManagerConfigurable.this.myMarketplacePanel.setSelectionListener(selectionListener);
                PluginManagerConfigurable.registerCopyProvider(PluginManagerConfigurable.this.myMarketplacePanel);
                ((SearchUpDownPopupController)((PluginManagerConfigurable)PluginManagerConfigurable.this).myMarketplaceSearchPanel.controller).setEventHandler(eventHandler);
                Runnable runnable2 = () -> {
                    ArrayList groups = new ArrayList();
                    try {
                        Pair pair = PluginManagerConfigurable.this.loadRepositoryPlugins();
                        Map allRepositoriesMap = (Map)pair.first;
                        Map customRepositoriesMap = (Map)pair.second;
                        try {
                            PluginManagerConfigurable.this.addGroup(groups, allRepositoriesMap, IdeBundle.message((String)"plugins.configurable.featured", (Object[])new Object[0]), "is_featured_search=true", "/sortBy:featured");
                            PluginManagerConfigurable.this.addGroup(groups, allRepositoriesMap, IdeBundle.message((String)"plugins.configurable.new.and.updated", (Object[])new Object[0]), "orderBy=update+date", "/sortBy:updated");
                            PluginManagerConfigurable.this.addGroup(groups, allRepositoriesMap, IdeBundle.message((String)"plugins.configurable.top.downloads", (Object[])new Object[0]), "orderBy=downloads", "/sortBy:downloads");
                            PluginManagerConfigurable.this.addGroup(groups, allRepositoriesMap, IdeBundle.message((String)"plugins.configurable.top.rated", (Object[])new Object[0]), "orderBy=rating", "/sortBy:rating");
                        }
                        catch (IOException e) {
                            LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                        }
                        for (String host : UpdateSettings.getInstance().getPluginHosts()) {
                            List allDescriptors = (List)customRepositoriesMap.get(host);
                            if (allDescriptors == null) continue;
                            PluginManagerConfigurable.this.addGroup(groups, IdeBundle.message((String)"plugins.configurable.repository.0", (Object[])new Object[]{host}), "/repository:\"" + host + "\"", (ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException>)descriptors -> {
                                int allSize = allDescriptors.size();
                                descriptors.addAll(ContainerUtil.getFirstItems((List)allDescriptors, (int)9));
                                PluginsGroup.sortByName(descriptors);
                                return allSize > 9;
                            });
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                    finally {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            PluginManagerConfigurable.this.myMarketplacePanel.stopLoading();
                            PluginLogo.startBatchMode();
                            for (PluginsGroup group : groups) {
                                PluginManagerConfigurable.this.myMarketplacePanel.addGroup(group);
                            }
                            PluginLogo.endBatchMode();
                            PluginManagerConfigurable.this.myMarketplacePanel.doLayout();
                            PluginManagerConfigurable.this.myMarketplacePanel.initialSelection();
                        }, ModalityState.any());
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceRunnable = () -> {
                    PluginManagerConfigurable.this.myMarketplacePanel.clear();
                    PluginManagerConfigurable.this.myMarketplacePanel.startLoading();
                    ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                };
                PluginManagerConfigurable.this.myMarketplacePanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.marketplace.plugins.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"message.check.the.internet.connection.and", (Object[])new Object[0]) + " ", StatusText.DEFAULT_ATTRIBUTES, null).appendSecondaryText(IdeBundle.message((String)"message.link.refresh", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurable.this.myMarketplaceRunnable.run());
                ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                JComponent jComponent = PluginManagerConfigurable.createScrollPane(PluginManagerConfigurable.this.myMarketplacePanel, false);
                if (jComponent == null) {
                    7.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    7.$$$reportNull$$$0(4);
                }
                selectionListener.accept(PluginManagerConfigurable.this.myMarketplacePanel);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    7.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController marketplaceController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        ArrayList<String> attributes = new ArrayList<String>();
                        attributes.add("/tag:");
                        attributes.add("/sortBy:");
                        attributes.add("/vendor:");
                        if (!UpdateSettings.getInstance().getPluginHosts().isEmpty()) {
                            attributes.add("/repository:");
                        }
                        ArrayList<String> arrayList = attributes;
                        if (arrayList == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return arrayList;
                    }

                    @Override
                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        switch (attribute) {
                            case "/tag:": {
                                if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurable.this.myTagsSorted)) {
                                    HashSet<String> allTags = new HashSet<String>();
                                    for (IdeaPluginDescriptor descriptor2 : PluginManagerConfigurable.this.getRepositoryPlugins()) {
                                        List<String> tags;
                                        if (!(descriptor2 instanceof PluginNode) || ContainerUtil.isEmpty(tags = ((PluginNode)descriptor2).getTags())) continue;
                                        allTags.addAll(tags);
                                    }
                                    PluginManagerConfigurable.this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
                                }
                                return PluginManagerConfigurable.this.myTagsSorted;
                            }
                            case "/sortBy:": {
                                return Arrays.asList("downloads", "name", "rating", "updated");
                            }
                            case "/vendor:": {
                                if (ContainerUtil.isEmpty((Collection)PluginManagerConfigurable.this.myVendorsSorted)) {
                                    PluginManagerConfigurable.this.myVendorsSorted = MyPluginModel.getVendors(PluginManagerConfigurable.this.getRepositoryPlugins());
                                }
                                return PluginManagerConfigurable.this.myVendorsSorted;
                            }
                            case "/repository:": {
                                return UpdateSettings.getInstance().getPluginHosts();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    @Override
                    protected void handleEnter() {
                        if (!mySearchTextField.getText().isEmpty()) {
                            this.handleTrigger("marketplace.suggest.popup.enter");
                        }
                    }

                    @Override
                    protected void handlePopupListFirstSelection() {
                        this.handleTrigger("marketplace.suggest.popup.select");
                    }

                    private void handleTrigger(@NonNls String key) {
                        if (this.myPopup != null && this.myPopup.type == SearchPopup.Type.SearchQuery) {
                            FeatureUsageTracker.getInstance().triggerFeatureUsed(key);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceSortByGroup = new DefaultActionGroup();
                for (SortBySearchOption option2 : SortBySearchOption.values()) {
                    PluginManagerConfigurable.this.myMarketplaceSortByGroup.addAction((AnAction)new MarketplaceSortByAction(option2));
                }
                PluginManagerConfigurable.this.myMarketplaceSortByAction = new LinkComponent(){

                    protected boolean isInClickableArea(Point pt) {
                        return true;
                    }
                };
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setIcon(new Icon(){

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        this.getIcon().paintIcon(c, g, x, y + 1);
                    }

                    @Override
                    public int getIconWidth() {
                        return this.getIcon().getIconWidth();
                    }

                    @Override
                    public int getIconHeight() {
                        return this.getIcon().getIconHeight();
                    }

                    @NotNull
                    private Icon getIcon() {
                        Icon icon2 = AllIcons.General.ButtonDropTriangle;
                        if (icon2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return icon2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurable$7$3", "getIcon"));
                    }
                });
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setPaintUnderline(false);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setIconTextGap(JBUIScale.scale((int)4));
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setHorizontalTextPosition(2);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
                PluginManagerConfigurable.this.myMarketplaceSortByAction.setListener((component2, __) -> PluginManagerConfigurable.showRightBottomPopup(component2.getParent().getParent(), IdeBundle.message((String)"plugins.configurable.sort.by", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurable.this.myMarketplaceSortByGroup), null);
                PluginManagerConfigurable.this.myMarketplaceSortByCallback = updateAction -> {
                    String query;
                    MarketplaceSortByAction removeAction = null;
                    MarketplaceSortByAction addAction = null;
                    if (((MarketplaceSortByAction)updateAction).myState) {
                        for (AnAction action2 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                            if (sortByAction == updateAction || !sortByAction.myState) continue;
                            sortByAction.myState = false;
                            removeAction = sortByAction;
                            break;
                        }
                        addAction = updateAction;
                    } else {
                        if (((MarketplaceSortByAction)updateAction).myOption == SortBySearchOption.Relevance) {
                            ((MarketplaceSortByAction)updateAction).myState = true;
                            return;
                        }
                        for (AnAction action3 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                            MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action3;
                            if (sortByAction.myOption != SortBySearchOption.Relevance) continue;
                            sortByAction.myState = true;
                            break;
                        }
                        removeAction = updateAction;
                    }
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Marketplace(this.mySearchTextField.getText()){

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
                            if (name == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            if (value2 == null) {
                                4.$$$reportNull$$$0(2);
                            }
                            queries.add(name + SearchQueryParser.wrapAttribute(value2));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$4";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (removeAction != null && (query = removeAction.getQuery()) != null) {
                        queries.remove(query);
                    }
                    if (addAction != null && (query = addAction.getQuery()) != null) {
                        queries.add(query);
                    }
                    query = StringUtil.join(queries, (String)" ");
                    this.mySearchTextField.setTextIgnoreEvents(query);
                    if (query.isEmpty()) {
                        PluginManagerConfigurable.this.myMarketplaceTab.hideSearchPanel();
                    } else {
                        PluginManagerConfigurable.this.myMarketplaceTab.showSearchPanel(query);
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                marketplaceController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponentWithProgress panel2 = new PluginsGroupComponentWithProgress((LayoutManager)((Object)new PluginListLayout()), eventHandler, (com.intellij.util.Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((com.intellij.util.Function)descriptor2 -> new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, (LinkListener<Object>)this.mySearchListener, true)));
                panel2.setSelectionListener(selectionListener);
                PluginManagerConfigurable.registerCopyProvider(panel2);
                PluginManagerConfigurable.this.myMarketplaceSearchPanel = new SearchResultPanel(marketplaceController, panel2, 0, 0){

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                        if (query == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (result2 == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        try {
                            Pair p = PluginManagerConfigurable.this.loadRepositoryPlugins();
                            Map allRepositoriesMap = (Map)p.first;
                            Map customRepositoriesMap = (Map)p.second;
                            SearchQueryParser.Marketplace parser = new SearchQueryParser.Marketplace(query);
                            if (!parser.vendors.isEmpty()) {
                                for (IdeaPluginDescriptor descriptor2 : PluginManagerConfigurable.this.getRepositoryPlugins()) {
                                    if (!MyPluginModel.isVendor(descriptor2, parser.vendors)) continue;
                                    result2.descriptors.add(descriptor2);
                                }
                                ContainerUtil.removeDuplicates(result2.descriptors);
                                result2.sortByName();
                                return;
                            }
                            if (!parser.repositories.isEmpty()) {
                                for (String repository : parser.repositories) {
                                    List descriptors = (List)customRepositoriesMap.get(repository);
                                    if (descriptors == null) continue;
                                    if (parser.searchQuery == null) {
                                        result2.descriptors.addAll(descriptors);
                                        continue;
                                    }
                                    for (IdeaPluginDescriptor descriptor3 : descriptors) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor3.getName(), (String)parser.searchQuery)) continue;
                                        result2.descriptors.add(descriptor3);
                                    }
                                }
                                ContainerUtil.removeDuplicates(result2.descriptors);
                                result2.sortByName();
                                return;
                            }
                            Url url = PluginRepositoryRequests.createSearchUrl(parser.getUrlQuery(), 10000);
                            for (PluginId pluginId : PluginRepositoryRequests.requestToPluginRepository(url)) {
                                IdeaPluginDescriptor descriptor4 = (IdeaPluginDescriptor)allRepositoriesMap.get(pluginId);
                                if (descriptor4 == null) continue;
                                result2.descriptors.add(descriptor4);
                            }
                            if (parser.searchQuery != null) {
                                String builtinUrl = ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl();
                                ArrayList builtinList = new ArrayList();
                                for (Map.Entry entry : customRepositoriesMap.entrySet()) {
                                    List<Object> descriptors = ((String)entry.getKey()).equals(builtinUrl) ? builtinList : result2.descriptors;
                                    for (IdeaPluginDescriptor descriptor5 : (List)entry.getValue()) {
                                        if (!StringUtil.containsIgnoreCase((String)descriptor5.getName(), (String)parser.searchQuery)) continue;
                                        descriptors.add(descriptor5);
                                    }
                                }
                                result2.descriptors.addAll(0, builtinList);
                            }
                            if (result2.descriptors.isEmpty() && "/tag:Paid".equals(query)) {
                                for (IdeaPluginDescriptor descriptor6 : PluginManagerConfigurable.this.getRepositoryPlugins()) {
                                    if (descriptor6.getProductCode() == null) continue;
                                    result2.descriptors.add(descriptor6);
                                }
                                result2.sortByName();
                            }
                            ContainerUtil.removeDuplicates(result2.descriptors);
                            if (!result2.descriptors.isEmpty()) {
                                String title = "Sort By";
                                for (AnAction action2 : PluginManagerConfigurable.this.myMarketplaceSortByGroup.getChildren(null)) {
                                    MarketplaceSortByAction sortByAction = (MarketplaceSortByAction)action2;
                                    sortByAction.setState(parser);
                                    if (!sortByAction.myState) continue;
                                    title = "Sort By: " + sortByAction.myOption.name();
                                }
                                PluginManagerConfigurable.this.myMarketplaceSortByAction.setText(title);
                                result2.addRightAction((JComponent)((Object)PluginManagerConfigurable.this.myMarketplaceSortByAction));
                            }
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            ApplicationManager.getApplication().invokeLater(() -> this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.search.result.not.loaded", (Object[])new Object[0])).appendSecondaryText(IdeBundle.message((String)"plugins.configurable.check.internet", (Object[])new Object[0]), StatusText.DEFAULT_ATTRIBUTES, null), ModalityState.any());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "query";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "result";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7$5";
                        objectArray[2] = "handleQuery";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurable.this.myMarketplaceSearchPanel;
                if (searchResultPanel == null) {
                    7.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$7";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private void createInstalledTab() {
        this.myInstalledSearchGroup = new DefaultActionGroup();
        for (InstalledSearchOption option2 : InstalledSearchOption.values()) {
            this.myInstalledSearchGroup.add((AnAction)new InstalledSearchOptionAction(option2));
        }
        this.myInstalledTab = new PluginsTab(){

            @Override
            protected void createSearchTextField(int flyDelay) {
                super.createSearchTextField(flyDelay);
                JBTextField textField2 = this.mySearchTextField.getTextEditor();
                textField2.putClientProperty((Object)"search.extension", (Object)ExtendableTextComponent.Extension.create((Icon)AllIcons.Actions.More, (Icon)AllIcons.Actions.More, (String)IdeBundle.message((String)"plugins.configurable.search.options", (Object[])new Object[0]), () -> PluginManagerConfigurable.showRightBottomPopup((Component)textField2, IdeBundle.message((String)"plugins.configurable.show", (Object[])new Object[0]), (ActionGroup)PluginManagerConfigurable.this.myInstalledSearchGroup)));
                textField2.putClientProperty((Object)"JTextField.variant", null);
                textField2.putClientProperty((Object)"JTextField.variant", (Object)"search");
                this.mySearchTextField.setHistoryPropertyName("InstalledPluginsSearchHistory");
            }

            @Override
            @NotNull
            protected PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> searchListener) {
                if (searchListener == null) {
                    8.$$$reportNull$$$0(0);
                }
                PluginDetailsPageComponent detailPanel = new PluginDetailsPageComponent(PluginManagerConfigurable.this.myPluginModel, searchListener, false);
                PluginManagerConfigurable.this.myPluginModel.addDetailPanel(detailPanel);
                PluginDetailsPageComponent pluginDetailsPageComponent = detailPanel;
                if (pluginDetailsPageComponent == null) {
                    8.$$$reportNull$$$0(1);
                }
                return pluginDetailsPageComponent;
            }

            @Override
            @NotNull
            protected JComponent createPluginsPanel(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(2);
                }
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                PluginManagerConfigurable.this.myInstalledPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (com.intellij.util.Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((com.intellij.util.Function)descriptor2 -> new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, (LinkListener<Object>)this.mySearchListener, false)));
                PluginManagerConfigurable.this.myInstalledPanel.setSelectionListener(selectionListener);
                PluginManagerConfigurable.registerCopyProvider(PluginManagerConfigurable.this.myInstalledPanel);
                ((SearchUpDownPopupController)((PluginManagerConfigurable)PluginManagerConfigurable.this).myInstalledSearchPanel.controller).setEventHandler(eventHandler);
                PluginLogo.startBatchMode();
                PluginsGroup installing = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.installing", (Object[])new Object[0]));
                installing.descriptors.addAll(MyPluginModel.getInstallingPlugins());
                if (!installing.descriptors.isEmpty()) {
                    installing.sortByName();
                    installing.titleWithCount();
                    PluginManagerConfigurable.this.myInstalledPanel.addGroup(installing);
                }
                PluginsGroup downloaded = new PluginsGroup(IdeBundle.message((String)"plugins.configurable.downloaded", (Object[])new Object[0]));
                downloaded.descriptors.addAll(InstalledPluginsState.getInstance().getInstalledPlugins());
                HashMap<String, ArrayList<IdeaPluginDescriptor>> bundledGroups = new HashMap<String, ArrayList<IdeaPluginDescriptor>>();
                ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
                int downloadedEnabled = 0;
                boolean hideImplDetails = PluginManager.getInstance().hideImplementationDetails();
                String otherCategoryTitle = IdeBundle.message((String)"plugins.configurable.other.bundled", (Object[])new Object[0]);
                for (IdeaPluginDescriptor descriptor3 : PluginManagerCore.getPlugins()) {
                    if (appInfo.isEssentialPlugin(descriptor3.getPluginId())) continue;
                    if (descriptor3.isBundled()) {
                        if (hideImplDetails && descriptor3.isImplementationDetail()) continue;
                        String category = StringUtil.defaultIfEmpty((String)descriptor3.getCategory(), (String)otherCategoryTitle);
                        ArrayList<IdeaPluginDescriptor> groupDescriptors = (ArrayList<IdeaPluginDescriptor>)bundledGroups.get(category);
                        if (groupDescriptors == null) {
                            groupDescriptors = new ArrayList<IdeaPluginDescriptor>();
                            bundledGroups.put(category, groupDescriptors);
                        }
                        groupDescriptors.add(descriptor3);
                        continue;
                    }
                    downloaded.descriptors.add(descriptor3);
                    if (!descriptor3.isEnabled()) continue;
                    ++downloadedEnabled;
                }
                if (!downloaded.descriptors.isEmpty()) {
                    PluginManagerConfigurable.this.myUpdateAll.setListener((LinkListener)new LinkListener<Object>(){

                        public void linkSelected(LinkLabel aSource, Object aLinkData) {
                            PluginManagerConfigurable.this.myUpdateAll.setEnabled(false);
                            for (UIPluginGroup group : PluginManagerConfigurable.this.myInstalledPanel.getGroups()) {
                                for (ListPluginComponent plugin : group.plugins) {
                                    plugin.updatePlugin();
                                }
                            }
                        }
                    }, null);
                    downloaded.addRightAction((JComponent)PluginManagerConfigurable.this.myUpdateAll);
                    downloaded.addRightAction(PluginManagerConfigurable.this.myUpdateCounter);
                    downloaded.sortByName();
                    downloaded.titleWithCount(downloadedEnabled);
                    PluginManagerConfigurable.this.myInstalledPanel.addGroup(downloaded);
                    PluginManagerConfigurable.this.myPluginModel.addEnabledGroup(downloaded);
                }
                PluginManagerConfigurable.this.myPluginModel.setDownloadedGroup(PluginManagerConfigurable.this.myInstalledPanel, downloaded, installing);
                ArrayList<PluginsGroup> groups = new ArrayList<PluginsGroup>();
                for (Map.Entry entry : bundledGroups.entrySet()) {
                    PluginsGroup group2 = new PluginsGroup((String)entry.getKey()){

                        @Override
                        public void titleWithCount(int enabled) {
                            this.rightAction.setText(enabled == 0 ? IdeBundle.message((String)"plugins.configurable.enable.all", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all", (Object[])new Object[0]));
                        }
                    };
                    group2.descriptors.addAll((Collection)entry.getValue());
                    group2.sortByName();
                    group2.rightAction = new LinkLabel("", null, (__, ___) -> PluginManagerConfigurable.this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])ContainerUtil.toArray(group.descriptors, IdeaPluginDescriptor[]::new), group.rightAction.getText().startsWith("Enable")));
                    group2.titleWithEnabled(PluginManagerConfigurable.this.myPluginModel);
                    groups.add(group2);
                }
                ContainerUtil.sort(groups, (o1, o2) -> StringUtil.compare((String)o1.title, (String)o2.title, (boolean)true));
                PluginsGroup otherGroup = (PluginsGroup)ContainerUtil.find(groups, group -> group.title.equals(otherCategoryTitle));
                if (otherGroup != null) {
                    groups.remove(otherGroup);
                    groups.add(otherGroup);
                }
                for (PluginsGroup group2 : groups) {
                    PluginManagerConfigurable.this.myInstalledPanel.addGroup(group2);
                    PluginManagerConfigurable.this.myPluginModel.addEnabledGroup(group2);
                }
                PluginManagerConfigurable.this.myPluginUpdatesService.connectInstalled(updates -> {
                    if (ContainerUtil.isEmpty((Collection)updates)) {
                        PluginManagerConfigurable.clearUpdates(PluginManagerConfigurable.this.myInstalledPanel);
                        PluginManagerConfigurable.clearUpdates(PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel());
                    } else {
                        PluginManagerConfigurable.applyUpdates(PluginManagerConfigurable.this.myInstalledPanel, updates);
                        PluginManagerConfigurable.applyUpdates(PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel(), updates);
                    }
                    selectionListener.accept(PluginManagerConfigurable.this.myInstalledPanel);
                });
                PluginLogo.endBatchMode();
                if (PluginManagerConfigurable.this.myInitUpdates != null) {
                    PluginManagerConfigurable.applyUpdates(PluginManagerConfigurable.this.myInstalledPanel, PluginManagerConfigurable.this.myInitUpdates);
                }
                JComponent jComponent = PluginManagerConfigurable.createScrollPane(PluginManagerConfigurable.this.myInstalledPanel, true);
                if (jComponent == null) {
                    8.$$$reportNull$$$0(3);
                }
                return jComponent;
            }

            @Override
            protected void updateMainSelection(@NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(4);
                }
                selectionListener.accept(PluginManagerConfigurable.this.myInstalledPanel);
            }

            @Override
            public void hideSearchPanel() {
                super.hideSearchPanel();
                if (PluginManagerConfigurable.this.myInstalledSearchSetState) {
                    for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                        ((InstalledSearchOptionAction)action2).setState(null);
                    }
                }
                PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
            }

            @Override
            @NotNull
            protected SearchResultPanel createSearchPanel(final @NotNull java.util.function.Consumer<? super PluginsGroupComponent> selectionListener) {
                if (selectionListener == null) {
                    8.$$$reportNull$$$0(5);
                }
                SearchUpDownPopupController installedController = new SearchUpDownPopupController(this.mySearchTextField){

                    @Override
                    @NotNull
                    protected List<String> getAttributes() {
                        List<String> list2 = Arrays.asList("/downloaded", "/outdated", "/enabled", "/disabled", "/invalid", "/bundled", "/vendor:", "/tag:");
                        if (list2 == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }

                    @Override
                    @Nullable
                    protected List<String> getValues(@NotNull String attribute) {
                        if (attribute == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if ("/vendor:".equals(attribute)) {
                            return PluginManagerConfigurable.this.myPluginModel.getVendors();
                        }
                        if ("/tag:".equals(attribute)) {
                            return PluginManagerConfigurable.this.myPluginModel.getTags();
                        }
                        return null;
                    }

                    @Override
                    protected void showPopupForQuery() {
                        this.showSearchPanel(mySearchTextField.getText());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$8$3";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attribute";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getAttributes";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$8$3";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "getValues";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
                installedController.setSearchResultEventHandler(eventHandler);
                PluginsGroupComponent panel2 = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (com.intellij.util.Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((com.intellij.util.Function)descriptor2 -> new ListPluginComponent(PluginManagerConfigurable.this.myPluginModel, (IdeaPluginDescriptor)descriptor2, (LinkListener<Object>)this.mySearchListener, false)));
                panel2.setSelectionListener(selectionListener);
                PluginManagerConfigurable.registerCopyProvider(panel2);
                PluginManagerConfigurable.this.myInstalledSearchCallback = updateAction -> {
                    final ArrayList<String> queries = new ArrayList<String>();
                    new SearchQueryParser.Installed(this.mySearchTextField.getText(), (InstalledSearchOptionAction)((Object)updateAction)){
                        final /* synthetic */ InstalledSearchOptionAction val$updateAction;
                        {
                            this.val$updateAction = installedSearchOptionAction;
                            super(query);
                        }

                        @Override
                        protected void addToSearchQuery(@NotNull String query) {
                            if (query == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            queries.add(query);
                        }

                        @Override
                        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
                            if (name == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            if (value2 == null) {
                                4.$$$reportNull$$$0(2);
                            }
                            if (!this.val$updateAction.myState) {
                                queries.add(name + (value2.isEmpty() ? "" : SearchQueryParser.wrapAttribute(value2)));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "query";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "value";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$8$4";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "addToSearchQuery";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "handleAttribute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    if (((InstalledSearchOptionAction)updateAction).myState) {
                        for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                            if (action2 == updateAction) continue;
                            ((InstalledSearchOptionAction)action2).myState = false;
                        }
                        queries.add(updateAction.getQuery());
                    } else {
                        queries.remove(updateAction.getQuery());
                    }
                    try {
                        PluginManagerConfigurable.this.myInstalledSearchSetState = false;
                        String query = StringUtil.join(queries, (String)" ");
                        this.mySearchTextField.setTextIgnoreEvents(query);
                        if (query.isEmpty()) {
                            PluginManagerConfigurable.this.myInstalledTab.hideSearchPanel();
                        } else {
                            PluginManagerConfigurable.this.myInstalledTab.showSearchPanel(query);
                        }
                    }
                    finally {
                        PluginManagerConfigurable.this.myInstalledSearchSetState = true;
                    }
                };
                PluginManagerConfigurable.this.myInstalledSearchPanel = new SearchResultPanel(installedController, panel2, 0, 0){

                    @Override
                    protected void setEmptyText() {
                        this.myPanel.getEmptyText().setText(IdeBundle.message((String)"plugins.configurable.nothing.found", (Object[])new Object[0]));
                        this.myPanel.getEmptyText().appendSecondaryText(IdeBundle.message((String)"plugins.configurable.search.in.marketplace", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> PluginManagerConfigurable.this.myTabHeaderComponent.setSelectionWithEvents(0));
                    }

                    @Override
                    protected void handleQuery(@NotNull String query, @NotNull PluginsGroup result2) {
                        if (query == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (result2 == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                        SearchQueryParser.Installed parser = new SearchQueryParser.Installed(query);
                        if (PluginManagerConfigurable.this.myInstalledSearchSetState) {
                            for (AnAction action2 : PluginManagerConfigurable.this.myInstalledSearchGroup.getChildren(null)) {
                                ((InstalledSearchOptionAction)action2).setState(parser);
                            }
                        }
                        List<IdeaPluginDescriptor> descriptors = PluginManagerConfigurable.this.myPluginModel.getInstalledDescriptors();
                        if (!parser.vendors.isEmpty()) {
                            Iterator<IdeaPluginDescriptor> I = descriptors.iterator();
                            while (I.hasNext()) {
                                if (MyPluginModel.isVendor(I.next(), parser.vendors)) continue;
                                I.remove();
                            }
                        }
                        if (!parser.tags.isEmpty()) {
                            Iterator<IdeaPluginDescriptor> I = descriptors.iterator();
                            while (I.hasNext()) {
                                if (ContainerUtil.intersects(PluginManagerConfigurable.getTags(I.next()), parser.tags)) continue;
                                I.remove();
                            }
                        }
                        Iterator<IdeaPluginDescriptor> I = descriptors.iterator();
                        while (I.hasNext()) {
                            IdeaPluginDescriptor descriptor2 = I.next();
                            if (parser.attributes) {
                                if (parser.enabled && (!PluginManagerConfigurable.this.myPluginModel.isEnabled(descriptor2) || PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2))) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.disabled && (PluginManagerConfigurable.this.myPluginModel.isEnabled(descriptor2) || PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2))) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.bundled && !descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.downloaded && descriptor2.isBundled()) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.invalid && !PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2)) {
                                    I.remove();
                                    continue;
                                }
                                if (parser.needUpdate && !PluginUpdatesService.isNeedUpdate(descriptor2)) {
                                    I.remove();
                                    continue;
                                }
                            }
                            if (parser.searchQuery == null || StringUtil.containsIgnoreCase((String)descriptor2.getName(), (String)parser.searchQuery)) continue;
                            I.remove();
                        }
                        result2.descriptors.addAll(descriptors);
                        if (!result2.descriptors.isEmpty()) {
                            if (parser.invalid) {
                                PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(() -> {
                                    PluginsGroup group = PluginManagerConfigurable.this.myInstalledSearchPanel.getGroup();
                                    if (group.ui == null) {
                                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                                        return;
                                    }
                                    PluginsGroupComponent resultPanel = PluginManagerConfigurable.this.myInstalledSearchPanel.getPanel();
                                    for (IdeaPluginDescriptor descriptor2 : new ArrayList<IdeaPluginDescriptor>(group.descriptors)) {
                                        if (PluginManagerConfigurable.this.myPluginModel.hasErrors(descriptor2)) continue;
                                        resultPanel.removeFromGroup(group, descriptor2);
                                    }
                                    group.titleWithCount();
                                    PluginManagerConfigurable.this.myInstalledSearchPanel.fullRepaint();
                                    if (group.descriptors.isEmpty()) {
                                        PluginManagerConfigurable.this.myPluginModel.setInvalidFixCallback(null);
                                    }
                                });
                            } else if (parser.needUpdate) {
                                result2.rightAction = new LinkLabel(IdeBundle.message((String)"plugin.manager.update.all", (Object[])new Object[0]), null, (__, ___) -> {
                                    result2.rightAction.setEnabled(false);
                                    for (ListPluginComponent plugin : result2.ui.plugins) {
                                        plugin.updatePlugin();
                                    }
                                });
                            }
                            Collection updates = PluginManagerConfigurable.this.myInitUpdates == null ? PluginUpdatesService.getUpdates() : PluginManagerConfigurable.this.myInitUpdates;
                            PluginManagerConfigurable.this.myInitUpdates = null;
                            if (!ContainerUtil.isEmpty((Collection)updates)) {
                                this.myPostFillGroupCallback = () -> {
                                    PluginManagerConfigurable.applyUpdates(this.myPanel, updates);
                                    selectionListener.accept(PluginManagerConfigurable.this.myInstalledPanel);
                                };
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "query";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "result";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$8$5";
                        objectArray[2] = "handleQuery";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                SearchResultPanel searchResultPanel = PluginManagerConfigurable.this.myInstalledSearchPanel;
                if (searchResultPanel == null) {
                    8.$$$reportNull$$$0(6);
                }
                return searchResultPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchListener";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$8";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectionListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$8";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDetailsPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPluginsPanel";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createSearchPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDetailsPanel";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createPluginsPanel";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateMainSelection";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSearchPanel";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void clearUpdates(@NotNull PluginsGroupComponent panel2) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(6);
        }
        for (UIPluginGroup group : panel2.getGroups()) {
            for (ListPluginComponent plugin : group.plugins) {
                plugin.setUpdateDescriptor(null);
            }
        }
    }

    private static void applyUpdates(@NotNull PluginsGroupComponent panel2, @NotNull Collection<PluginDownloader> updates) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(7);
        }
        if (updates == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(8);
        }
        block0: for (PluginDownloader downloader : updates) {
            IdeaPluginDescriptor descriptor2 = downloader.getDescriptor();
            for (UIPluginGroup group : panel2.getGroups()) {
                ListPluginComponent component2 = group.findComponent(descriptor2);
                if (component2 == null) continue;
                component2.setUpdateDescriptor(descriptor2);
                continue block0;
            }
        }
    }

    public static void registerCopyProvider(final @NotNull PluginsGroupComponent component2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(9);
        }
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    9.$$$reportNull$$$0(0);
                }
                StringBuilder result2 = new StringBuilder();
                for (ListPluginComponent pluginComponent : component2.getSelection()) {
                    result2.append(pluginComponent.myPlugin.getName()).append(" (").append(pluginComponent.myPlugin.getVersion()).append(")\n");
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(result2.substring(0, result2.length() - 1)));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    9.$$$reportNull$$$0(1);
                }
                return !component2.getSelection().isEmpty();
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    9.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)component2), dataId -> PlatformDataKeys.COPY_PROVIDER.is(dataId) ? copyProvider : null);
    }

    @NotNull
    public static List<String> getTags(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(10);
        }
        List<String> tags = null;
        String productCode = plugin.getProductCode();
        if (plugin instanceof PluginNode) {
            tags = ((PluginNode)plugin).getTags();
            if (productCode != null && tags != null && !tags.contains("Paid")) {
                tags = new ArrayList<String>(tags);
                tags.add(0, "Paid");
            }
        } else if (productCode != null) {
            String stamp;
            LicensingFacade instance = LicensingFacade.getInstance();
            if (instance != null && (stamp = instance.getConfirmationStamp(productCode)) != null) {
                List<String> list2 = Collections.singletonList(stamp.startsWith("eval:") ? "Trial" : "Purchased");
                if (list2 == null) {
                    PluginManagerConfigurable.$$$reportNull$$$0(11);
                }
                return list2;
            }
            List<String> list3 = Collections.singletonList("Paid");
            if (list3 == null) {
                PluginManagerConfigurable.$$$reportNull$$$0(12);
            }
            return list3;
        }
        if (ContainerUtil.isEmpty(tags)) {
            List<String> list4 = Collections.emptyList();
            if (list4 == null) {
                PluginManagerConfigurable.$$$reportNull$$$0(13);
            }
            return list4;
        }
        if (tags.size() > 1) {
            if ((tags = new ArrayList<String>(tags)).remove("EAP")) {
                tags.add(0, "EAP");
            }
            if (tags.remove("Paid")) {
                tags.add(0, "Paid");
            }
        }
        List<String> list5 = tags;
        if (list5 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(14);
        }
        return list5;
    }

    @NotNull
    public static <T extends Component> T setTinyFont(@NotNull T component2) {
        if (component2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(15);
        }
        Object object = SystemInfo.isMac ? RelativeFont.TINY.install(component2) : component2;
        if (object == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(16);
        }
        return object;
    }

    public static int offset5() {
        return JBUIScale.scale((int)5);
    }

    @Nullable
    public static synchronized String getDownloads(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(17);
        }
        String downloads = null;
        if (plugin instanceof PluginNode) {
            downloads = ((PluginNode)plugin).getDownloads();
        }
        return PluginManagerConfigurable.getFormatLength(downloads);
    }

    @Nullable
    static synchronized String getFormatLength(@Nullable String len) {
        if (!StringUtil.isEmptyOrSpaces((String)len)) {
            try {
                long value2 = Long.parseLong(len);
                if (value2 > 1000L) {
                    return value2 < 1000000L ? K_FORMAT.format((double)value2 / 1000.0) : M_FORMAT.format((double)value2 / 1000000.0);
                }
                return Long.toString(value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static synchronized String getLastUpdatedDate(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(18);
        }
        long date = 0L;
        if (plugin instanceof PluginNode) {
            date = ((PluginNode)plugin).getDate();
        }
        return date > 0L && date != Long.MAX_VALUE ? DATE_FORMAT.format(new Date(date)) : null;
    }

    @Nullable
    public static String getRating(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(19);
        }
        String rating = null;
        if (plugin instanceof PluginNode) {
            rating = ((PluginNode)plugin).getRating();
        }
        if (rating != null) {
            try {
                if (Double.valueOf(rating) > 0.0) {
                    return StringUtil.trimEnd((String)rating, (String)".0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static synchronized String getSize(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(20);
        }
        String size = null;
        if (plugin instanceof PluginNode) {
            size = ((PluginNode)plugin).getSize();
        }
        return PluginManagerConfigurable.getFormatLength(size);
    }

    @NotNull
    public static String getVersion(@NotNull IdeaPluginDescriptor oldPlugin, @NotNull IdeaPluginDescriptor newPlugin) {
        if (oldPlugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(21);
        }
        if (newPlugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(22);
        }
        String string = StringUtil.defaultIfEmpty((String)oldPlugin.getVersion(), (String)"unknown") + " " + UIUtil.rightArrow() + " " + StringUtil.defaultIfEmpty((String)newPlugin.getVersion(), (String)"unknown");
        if (string == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Messages.YesNoResult
    public static int showRestartDialog() {
        return PluginManagerConfigurable.showRestartDialog(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NotNull String title) {
        if (title == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(24);
        }
        return PluginManagerConfigurable.showRestartDialog(title, action2 -> IdeBundle.message((String)"ide.restart.required.message", (Object[])new Object[]{action2, ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    @Messages.YesNoResult
    public static int showRestartDialog(@NotNull String title, @NotNull Function<String, String> message) {
        if (title == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(25);
        }
        if (message == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(26);
        }
        String action2 = IdeBundle.message((String)(ApplicationManager.getApplication().isRestartCapable() ? "ide.restart.action" : "ide.shutdown.action"), (Object[])new Object[0]);
        return Messages.showYesNoDialog((String)message.apply(action2), (String)title, (String)action2, (String)IdeBundle.message((String)"ide.notnow.action", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
    }

    public static void shutdownOrRestartApp() {
        PluginManagerConfigurable.shutdownOrRestartApp(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]));
    }

    public static void shutdownOrRestartApp(@NotNull String title) {
        if (title == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(27);
        }
        if (PluginManagerConfigurable.showRestartDialog(title) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public static void shutdownOrRestartAppAfterInstall(@NotNull String plugin) {
        Function<String, String> message;
        String title;
        if (plugin == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(28);
        }
        if (PluginManagerConfigurable.showRestartDialog(title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), message = action2 -> IdeBundle.message((String)"plugin.installed.ide.restart.required.message", (Object[])new Object[]{plugin, action2, ApplicationNamesInfo.getInstance().getFullProductName()})) == 0) {
            ApplicationManagerEx.getApplicationEx().restart(true);
        }
    }

    public static void showPluginConfigurableAndEnable(@Nullable Project project, IdeaPluginDescriptor ... descriptors) {
        if (descriptors == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(29);
        }
        PluginManagerConfigurable configurable2 = new PluginManagerConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> {
            configurable2.getPluginModel().changeEnableDisable(descriptors, true);
            configurable2.select(descriptors);
        });
    }

    public static void showPluginConfigurable(@Nullable Project project, IdeaPluginDescriptor ... descriptors) {
        if (descriptors == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(30);
        }
        PluginManagerConfigurable configurable2 = new PluginManagerConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> configurable2.select(descriptors));
    }

    public static void showPluginConfigurable(@Nullable Project project, @NotNull Collection<PluginDownloader> updates) {
        if (updates == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(31);
        }
        PluginManagerConfigurable configurable2 = new PluginManagerConfigurable();
        configurable2.setInitUpdates(updates);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2);
    }

    @NotNull
    public static JComponent createScrollPane(@NotNull PluginsGroupComponent panel2, boolean initSelection) {
        if (panel2 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(32);
        }
        JBScrollPane pane2 = new JBScrollPane((Component)((Object)panel2), 20, 31);
        pane2.setBorder((Border)JBUI.Borders.empty());
        if (initSelection) {
            panel2.initialSelection();
        }
        JBScrollPane jBScrollPane = pane2;
        if (jBScrollPane == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(33);
        }
        return jBScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<IdeaPluginDescriptor> getRepositoryPlugins() {
        block9: {
            List<IdeaPluginDescriptor> list2;
            Object object = this.myRepositoriesLock;
            synchronized (object) {
                if (this.myAllRepositoryPluginsList != null) {
                    List<IdeaPluginDescriptor> list3 = this.myAllRepositoryPluginsList;
                    // MONITOREXIT @DISABLED, blocks:[3, 8] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
                    if (list3 == null) {
                        PluginManagerConfigurable.$$$reportNull$$$0(34);
                    }
                    return list3;
                }
            }
            try {
                List<IdeaPluginDescriptor> list4 = RepositoryHelper.loadCachedPlugins();
                if (list4 == null) break block9;
                list2 = list4;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                break block9;
            }
            if (list2 == null) {
                PluginManagerConfigurable.$$$reportNull$$$0(35);
            }
            return list2;
        }
        List<IdeaPluginDescriptor> list5 = Collections.emptyList();
        if (list5 == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(36);
        }
        return list5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Pair<Map<PluginId, IdeaPluginDescriptor>, Map<String, List<IdeaPluginDescriptor>>> loadRepositoryPlugins() {
        Object object = this.myRepositoriesLock;
        // MONITORENTER : object
        if (this.myAllRepositoryPluginsMap != null) {
            Pair pair = Pair.create(this.myAllRepositoryPluginsMap, this.myCustomRepositoryPluginsMap);
            // MONITOREXIT : object
            if (pair != null) return pair;
            PluginManagerConfigurable.$$$reportNull$$$0(37);
            return pair;
        }
        // MONITOREXIT : object
        ArrayList<IdeaPluginDescriptor> list2 = new ArrayList<IdeaPluginDescriptor>();
        HashMap<PluginId, IdeaPluginDescriptor> map2 = new HashMap<PluginId, IdeaPluginDescriptor>();
        HashMap<String, List<IdeaPluginDescriptor>> custom = new HashMap<String, List<IdeaPluginDescriptor>>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null);
                if (host != null) {
                    custom.put(host, descriptors);
                }
                for (IdeaPluginDescriptor plugin : descriptors) {
                    PluginId id2 = plugin.getPluginId();
                    if (map2.containsKey(id2)) continue;
                    list2.add(plugin);
                    map2.put(id2, plugin);
                }
            }
            catch (IOException e) {
                if (host == null) {
                    LOG.info("Main plugin repository is not available ('" + e.getMessage() + "'). Please check your network settings.");
                    continue;
                }
                LOG.info(host, (Throwable)e);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            InstalledPluginsState state = InstalledPluginsState.getInstance();
            for (IdeaPluginDescriptor descriptor2 : list2) {
                state.onDescriptorDownload(descriptor2);
            }
        });
        Object object2 = this.myRepositoriesLock;
        // MONITORENTER : object2
        if (this.myAllRepositoryPluginsList == null) {
            this.myAllRepositoryPluginsList = list2;
            this.myAllRepositoryPluginsMap = map2;
            this.myCustomRepositoryPluginsMap = custom;
        }
        Pair pair = Pair.create(this.myAllRepositoryPluginsMap, this.myCustomRepositoryPluginsMap);
        // MONITOREXIT : object2
        if (pair != null) return pair;
        PluginManagerConfigurable.$$$reportNull$$$0(38);
        return pair;
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull @Nls String name, @NotNull String showAllQuery, @NotNull ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException> function) throws IOException {
        if (groups == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(39);
        }
        if (name == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(40);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(41);
        }
        if (function == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(42);
        }
        PluginsGroup group = new PluginsGroup(name);
        if (Boolean.TRUE.equals(function.fun(group.descriptors))) {
            group.rightAction = new LinkLabel(IdeBundle.message((String)"plugins.configurable.show.all", (Object[])new Object[0]), null, this.myMarketplaceTab.mySearchListener, (Object)showAllQuery);
            group.rightAction.setBorder((Border)JBUI.Borders.emptyRight((int)5));
        }
        if (!group.descriptors.isEmpty()) {
            groups.add(group);
        }
    }

    private void addGroup(@NotNull List<? super PluginsGroup> groups, @NotNull Map<PluginId, IdeaPluginDescriptor> allRepositoriesMap, @NotNull @Nls String name, @NotNull String query, @NotNull String showAllQuery) throws IOException {
        if (groups == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(43);
        }
        if (allRepositoriesMap == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(44);
        }
        if (name == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(45);
        }
        if (query == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(46);
        }
        if (showAllQuery == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(47);
        }
        this.addGroup(groups, name, showAllQuery, (ThrowableNotNullFunction<? super List<IdeaPluginDescriptor>, Boolean, ? extends IOException>)((ThrowableNotNullFunction)descriptors -> PluginRepositoryRequests.loadPlugins(descriptors, allRepositoriesMap, query)));
    }

    @NotNull
    public String getHelpTopic() {
        return ID;
    }

    public void disposeUIResources() {
        if (this.myPluginModel.toBackground()) {
            InstallPluginInfo.showRestart();
            InstalledPluginsState.getInstance().clearShutdownCallback();
        }
        this.myMarketplaceTab.dispose();
        this.myInstalledTab.dispose();
        if (this.myMarketplacePanel != null) {
            this.myMarketplacePanel.dispose();
        }
        if (this.myMarketplaceSearchPanel != null) {
            this.myMarketplaceSearchPanel.dispose();
        }
        this.myPluginUpdatesService.dispose();
        PluginPriceService.cancel();
        InstalledPluginsState.getInstance().runShutdownCallback();
        InstalledPluginsState.getInstance().resetChangesAppliedWithoutRestart();
    }

    public void cancel() {
        this.myPluginModel.removePluginsOnCancel(this.myCardPanel);
    }

    public boolean isModified() {
        return this.myPluginModel.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myPluginModel.apply(this.myCardPanel)) {
            return;
        }
        if (this.myPluginModel.createShutdownCallback) {
            InstalledPluginsState.getInstance().setShutdownCallback(() -> ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp()));
        }
    }

    public void reset() {
        this.myPluginModel.removePluginsOnCancel(this.myCardPanel);
    }

    @NotNull
    public MyPluginModel getPluginModel() {
        MyPluginModel myPluginModel = this.myPluginModel;
        if (myPluginModel == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(48);
        }
        return myPluginModel;
    }

    public void setInitUpdates(@NotNull Collection<PluginDownloader> initUpdates) {
        if (initUpdates == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(49);
        }
        this.myInitUpdates = initUpdates;
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        if (descriptors == null) {
            PluginManagerConfigurable.$$$reportNull$$$0(50);
        }
        if (this.myTabHeaderComponent.getSelectionTab() != 1) {
            this.myTabHeaderComponent.setSelectionWithEvents(1);
        }
        if (descriptors.length == 0) {
            return;
        }
        ArrayList<ListPluginComponent> components = new ArrayList<ListPluginComponent>();
        block0: for (IdeaPluginDescriptor descriptor2 : descriptors) {
            for (UIPluginGroup group : this.myInstalledPanel.getGroups()) {
                ListPluginComponent component2 = group.findComponent(descriptor2);
                if (component2 == null) continue;
                components.add(component2);
                continue block0;
            }
        }
        if (!components.isEmpty()) {
            this.myInstalledPanel.setSelection(components);
        }
    }

    @Nullable
    public Runnable enableSearch(String option2) {
        if (StringUtil.isEmpty((String)option2) && (this.myTabHeaderComponent.getSelectionTab() == 0 || this.myInstalledSearchPanel.isEmpty())) {
            return null;
        }
        return () -> {
            int tabIndex;
            boolean marketplace = option2 != null && option2.startsWith("/tag:");
            int n = tabIndex = marketplace ? 0 : 1;
            if (this.myTabHeaderComponent.getSelectionTab() != tabIndex) {
                this.myTabHeaderComponent.setSelectionWithEvents(tabIndex);
            }
            PluginsTab tab = marketplace ? this.myMarketplaceTab : this.myInstalledTab;
            tab.clearSearchPanel(option2);
            if (!StringUtil.isEmpty((String)option2)) {
                tab.showSearchPanel(option2);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 3: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: 
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPlugin";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPlugin";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 29: 
            case 30: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showAllQuery";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositoriesMap";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initUpdates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGearActions";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setTinyFont";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryPlugins";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRepositoryPlugins";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCenterComponent";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRightBottomPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearUpdates";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyUpdates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerCopyProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTags";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTinyFont";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDownloads";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLastUpdatedDate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRating";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showRestartDialog";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartApp";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shutdownOrRestartAppAfterInstall";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurableAndEnable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showPluginConfigurable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setInitUpdates";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InstallFromDiskAction
    extends DumbAwareAction {
        private InstallFromDiskAction() {
            super(IdeBundle.messagePointer((String)"action.InstallFromDiskAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                InstallFromDiskAction.$$$reportNull$$$0(0);
            }
            PluginInstaller.chooseAndInstall(PluginManagerConfigurable.this.myPluginModel, PluginManagerConfigurable.this.myCardPanel, (Consumer<? super PluginInstallCallbackData>)((Consumer)callbackData -> {
                boolean select;
                PluginManagerConfigurable.this.myPluginModel.pluginInstalledFromDisk((PluginInstallCallbackData)callbackData);
                boolean bl = select = PluginManagerConfigurable.this.myInstalledPanel == null;
                if (PluginManagerConfigurable.this.myTabHeaderComponent.getSelectionTab() != 1) {
                    PluginManagerConfigurable.this.myTabHeaderComponent.setSelectionWithEvents(1);
                }
                PluginManagerConfigurable.this.myInstalledTab.clearSearchPanel("");
                if (select) {
                    for (UIPluginGroup group : PluginManagerConfigurable.this.myInstalledPanel.getGroups()) {
                        ListPluginComponent component2 = group.findComponent(callbackData.getPluginDescriptor());
                        if (component2 == null) continue;
                        PluginManagerConfigurable.this.myInstalledPanel.setSelection(component2);
                        break;
                    }
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$InstallFromDiskAction", "actionPerformed"));
        }
    }

    private class ChangePluginStateAction
    extends DumbAwareAction {
        private final boolean myEnable;

        private ChangePluginStateAction(boolean enable) {
            super(enable ? IdeBundle.message((String)"plugins.configurable.enable.all.downloaded", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.all.downloaded", (Object[])new Object[0]));
            this.myEnable = enable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            IdeaPluginDescriptor[] descriptors;
            PluginsGroup group;
            if (e == null) {
                ChangePluginStateAction.$$$reportNull$$$0(0);
            }
            if ((group = PluginManagerConfigurable.this.myPluginModel.getDownloadedGroup()) == null || group.ui == null) {
                ApplicationInfoImpl appInfo = (ApplicationInfoImpl)ApplicationInfo.getInstance();
                ArrayList<IdeaPluginDescriptor> descriptorList = new ArrayList<IdeaPluginDescriptor>();
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    if (appInfo.isEssentialPlugin(descriptor2.getPluginId()) || descriptor2.isBundled() || descriptor2.isEnabled() == this.myEnable) continue;
                    descriptorList.add(descriptor2);
                }
                descriptors = descriptorList.toArray(new IdeaPluginDescriptor[0]);
            } else {
                descriptors = (IdeaPluginDescriptor[])group.ui.plugins.stream().filter(component2 -> PluginManagerConfigurable.this.myPluginModel.isEnabled(component2.myPlugin) != this.myEnable).map(component2 -> component2.myPlugin).toArray(IdeaPluginDescriptor[]::new);
            }
            if (descriptors.length > 0) {
                PluginManagerConfigurable.this.myPluginModel.changeEnableDisable(descriptors, this.myEnable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/PluginManagerConfigurable$ChangePluginStateAction", "actionPerformed"));
        }
    }

    private static class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        private GroupByActionGroup() {
        }
    }

    private class InstalledSearchOptionAction
    extends ToggleAction
    implements DumbAware {
        private final InstalledSearchOption myOption;
        private boolean myState;

        private InstalledSearchOptionAction(InstalledSearchOption option2) {
            if (option2 == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(0);
            }
            super(option2 == InstalledSearchOption.NeedUpdate ? IdeBundle.message((String)"plugins.configurable.update.available", (Object[])new Object[0]) : option2.name());
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurable.this.myInstalledSearchCallback.accept(this);
        }

        public void setState(@Nullable SearchQueryParser.Installed parser) {
            if (parser == null) {
                this.myState = false;
                return;
            }
            switch (this.myOption) {
                case Enabled: {
                    this.myState = parser.enabled;
                    break;
                }
                case Disabled: {
                    this.myState = parser.disabled;
                    break;
                }
                case Downloaded: {
                    this.myState = parser.downloaded;
                    break;
                }
                case Bundled: {
                    this.myState = parser.bundled;
                    break;
                }
                case Invalid: {
                    this.myState = parser.invalid;
                    break;
                }
                case NeedUpdate: {
                    this.myState = parser.needUpdate;
                }
            }
        }

        @NotNull
        public String getQuery() {
            String string = this.myOption == InstalledSearchOption.NeedUpdate ? "/outdated" : "/" + StringUtil.decapitalize((String)this.myOption.name());
            if (string == null) {
                InstalledSearchOptionAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/PluginManagerConfigurable$InstalledSearchOptionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$InstalledSearchOptionAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum InstalledSearchOption {
        Downloaded,
        NeedUpdate,
        Enabled,
        Disabled,
        Invalid,
        Bundled;

    }

    private class MarketplaceSortByAction
    extends ToggleAction
    implements DumbAware {
        private final SortBySearchOption myOption;
        private boolean myState;

        private MarketplaceSortByAction(SortBySearchOption option2) {
            if (option2 == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(0);
            }
            super(option2.name());
            this.myOption = option2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(1);
            }
            return this.myState;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(2);
            }
            this.myState = state;
            PluginManagerConfigurable.this.myMarketplaceSortByCallback.accept(this);
        }

        public void setState(@NotNull SearchQueryParser.Marketplace parser) {
            if (parser == null) {
                MarketplaceSortByAction.$$$reportNull$$$0(3);
            }
            if (this.myOption == SortBySearchOption.Relevance) {
                this.myState = parser.sortBy == null;
                this.getTemplatePresentation().setVisible(parser.sortBy == null || !parser.tags.isEmpty() || parser.searchQuery != null);
            } else {
                this.myState = parser.sortBy != null && this.myOption.name().equalsIgnoreCase(parser.sortBy);
            }
        }

        @Nullable
        public String getQuery() {
            switch (this.myOption) {
                case Downloads: {
                    return "/sortBy:downloads";
                }
                case Name: {
                    return "/sortBy:name";
                }
                case Rating: {
                    return "/sortBy:rating";
                }
                case Updated: {
                    return "/sortBy:updated";
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parser";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/PluginManagerConfigurable$MarketplaceSortByAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum SortBySearchOption {
        Downloads,
        Name,
        Rating,
        Relevance,
        Updated;

    }
}

