/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.NotABooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.popup.Balloon;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class PluginBooleanOptionDescriptor
extends NotABooleanOptionDescription
implements BooleanOptionDescription.RequiresRebuild {
    private static final NotificationGroup PLUGINS_LIST_CHANGED_GROUP = new NotificationGroup("Plugins updates", NotificationDisplayType.STICKY_BALLOON, false, null, null, null, PluginManagerCore.CORE_ID);
    private static final NotificationGroup PLUGINS_AUTO_SWITCH_GROUP = new NotificationGroup("Plugins AutoSwitch", NotificationDisplayType.BALLOON, false, null, null, null, PluginManagerCore.CORE_ID);
    private static final Notifier ourRestartNeededNotifier = new Notifier();
    private final IdeaPluginDescriptor plugin;

    PluginBooleanOptionDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(0);
        }
        super(descriptor2.getName(), "preferences.pluginManager");
        this.plugin = descriptor2;
    }

    public boolean isOptionEnabled() {
        return this.plugin.isEnabled();
    }

    public void setOptionState(boolean enabled) {
        Collection<IdeaPluginDescriptor> autoSwitchedIds = enabled ? PluginBooleanOptionDescriptor.getPluginsIdsToEnable(this.plugin) : PluginBooleanOptionDescriptor.getPluginsIdsToDisable(this.plugin);
        boolean enabledWithoutRestart = PluginEnabler.enablePlugins(autoSwitchedIds, enabled);
        if (autoSwitchedIds.size() > 1) {
            this.showAutoSwitchNotification(autoSwitchedIds, enabled);
        }
        if (!enabledWithoutRestart) {
            ourRestartNeededNotifier.showNotification();
        }
    }

    private void showAutoSwitchNotification(final @NotNull Collection<IdeaPluginDescriptor> autoSwitchedPlugins, final boolean enabled) {
        if (autoSwitchedPlugins == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(1);
        }
        StringBuilder builder2 = new StringBuilder();
        for (IdeaPluginDescriptor autoSwitchedPlugin : autoSwitchedPlugins) {
            if (builder2.length() > 0) {
                builder2.append(", ");
            }
            builder2.append('\"').append(autoSwitchedPlugin.getName()).append('\"');
        }
        String dependenciesString = builder2.toString();
        String titleKey = enabled ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title";
        String contentKey = enabled ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content";
        String pluginString = '\"' + this.getOption() + '\"';
        final Notification switchNotification = PLUGINS_AUTO_SWITCH_GROUP.createNotification(IdeBundle.message((String)contentKey, (Object[])new Object[]{pluginString, dependenciesString}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)titleKey, (Object[])new Object[0])).addAction((AnAction)new UndoPluginsSwitchAction(autoSwitchedPlugins, enabled));
        PluginManager.getInstance().addDisablePluginListener(new Runnable(){

            @Override
            public void run() {
                Balloon balloon;
                boolean notificationValid;
                Stream<PluginId> ids = autoSwitchedPlugins.stream().map(descriptor2 -> descriptor2.getPluginId());
                boolean bl = notificationValid = enabled ? ids.noneMatch(PluginManagerCore::isDisabled) : ids.allMatch(PluginManagerCore::isDisabled);
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon = switchNotification.getBalloon()) == null || balloon.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> PluginManager.getInstance().removeDisablePluginListener(this));
                }
            }
        });
        Notifications.Bus.notify((Notification)switchNotification);
    }

    @NotNull
    private static Collection<IdeaPluginDescriptor> getPluginsIdsToEnable(@NotNull IdeaPluginDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(2);
        }
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        PluginManagerCore.processAllDependencies(rootDescriptor, false, descriptor2 -> {
            if (descriptor2.getPluginId() == PluginManagerCore.CORE_ID) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (!descriptor2.isEnabled()) {
                return result2.add((IdeaPluginDescriptor)descriptor2) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        });
        HashSet<IdeaPluginDescriptor> hashSet = result2;
        if (hashSet == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static Collection<IdeaPluginDescriptor> getPluginsIdsToDisable(@NotNull IdeaPluginDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(4);
        }
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            PluginId pluginId = plugin.getPluginId();
            if (pluginId == rootId || appInfo.isEssentialPlugin(pluginId) || !plugin.isEnabled() || plugin.isImplementationDetail() || plugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)plugin).isDeleted()) continue;
            PluginManagerCore.processAllDependencies(plugin, false, descriptor2 -> {
                if (descriptor2.getPluginId() == rootId) {
                    result2.add(plugin);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        HashSet<IdeaPluginDescriptor> hashSet = result2;
        if (hashSet == null) {
            PluginBooleanOptionDescriptor.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoSwitchedPlugins";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsIdsToEnable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsIdsToDisable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showAutoSwitchNotification";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsIdsToEnable";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsIdsToDisable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Notifier {
        private final AtomicReference<Notification> prevNotification = new AtomicReference();

        private Notifier() {
        }

        public void showNotification() {
            Notification prev = this.prevNotification.get();
            if (prev != null && prev.getBalloon() != null && !prev.getBalloon().isDisposed()) {
                return;
            }
            Notification next = PLUGINS_LIST_CHANGED_GROUP.createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0]));
            if (this.prevNotification.compareAndSet(prev, next)) {
                Notifications.Bus.notify((Notification)next);
            }
        }
    }

    private static final class UndoPluginsSwitchAction
    extends NotificationAction {
        private final Collection<IdeaPluginDescriptor> myDescriptors;
        private final boolean myEnabled;

        UndoPluginsSwitchAction(@NotNull Collection<IdeaPluginDescriptor> descriptors, boolean enabled) {
            if (descriptors == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0]));
            this.myDescriptors = descriptors;
            this.myEnabled = enabled;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(1);
            }
            if (notification == null) {
                UndoPluginsSwitchAction.$$$reportNull$$$0(2);
            }
            boolean enabled = !this.myEnabled;
            PluginManager.getInstance().enablePlugins(this.myDescriptors, enabled);
            notification.expire();
            ourRestartNeededNotifier.showNotification();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/ui/PluginBooleanOptionDescriptor$UndoPluginsSwitchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

