/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

class OutputStreamLogger
extends OutputStream {
    private static final int BUFFER_SIZE = 10000;
    private final byte[] myBuffer = new byte[10000];
    private final PrintStream myOriginalStream;
    private final Logger myLogger;
    private int myPosition;
    private boolean mySlashRWritten;

    OutputStreamLogger(String name, PrintStream originalStream) {
        this.myOriginalStream = originalStream;
        this.myLogger = Logger.getInstance((String)name);
    }

    @Override
    public void write(int b) {
        this.myOriginalStream.write(b);
        this.processByte(b);
    }

    @Override
    public void write(byte @NotNull [] b, int off, int len) {
        if (b == null) {
            OutputStreamLogger.$$$reportNull$$$0(0);
        }
        this.myOriginalStream.write(b, off, len);
        for (int i = 0; i < len; ++i) {
            this.processByte(b[off + i]);
        }
    }

    private synchronized void processByte(int b) {
        if (b == 13) {
            this.writeBuffer();
            this.mySlashRWritten = true;
        } else if (b == 10) {
            if (this.mySlashRWritten) {
                this.mySlashRWritten = false;
            } else {
                this.writeBuffer();
            }
        } else {
            this.mySlashRWritten = false;
            if (this.myPosition == 10000) {
                this.writeBuffer();
            }
            this.myBuffer[this.myPosition++] = (byte)b;
        }
    }

    private void writeBuffer() {
        this.myLogger.info(new String(this.myBuffer, 0, this.myPosition, Charset.defaultCharset()));
        this.myPosition = 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/idea/OutputStreamLogger", "write"));
    }
}

