/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.internal.psiView.PsiViewerExtension;
import com.intellij.internal.psiView.PsiViewerSettings;
import com.intellij.internal.psiView.PsiViewerSourceWrapper;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.internal.psiView.ViewerPsiBasedTree;
import com.intellij.internal.psiView.ViewerTreeBuilder;
import com.intellij.internal.psiView.ViewerTreeStructure;
import com.intellij.internal.psiView.formattingblocks.BlockViewerPsiBasedTree;
import com.intellij.internal.psiView.stubtree.StubViewerPsiBasedTree;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiViewerDialog
extends DialogWrapper
implements DataProvider,
Disposable {
    private static final String REFS_CACHE = "References Resolve Cache";
    public static final Color BOX_COLOR = new JBColor(new Color(16542720), new Color(14576641));
    public static final Logger LOG = Logger.getInstance(PsiViewerDialog.class);
    private final Project myProject;
    private JPanel myPanel;
    private JComboBox<PsiViewerSourceWrapper> myFileTypeComboBox;
    private JCheckBox myShowWhiteSpacesBox;
    private JCheckBox myShowTreeNodesCheckBox;
    private JBLabel myDialectLabel;
    private JComboBox<Language> myDialectComboBox;
    private JLabel myExtensionLabel;
    private JComboBox<String> myExtensionComboBox;
    private JPanel myTextPanel;
    private JSplitPane myTextSplit;
    private JSplitPane myTreeSplit;
    private Tree myPsiTree;
    private ViewerTreeBuilder myPsiTreeBuilder;
    private final JList myRefs;
    private TitledSeparator myTextSeparator;
    private TitledSeparator myPsiTreeSeparator;
    @NotNull
    private final StubViewerPsiBasedTree myStubTree;
    @NotNull
    private final BlockViewerPsiBasedTree myBlockTree;
    private RangeHighlighter myHighlighter;
    private final Set<PsiViewerSourceWrapper> mySourceWrappers;
    private final EditorEx myEditor;
    private final EditorListener myEditorListener;
    private String myLastParsedText;
    private int myLastParsedTextHashCode;
    private int myNewDocumentHashCode;
    private final boolean myExternalDocument;
    @NotNull
    private final JBTabs myTabs;
    private static final Pattern EXT_PATTERN = Pattern.compile("[a-z0-9]*");

    private void createUIComponents() {
        this.myPsiTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    public PsiViewerDialog(@NotNull Project project, @Nullable Editor selectedEditor) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(0);
        }
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.mySourceWrappers = new TreeSet<PsiViewerSourceWrapper>();
        this.myEditorListener = new EditorListener();
        this.myLastParsedText = null;
        this.myLastParsedTextHashCode = 17;
        this.myNewDocumentHashCode = 11;
        this.myProject = project;
        this.myExternalDocument = selectedEditor != null;
        this.myTabs = this.createTabPanel(project);
        this.myRefs = new JBList(new DefaultListModel());
        ViewerPsiBasedTree.PsiTreeUpdater psiTreeUpdater = new ViewerPsiBasedTree.PsiTreeUpdater(){
            private final TextAttributes myAttributes = new TextAttributes();
            {
                this.myAttributes.setEffectColor(BOX_COLOR);
                this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
            }

            @Override
            public void updatePsiTree(@NotNull PsiElement toSelect2, @Nullable TextRange selectRangeInEditor) {
                if (toSelect2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (selectRangeInEditor != null) {
                    int start2 = selectRangeInEditor.getStartOffset();
                    int end = selectRangeInEditor.getEndOffset();
                    PsiViewerDialog.this.clearSelection();
                    if (end <= PsiViewerDialog.this.myEditor.getDocument().getTextLength()) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start2, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start2);
                        PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                }
                PsiViewerDialog.this.updateReferences(toSelect2);
                if (!PsiViewerDialog.this.myPsiTree.hasFocus()) {
                    PsiViewerDialog.this.myPsiTreeBuilder.select(toSelect2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/intellij/internal/psiView/PsiViewerDialog$1", "updatePsiTree"));
            }
        };
        this.myStubTree = new StubViewerPsiBasedTree(project, psiTreeUpdater);
        this.myBlockTree = new BlockViewerPsiBasedTree(project, psiTreeUpdater);
        this.setOKButtonText("&Build PSI Tree");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        VirtualFile selectedFile = selectedEditor == null ? null : FileDocumentManager.getInstance().getFile(selectedEditor.getDocument());
        this.setTitle(selectedFile == null ? "PSI Viewer" : "PSI Viewer: " + selectedFile.getName());
        if (selectedEditor != null) {
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(selectedEditor.getDocument(), this.myProject);
        } else {
            PsiViewerSettings settings = PsiViewerSettings.getSettings();
            Document document = EditorFactory.getInstance().createDocument((CharSequence)StringUtil.notNullize((String)settings.text));
            this.myEditor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
            this.myEditor.getSelectionModel().setSelection(0, document.getTextLength());
        }
        this.myEditor.getSettings().setLineMarkerAreaShown(false);
        this.init();
        if (selectedEditor != null) {
            this.doOKAction();
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true));
                this.myEditor.getCaretModel().moveToOffset(selectedEditor.getCaretModel().getOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }, ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    @NotNull
    private JBTabs createTabPanel(@NotNull Project project) {
        if (project == null) {
            PsiViewerDialog.$$$reportNull$$$0(1);
        }
        JBEditorTabsBase tabs = JBTabsFactory.createEditorTabs((Project)project, (Disposable)this.getDisposable());
        tabs.getPresentation().setAlphabeticalMode(false).setSupportsCompression(false);
        JBEditorTabsBase jBEditorTabsBase = tabs;
        if (jBEditorTabsBase == null) {
            PsiViewerDialog.$$$reportNull$$$0(2);
        }
        return jBEditorTabsBase;
    }

    protected void init() {
        TabInfo defaultInfo;
        this.initMnemonics();
        PsiViewerDialog.initTree((JTree)this.myPsiTree);
        final TreeCellRenderer renderer = this.myPsiTree.getCellRenderer();
        this.myPsiTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject;
                if (tree == null) {
                    2.$$$reportNull$$$0(0);
                }
                Component c = renderer.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
                if (value2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof ViewerNodeDescriptor) {
                    Object element2 = ((ViewerNodeDescriptor)((Object)userObject)).getElement();
                    if (c instanceof NodeRenderer) {
                        ((NodeRenderer)c).setToolTipText(element2 == null ? null : element2.getClass().getName());
                    }
                    if (element2 instanceof PsiElement && FileContextUtil.getFileContext(((PsiElement)element2).getContainingFile()) != null || element2 instanceof ViewerTreeStructure.Inject) {
                        TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
                        c.setBackground(attr.getBackgroundColor());
                    }
                }
                return c;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/psiView/PsiViewerDialog$2", "getTreeCellRendererComponent"));
            }
        });
        this.myPsiTreeBuilder = new ViewerTreeBuilder(this.myProject, (JTree)this.myPsiTree);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsiTreeBuilder);
        this.myPsiTree.addTreeSelectionListener((TreeSelectionListener)new MyPsiTreeSelectionListener());
        JPanel panelWrapper = new JPanel(new BorderLayout());
        panelWrapper.add(this.myTabs.getComponent());
        this.myTreeSplit.add((Component)panelWrapper, "right");
        JPanel referencesPanel = new JPanel(new BorderLayout());
        referencesPanel.add(this.myRefs);
        referencesPanel.setBorder(IdeBorderFactory.createBorder());
        this.myTabs.addTab(new TabInfo((JComponent)referencesPanel).setText("References"));
        this.myTabs.addTab(new TabInfo(this.myBlockTree.getComponent()).setText("Block Structure"));
        this.myTabs.addTab(new TabInfo(this.myStubTree.getComponent()).setText("Stub Structure"));
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        int tabIndex = settings.lastSelectedTabIndex;
        TabInfo tabInfo = defaultInfo = tabIndex < this.myTabs.getTabCount() ? this.myTabs.getTabAt(tabIndex) : null;
        if (defaultInfo != null) {
            this.myTabs.select(defaultInfo, false);
        }
        this.myTabs.setSelectionChangeHandler((tab, focus, el) -> {
            settings.lastSelectedTabIndex = this.myTabs.getIndexOf(tab);
            return el.run();
        });
        GoToListener listener2 = new GoToListener();
        this.myRefs.addKeyListener(listener2);
        this.myRefs.addMouseListener(listener2);
        this.myRefs.getSelectionModel().addListSelectionListener(listener2);
        this.myRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                if (list2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                Component comp = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                try {
                    if (PsiViewerDialog.this.resolve(index) == null) {
                        comp.setForeground((Color)JBColor.RED);
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return comp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/internal/psiView/PsiViewerDialog$3", "getListCellRendererComponent"));
            }
        });
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.myEditor.getDocument().addDocumentListener(this.myEditorListener);
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorListener);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this.myEditorListener);
        this.getPeer().getWindow().setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(@NotNull Window window) {
                if (window == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PsiViewerDialog.this.myEditor.getComponent();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/internal/psiView/PsiViewerDialog$4", "getInitialComponent"));
            }
        });
        VirtualFile file2 = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
        Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file2);
        String type = curLanguage != null ? curLanguage.getDisplayName() : settings.type;
        PsiViewerSourceWrapper lastUsed = null;
        this.mySourceWrappers.addAll(PsiViewerSourceWrapper.getExtensionBasedWrappers());
        List<PsiViewerSourceWrapper> fileTypeBasedWrappers = PsiViewerSourceWrapper.getFileTypeBasedWrappers();
        for (PsiViewerSourceWrapper wrapper2 : fileTypeBasedWrappers) {
            this.mySourceWrappers.addAll(fileTypeBasedWrappers);
            if ((lastUsed != null || !wrapper2.getText().equals(type)) && (curLanguage == null || wrapper2.myFileType != curLanguage.getAssociatedFileType())) continue;
            lastUsed = wrapper2;
        }
        this.myFileTypeComboBox.setModel((ComboBoxModel<PsiViewerSourceWrapper>)new CollectionComboBoxModel(new ArrayList<PsiViewerSourceWrapper>(this.mySourceWrappers), lastUsed));
        this.myFileTypeComboBox.setRenderer((ListCellRenderer<PsiViewerSourceWrapper>)SimpleListCellRenderer.create((label2, value2, index) -> {
            if (value2 != null) {
                label2.setText(value2.getText());
                label2.setIcon(value2.getIcon());
            }
        }));
        new ComboboxSpeedSearch(this.myFileTypeComboBox){

            @Override
            protected String getElementText(Object element2) {
                return element2 instanceof PsiViewerSourceWrapper ? ((PsiViewerSourceWrapper)element2).getText() : null;
            }
        };
        this.myFileTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.updateDialectsCombo(null);
                PsiViewerDialog.this.updateExtensionsCombo();
                PsiViewerDialog.this.updateEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$6", "actionPerformed"));
            }
        });
        this.myDialectComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.updateEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$7", "actionPerformed"));
            }
        });
        new ComboboxSpeedSearch(this.myDialectComboBox){

            @Override
            protected String getElementText(Object element2) {
                return element2 instanceof Language ? ((Language)element2).getDisplayName() : "<default>";
            }
        };
        this.myFileTypeComboBox.addFocusListener(new AutoExpandFocusListener(this.myFileTypeComboBox));
        if (!this.myExternalDocument && lastUsed == null && this.mySourceWrappers.size() > 0) {
            this.myFileTypeComboBox.setSelectedIndex(0);
        }
        this.myDialectComboBox.setRenderer((ListCellRenderer<Language>)SimpleListCellRenderer.create((String)"(none)", value2 -> value2.getDisplayName()));
        this.myDialectComboBox.addFocusListener(new AutoExpandFocusListener(this.myDialectComboBox));
        this.myExtensionComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", value2 -> "." + value2));
        this.myExtensionComboBox.addFocusListener(new AutoExpandFocusListener(this.myExtensionComboBox));
        final ViewerTreeStructure psiTreeStructure = this.getTreeStructure();
        this.myShowWhiteSpacesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                psiTreeStructure.setShowWhiteSpaces(PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected());
                PsiViewerDialog.this.myPsiTreeBuilder.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$9", "actionPerformed"));
            }
        });
        this.myShowTreeNodesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                psiTreeStructure.setShowTreeNodes(PsiViewerDialog.this.myShowTreeNodesCheckBox.isSelected());
                PsiViewerDialog.this.myPsiTreeBuilder.queueUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$10", "actionPerformed"));
            }
        });
        this.myShowWhiteSpacesBox.setSelected(settings.showWhiteSpaces);
        psiTreeStructure.setShowWhiteSpaces(settings.showWhiteSpaces);
        this.myShowTreeNodesCheckBox.setSelected(settings.showTreeNodes);
        psiTreeStructure.setShowTreeNodes(settings.showTreeNodes);
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        this.updateDialectsCombo(settings.dialect);
        this.updateExtensionsCombo();
        this.registerCustomKeyboardActions();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), (Dimension)JBUI.size((int)800, (int)600));
        }
        this.myTextSplit.setDividerLocation(settings.textDividerLocation);
        this.myTreeSplit.setDividerLocation(settings.treeDividerLocation);
        this.updateEditor();
        super.init();
    }

    public static void initTree(JTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        ToolTipManager.sharedInstance().registerComponent(tree);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree);
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.internal.psiView.PsiViewerDialog";
    }

    protected String getHelpId() {
        return "reference.psi.viewer";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    private void registerCustomKeyboardActions() {
        int mask = SystemInfo.isMac ? 256 : 512;
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.focusEditor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$11", "actionPerformed"));
            }
        }, KeyStroke.getKeyStroke(84, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.focusTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$12", "actionPerformed"));
            }
        }, KeyStroke.getKeyStroke(83, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    13.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.myBlockTree.focusTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$13", "actionPerformed"));
            }
        }, KeyStroke.getKeyStroke(75, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    14.$$$reportNull$$$0(0);
                }
                PsiViewerDialog.this.focusRefs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$14", "actionPerformed"));
            }
        }, KeyStroke.getKeyStroke(82, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    15.$$$reportNull$$$0(0);
                }
                if (PsiViewerDialog.this.myRefs.isFocusOwner()) {
                    PsiViewerDialog.this.myBlockTree.focusTree();
                } else if (PsiViewerDialog.this.myPsiTree.isFocusOwner()) {
                    PsiViewerDialog.this.focusRefs();
                } else if (PsiViewerDialog.this.myBlockTree.isFocusOwner()) {
                    PsiViewerDialog.this.focusTree();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$15", "actionPerformed"));
            }
        }, KeyStroke.getKeyStroke(9, 0));
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void focusEditor() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), true);
    }

    private void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myPsiTree, true);
    }

    private void focusRefs() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myRefs, true);
        if (this.myRefs.getModel().getSize() > 0 && this.myRefs.getSelectedIndex() == -1) {
            this.myRefs.setSelectedIndex(0);
        }
    }

    private void initMnemonics() {
        this.myTextSeparator.setLabelFor((Component)this.myEditor.getContentComponent());
        this.myPsiTreeSeparator.setLabelFor((Component)this.myPsiTree);
    }

    @Nullable
    private PsiElement getPsiElement() {
        TreePath path = this.myPsiTree.getSelectionPath();
        return path == null ? null : PsiViewerDialog.getPsiElement((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement getPsiElement(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ViewerNodeDescriptor) {
            ViewerNodeDescriptor descriptor2 = (ViewerNodeDescriptor)((Object)node.getUserObject());
            Object elementObject = descriptor2.getElement();
            return elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
        }
        return null;
    }

    private void updateDialectsCombo(@Nullable String lastUsed) {
        Object source = this.getSource();
        ArrayList<Object> items = new ArrayList<Object>();
        if (source instanceof LanguageFileType) {
            Language baseLang = ((LanguageFileType)source).getLanguage();
            items.add(baseLang);
            ArrayList dialects = new ArrayList(baseLang.getDialects());
            Collections.sort(dialects, LanguageUtil.LANGUAGE_COMPARATOR);
            items.addAll(dialects);
        }
        this.myDialectComboBox.setModel((ComboBoxModel<Language>)new CollectionComboBoxModel(items));
        boolean visible = items.size() > 1;
        this.myDialectLabel.setVisible(visible);
        this.myDialectComboBox.setVisible(visible);
        if (visible && (this.myExternalDocument || lastUsed != null)) {
            VirtualFile file2 = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            Language curLanguage = LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)file2);
            int idx = items.indexOf(curLanguage);
            this.myDialectComboBox.setSelectedIndex(idx >= 0 ? idx : 0);
        }
    }

    private void updateExtensionsCombo() {
        List<String> extensions2;
        Object source = this.getSource();
        if (source instanceof LanguageFileType && (extensions2 = PsiViewerDialog.getAllExtensions((LanguageFileType)source)).size() > 1) {
            String fileExt;
            ExtensionComparator comp = new ExtensionComparator(extensions2.get(0));
            Collections.sort(extensions2, comp);
            SortedComboBoxModel model = new SortedComboBoxModel((Comparator)comp);
            model.setAll(extensions2);
            this.myExtensionComboBox.setModel((ComboBoxModel<String>)model);
            this.myExtensionComboBox.setVisible(true);
            this.myExtensionLabel.setVisible(true);
            VirtualFile file2 = this.myExternalDocument ? FileDocumentManager.getInstance().getFile((Document)this.myEditor.getDocument()) : null;
            String string = fileExt = file2 == null ? "" : FileUtilRt.getExtension((String)file2.getName());
            if (fileExt.length() > 0 && extensions2.contains(fileExt)) {
                this.myExtensionComboBox.setSelectedItem(fileExt);
                return;
            }
            this.myExtensionComboBox.setSelectedIndex(0);
            return;
        }
        this.myExtensionComboBox.setVisible(false);
        this.myExtensionLabel.setVisible(false);
    }

    private static List<String> getAllExtensions(LanguageFileType fileType) {
        List associations = FileTypeManager.getInstance().getAssociations((FileType)fileType);
        ArrayList<String> extensions2 = new ArrayList<String>();
        extensions2.add(StringUtil.toLowerCase((String)fileType.getDefaultExtension()));
        for (FileNameMatcher matcher : associations) {
            String ext;
            String presentableString = StringUtil.toLowerCase((String)matcher.getPresentableString());
            if (!presentableString.startsWith("*.") || (ext = presentableString.substring(2)).length() <= 0 || extensions2.contains(ext) || !EXT_PATTERN.matcher(ext).matches()) continue;
            extensions2.add(ext);
        }
        return extensions2;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    private Object getSource() {
        PsiViewerSourceWrapper wrapper2 = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper2 != null) {
            return wrapper2.myFileType != null ? wrapper2.myFileType : wrapper2.myExtension;
        }
        return null;
    }

    protected Action @NotNull [] createActions() {
        AbstractAction copyPsi = new AbstractAction("Cop&y PSI"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    16.$$$reportNull$$$0(0);
                }
                PsiElement element2 = PsiViewerDialog.this.parseText(PsiViewerDialog.this.myEditor.getDocument().getText());
                ArrayList<PsiElement> allToParse = new ArrayList<PsiElement>();
                if (element2 instanceof PsiFile) {
                    allToParse.addAll(((PsiFile)element2).getViewProvider().getAllFiles());
                } else if (element2 != null) {
                    allToParse.add(element2);
                }
                StringBuilder data2 = new StringBuilder();
                for (PsiElement psiElement : allToParse) {
                    data2.append(DebugUtil.psiToString(psiElement, !PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected(), true));
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(data2.toString()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$16", "actionPerformed"));
            }
        };
        Action[] actionArray = (Action[])ArrayUtil.mergeArrays((Object[])new Action[]{copyPsi}, (Object[])super.createActions());
        if (actionArray == null) {
            PsiViewerDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    protected void doOKAction() {
        String text2 = this.myEditor.getDocument().getText();
        this.myEditor.getSelectionModel().removeSelection();
        this.myLastParsedText = text2;
        this.myNewDocumentHashCode = this.myLastParsedTextHashCode = text2.hashCode();
        PsiElement rootElement = this.parseText(text2);
        this.focusTree();
        ViewerTreeStructure structure = this.getTreeStructure();
        structure.setRootPsiElement(rootElement);
        this.myPsiTreeBuilder.queueUpdate();
        this.myPsiTree.setRootVisible(true);
        this.myPsiTree.expandRow(0);
        this.myPsiTree.setRootVisible(false);
        this.myBlockTree.reloadTree(rootElement, text2);
        this.myStubTree.reloadTree(rootElement, text2);
    }

    @NotNull
    private ViewerTreeStructure getTreeStructure() {
        ViewerTreeStructure viewerTreeStructure = Objects.requireNonNull((ViewerTreeStructure)this.myPsiTreeBuilder.getTreeStructure());
        if (viewerTreeStructure == null) {
            PsiViewerDialog.$$$reportNull$$$0(4);
        }
        return viewerTreeStructure;
    }

    private PsiElement parseText(String text2) {
        Object source = this.getSource();
        try {
            if (source instanceof PsiViewerExtension) {
                return ((PsiViewerExtension)source).createElement(this.myProject, text2);
            }
            if (source instanceof FileType) {
                Language dialect;
                FileType type = (FileType)source;
                String ext = type.getDefaultExtension();
                if (this.myExtensionComboBox.isVisible()) {
                    ext = StringUtil.toLowerCase((String)this.myExtensionComboBox.getSelectedItem().toString());
                }
                if (type instanceof LanguageFileType && (dialect = (Language)this.myDialectComboBox.getSelectedItem()) != null) {
                    return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, dialect, (CharSequence)text2);
                }
                return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, type, (CharSequence)text2);
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)"Error", (Icon)Messages.getErrorIcon());
        }
        return null;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            PsiViewerDialog.$$$reportNull$$$0(5);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Object value2;
            String fqn = null;
            if (this.myPsiTree.hasFocus()) {
                TreePath path = this.myPsiTree.getSelectionPath();
                if (path != null) {
                    PsiElement element2;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                        return null;
                    }
                    ViewerNodeDescriptor descriptor2 = (ViewerNodeDescriptor)((Object)node.getUserObject());
                    Object elementObject = descriptor2.getElement();
                    Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element2 = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                    if (element2 != null) {
                        fqn = element2.getClass().getName();
                    }
                }
            } else if (this.myRefs.hasFocus() && (value2 = this.myRefs.getSelectedValue()) instanceof String) {
                fqn = (String)value2;
            }
            if (fqn != null) {
                return this.getContainingFileForClass(fqn);
            }
        }
        return null;
    }

    public void updateReferences(PsiElement element2) {
        DefaultListModel model = (DefaultListModel)this.myRefs.getModel();
        model.clear();
        Object cache = this.myRefs.getClientProperty(REFS_CACHE);
        if (cache instanceof Map) {
            ((Map)cache).clear();
        } else {
            this.myRefs.putClientProperty(REFS_CACHE, new HashMap());
        }
        if (element2 != null) {
            for (PsiReference reference2 : element2.getReferences()) {
                model.addElement(reference2.getClass().getName());
            }
        }
    }

    private void clearSelection() {
        if (this.myHighlighter != null) {
            this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter.dispose();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        PsiViewerSourceWrapper wrapper2 = (PsiViewerSourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper2 != null) {
            settings.type = wrapper2.getText();
        }
        if (!this.myExternalDocument) {
            settings.text = StringUtil.first((String)this.myEditor.getDocument().getText(), (int)2048, (boolean)true);
        }
        settings.showTreeNodes = this.myShowTreeNodesCheckBox.isSelected();
        settings.showWhiteSpaces = this.myShowWhiteSpacesBox.isSelected();
        Object selectedDialect = this.myDialectComboBox.getSelectedItem();
        settings.dialect = this.myDialectComboBox.isVisible() && selectedDialect != null ? selectedDialect.toString() : "";
        settings.textDividerLocation = this.myTextSplit.getDividerLocation();
        settings.treeDividerLocation = this.myTreeSplit.getDividerLocation();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPsiTreeBuilder);
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        Disposer.dispose((Disposable)this.myBlockTree);
        Disposer.dispose((Disposable)this.myStubTree);
        super.dispose();
    }

    @Nullable
    private PsiElement resolve(int index) {
        PsiElement[] cache;
        PsiElement element2 = this.getPsiElement();
        if (element2 == null) {
            return null;
        }
        HashMap<PsiElement, PsiElement[]> map2 = (HashMap<PsiElement, PsiElement[]>)this.myRefs.getClientProperty(REFS_CACHE);
        if (map2 == null) {
            map2 = new HashMap<PsiElement, PsiElement[]>();
            this.myRefs.putClientProperty(REFS_CACHE, map2);
        }
        if ((cache = (PsiElement[])map2.get(element2)) == null) {
            PsiReference[] references = element2.getReferences();
            cache = new PsiElement[references.length];
            for (int i = 0; i < references.length; ++i) {
                ResolveResult[] results;
                PsiReference reference2 = references[i];
                PsiElement resolveResult = reference2 instanceof PsiPolyVariantReference ? ((results = ((PsiPolyVariantReference)reference2).multiResolve(true)).length == 0 ? null : results[0].getElement()) : reference2.resolve();
                cache[i] = resolveResult;
            }
            map2.put(element2, cache);
        }
        return index >= cache.length ? null : cache[index];
    }

    @Nullable
    private PsiFile getContainingFileForClass(String fqn) {
        String filename = fqn;
        if (fqn.contains(".")) {
            filename = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        if (filename.contains("$")) {
            filename = filename.substring(0, filename.indexOf(36));
        }
        filename = filename + ".java";
        Object[] files2 = FilenameIndex.getFilesByName((Project)this.myProject, (String)filename, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
        return (PsiFile)ArrayUtil.getFirstElement((Object[])files2);
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (childNode.getUserObject().equals(object)) {
                return childNode;
            }
            TreeNode node = PsiViewerDialog.findNodeWithObject(object, model, childNode);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private void updateEditor() {
        LightVirtualFile lightFile;
        Object source = this.getSource();
        String fileName = "Dummy." + (source instanceof FileType ? ((FileType)source).getDefaultExtension() : "txt");
        if (source instanceof PsiViewerExtension) {
            lightFile = new LightVirtualFile(fileName, ((PsiViewerExtension)source).getDefaultFileType(), (CharSequence)"");
        } else if (source instanceof LanguageFileType) {
            lightFile = new LightVirtualFile(fileName, (Language)ObjectUtils.chooseNotNull((Object)((Language)this.myDialectComboBox.getSelectedItem()), (Object)((LanguageFileType)source).getLanguage()), (CharSequence)"");
        } else if (source instanceof FileType) {
            lightFile = new LightVirtualFile(fileName, (FileType)source, (CharSequence)"");
        } else {
            return;
        }
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)lightFile);
        try {
            this.myEditor.setHighlighter(highlighter);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        JBLabel jBLabel;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TitledSeparator titledSeparator2;
        JSplitPane jSplitPane;
        JPanel jPanel;
        JSplitPane jSplitPane2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTextSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setDividerLocation(250);
        jSplitPane2.setDividerSize(4);
        jSplitPane2.setOrientation(0);
        jPanel2.add((Component)jSplitPane2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myTextPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setLeftComponent(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setRightComponent(jPanel3);
        this.myTreeSplit = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        jSplitPane.setDividerSize(4);
        jPanel3.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel4);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = this.myPsiTree;
        jBScrollPane.setViewportView((Component)tree);
        this.myPsiTreeSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("P&SI Tree");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setDoubleBuffered(true);
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 8, 2, 7, 0, null, null, null));
        this.myShowWhiteSpacesBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Show PsiWhiteSpace");
        jCheckBox2.setMnemonic('W');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowTreeNodesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setSelected(true);
        jCheckBox.setText("Show tree nodes");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(10);
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtensionLabel = jLabel = new JLabel();
        jLabel.setText("Extension:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel6.add((Component)jLabel, "West");
        JComboBox jComboBox = new JComboBox();
        this.myExtensionComboBox = jComboBox;
        jPanel6.add(jComboBox, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDialectLabel = jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jBLabel, "West");
        JComboBox jComboBox2 = new JComboBox();
        this.myDialectComboBox = jComboBox2;
        jPanel7.add(jComboBox2, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIconTextGap(0);
        jLabel2.setText("Show PSI structure for:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel8.add((Component)jLabel2, "West");
        JComboBox jComboBox3 = new JComboBox();
        this.myFileTypeComboBox = jComboBox3;
        jComboBox3.setMaximumRowCount(30);
        jPanel8.add(jComboBox3, "Center");
        this.myTextSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Text");
        titledSeparator.setToolTipText("Type or paste source code which you want to explore, then click Build PSI Tree");
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/psiView/PsiViewerDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/psiView/PsiViewerDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTabPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AutoExpandFocusListener
    extends FocusAdapter {
        private final JComboBox myComboBox;
        private final Component myParent;

        private AutoExpandFocusListener(JComboBox comboBox2) {
            this.myComboBox = comboBox2;
            this.myParent = UIUtil.findUltimateParent((Component)this.myComboBox);
        }

        @Override
        public void focusGained(@NotNull FocusEvent e) {
            if (e == null) {
                AutoExpandFocusListener.$$$reportNull$$$0(0);
            }
            Component from = e.getOppositeComponent();
            if (!e.isTemporary() && from != null && !this.myComboBox.isPopupVisible() && AutoExpandFocusListener.isUnder(from, this.myParent)) {
                this.myComboBox.setPopupVisible(true);
            }
        }

        private static boolean isUnder(Component component2, Component parent) {
            while (component2 != null) {
                if (component2 == parent) {
                    return true;
                }
                component2 = component2.getParent();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$AutoExpandFocusListener", "focusGained"));
        }
    }

    private class EditorListener
    implements SelectionListener,
    DocumentListener,
    CaretListener {
        private EditorListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                EditorListener.$$$reportNull$$$0(0);
            }
            if (!this.available() || PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            ViewerTreeStructure treeStructure = PsiViewerDialog.this.getTreeStructure();
            PsiElement rootPsiElement = treeStructure.getRootPsiElement();
            if (rootPsiElement == null) {
                return;
            }
            PsiElement rootElement = PsiViewerDialog.this.getTreeStructure().getRootPsiElement();
            int baseOffset = rootPsiElement.getTextRange().getStartOffset();
            int offset = PsiViewerDialog.this.myEditor.getCaretModel().getOffset() + baseOffset;
            PsiElement element2 = InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), offset);
            PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element2);
            PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element2);
            PsiViewerDialog.this.myPsiTreeBuilder.select(element2);
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            if (e == null) {
                EditorListener.$$$reportNull$$$0(1);
            }
            if (!this.available() || !PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            ViewerTreeStructure treeStructure = PsiViewerDialog.this.getTreeStructure();
            PsiElement rootElement = treeStructure.getRootPsiElement();
            if (rootElement == null) {
                return;
            }
            SelectionModel selection = PsiViewerDialog.this.myEditor.getSelectionModel();
            TextRange textRange = rootElement.getTextRange();
            int baseOffset = textRange != null ? textRange.getStartOffset() : 0;
            int start2 = selection.getSelectionStart() + baseOffset;
            int end = selection.getSelectionEnd() + baseOffset - 1;
            PsiElement element2 = this.findCommonParent(InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), start2), InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), end));
            if (element2 != null && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus()) {
                PsiViewerDialog.this.myBlockTree.selectNodeFromEditor(element2);
                PsiViewerDialog.this.myStubTree.selectNodeFromEditor(element2);
            }
            PsiViewerDialog.this.myPsiTreeBuilder.select(element2);
        }

        @Nullable
        private PsiElement findCommonParent(PsiElement start2, PsiElement end) {
            PsiElement parent;
            if (end == null || start2 == end) {
                return start2;
            }
            TextRange endRange = end.getTextRange();
            for (parent = start2.getContext(); parent != null && !parent.getTextRange().contains(endRange); parent = parent.getContext()) {
            }
            return parent;
        }

        private boolean available() {
            return PsiViewerDialog.this.myLastParsedTextHashCode == PsiViewerDialog.this.myNewDocumentHashCode && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus();
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                EditorListener.$$$reportNull$$$0(2);
            }
            PsiViewerDialog.this.myNewDocumentHashCode = event.getDocument().getText().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/psiView/PsiViewerDialog$EditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GoToListener
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private RangeHighlighter myListenerHighlighter;
        private final TextAttributes myAttributes = new TextAttributes((Color)JBColor.RED, null, null, null, 0);

        private GoToListener() {
        }

        private void navigate() {
            String fqn;
            PsiFile file2;
            Object value2 = PsiViewerDialog.this.myRefs.getSelectedValue();
            if (value2 instanceof String && (file2 = PsiViewerDialog.this.getContainingFileForClass(fqn = (String)value2)) != null) {
                file2.navigate(true);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(0);
            }
            if (e.getKeyCode() == 10) {
                this.navigate();
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(1);
            }
            if (e.getClickCount() > 1) {
                this.navigate();
            }
        }

        @Override
        public void valueChanged(@NotNull ListSelectionEvent e) {
            PsiReference[] references;
            if (e == null) {
                GoToListener.$$$reportNull$$$0(2);
            }
            this.clearSelection();
            PsiViewerDialog.this.updateDialectsCombo(null);
            PsiViewerDialog.this.updateExtensionsCombo();
            int ind = PsiViewerDialog.this.myRefs.getSelectedIndex();
            PsiElement element2 = PsiViewerDialog.this.getPsiElement();
            if (ind > -1 && element2 != null && ind < (references = element2.getReferences()).length) {
                TextRange textRange = references[ind].getRangeInElement();
                TextRange range2 = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element2, element2.getTextRange());
                int start2 = range2.getStartOffset();
                int end = range2.getEndOffset();
                ViewerTreeStructure treeStructure = PsiViewerDialog.this.getTreeStructure();
                PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                if (rootPsiElement != null) {
                    int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                    start2 -= baseOffset;
                    end -= baseOffset;
                }
                end = (start2 += textRange.getStartOffset()) + textRange.getLength();
                TextAttributes highlightReferenceTextRange = new TextAttributes(null, null, (Color)JBColor.namedColor((String)"PsiViewer.referenceHighlightColor", (int)11059235), EffectType.BOLD_DOTTED_LINE, 0);
                this.myListenerHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start2, end, 6000, highlightReferenceTextRange, HighlighterTargetArea.EXACT_RANGE);
            }
        }

        public void clearSelection() {
            if (this.myListenerHighlighter != null && ArrayUtil.contains((Object)this.myListenerHighlighter, (Object[])PsiViewerDialog.this.myEditor.getMarkupModel().getAllHighlighters())) {
                this.myListenerHighlighter.dispose();
                this.myListenerHighlighter = null;
            }
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(4);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(5);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                GoToListener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/internal/psiView/PsiViewerDialog$GoToListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPsiTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        MyPsiTreeSelectionListener() {
            this.myAttributes.setEffectColor(BOX_COLOR);
            this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                MyPsiTreeSelectionListener.$$$reportNull$$$0(0);
            }
            if (!PsiViewerDialog.this.myEditor.getDocument().getText().equals(PsiViewerDialog.this.myLastParsedText) || PsiViewerDialog.this.myBlockTree.isFocusOwner()) {
                return;
            }
            TreePath path = PsiViewerDialog.this.myPsiTree.getSelectionPath();
            PsiViewerDialog.this.clearSelection();
            if (path != null) {
                PsiElement element2;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                    return;
                }
                ViewerNodeDescriptor descriptor2 = (ViewerNodeDescriptor)((Object)node.getUserObject());
                Object elementObject = descriptor2.getElement();
                Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element2 = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                if (element2 != null) {
                    int textLength;
                    TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element2, element2.getTextRange());
                    int start2 = rangeInHostFile.getStartOffset();
                    int end = rangeInHostFile.getEndOffset();
                    ViewerTreeStructure treeStructure = PsiViewerDialog.this.getTreeStructure();
                    PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                    if (rootPsiElement != null) {
                        int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                        start2 -= baseOffset;
                        end -= baseOffset;
                    }
                    if (end <= (textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength())) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start2, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                            PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start2);
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        }
                    }
                    if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                        PsiViewerDialog.this.myBlockTree.selectNodeFromPsi(element2);
                        PsiViewerDialog.this.myStubTree.selectNodeFromPsi(element2);
                    }
                    PsiViewerDialog.this.updateReferences(element2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$MyPsiTreeSelectionListener", "valueChanged"));
        }
    }

    private static class ExtensionComparator
    implements Comparator<String> {
        private final String myOnTop;

        ExtensionComparator(String onTop) {
            this.myOnTop = onTop;
        }

        @Override
        public int compare(@NotNull String o1, @NotNull String o2) {
            if (o1 == null) {
                ExtensionComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                ExtensionComparator.$$$reportNull$$$0(1);
            }
            if (o1.equals(this.myOnTop)) {
                return -1;
            }
            if (o2.equals(this.myOnTop)) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/psiView/PsiViewerDialog$ExtensionComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

