/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ToggleAutoReloadAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.platform.externalSystem.impl"})
public final class ToggleAutoReloadAction
extends ToggleAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        boolean bl = this.isSelected(e);
        presentation.setDescription(bl ? ExternalSystemBundle.message((String)"action.refresh.project.auto.description.disable", (Object[])new Object[0]) : ExternalSystemBundle.message((String)"action.refresh.project.auto.description.enable", (Object[])new Object[0]));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return false");
        Project project2 = project;
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project2);
        return projectTracker.isAutoReloadExternalChanges();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project2);
        projectTracker.setAutoReloadExternalChanges(state);
    }

    public ToggleAutoReloadAction() {
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        presentation.setIcon(AllIcons.Actions.BuildAutoReloadChanges);
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"templatePresentation");
        presentation2.setText(ExternalSystemBundle.message((String)"action.refresh.project.auto.text", (Object[])new Object[0]));
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"templatePresentation");
        presentation3.setDescription(ExternalSystemBundle.message((String)"action.refresh.project.auto.description.disable", (Object[])new Object[0]));
    }
}

