/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ExternalModuleListStorage;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleGroupersKt;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class ModuleManagerImpl
extends ModuleManagerEx
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTRIBUTE_FILEURL = "fileurl";
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    public static final String ATTRIBUTE_GROUP = "group";
    public static final String IML_EXTENSION = ".iml";
    private static final Logger LOG = Logger.getInstance(ModuleManagerImpl.class);
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    public static final String MODULE_GROUP_SEPARATOR = "/";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    private final ProjectRootManagerEx myProjectRootManager;
    protected volatile ModuleModelImpl myModuleModel;
    private Set<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private boolean myModulesLoaded;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Graph<Module> myCachedModuleProductionGraph;
    private volatile Graph<Module> myCachedModuleTestGraph;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        if (project == null) {
            ModuleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new THashSet();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project;
        this.myMessageBus = project.getMessageBus();
        this.myProjectRootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
    }

    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
        this.myCachedModuleProductionGraph = null;
        this.myCachedModuleTestGraph = null;
    }

    public void dispose() {
        this.myModuleModel.disposeModel();
        this.myProjectRootManager.assertListenersAreDisposed();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.myProject, this.getModules(), false));
        return e;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleManagerImpl.$$$reportNull$$$0(1);
        }
        Set<ModulePath> files2 = ModuleManagerImpl.getPathsToModuleFiles(state);
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            files2.addAll(externalModules);
        }
        this.loadState(files2);
    }

    public void noStateLoaded() {
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            this.loadState(new LinkedHashSet<ModulePath>(externalModules));
        }
    }

    private void loadState(@NotNull Set<ModulePath> modulePaths) {
        if (modulePaths == null) {
            ModuleManagerImpl.$$$reportNull$$$0(2);
        }
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = modulePaths;
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator<ModulePath> iterator2 = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator2.hasNext()) {
            ModulePath modulePath = iterator2.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator2.remove();
        }
        ArrayList<UnloadedModuleDescriptionImpl> unloaded = new ArrayList<UnloadedModuleDescriptionImpl>(UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this));
        if (!unloaded.isEmpty()) {
            this.unloadNewlyAddedModulesIfPossible(this.myModulePathsToLoad, unloaded);
        }
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : unloaded) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        THashMap modulePathMap = new THashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myModulePathsToLoad.clear();
    }

    protected void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload) {
        if (modulesToLoad == null) {
            ModuleManagerImpl.$$$reportNull$$$0(3);
        }
        if (modulesToUnload == null) {
            ModuleManagerImpl.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public static Set<ModulePath> getPathsToModuleFiles(@NotNull Element element2) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element2.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH) : VirtualFileManager.extractPath((String)fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(filepath)), moduleElement.getAttributeValue(ATTRIBUTE_GROUP)));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            ModuleManagerImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(7);
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            this.myModulesLoaded = true;
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        EmptyProgressIndicator progressIndicator2 = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator2.setText("Loading modules...");
        progressIndicator2.setText2("");
        List errors = Collections.synchronizedList(new ArrayList());
        boolean isParallel = Registry.is((String)"parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        ExecutorService service = isParallel ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ModuleManager Loader", (int)Math.min(2, Runtime.getRuntime().availableProcessors())) : ConcurrencyUtil.newSameThreadExecutorService();
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        THashSet paths = new THashSet();
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator2.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            tasks.add(new Pair(service.submit(() -> this.lambda$loadModules$1((ProgressIndicator)progressIndicator2, path, errors, modulePath)), (Object)modulePath));
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        SmartList modulesWithUnknownTypes = new SmartList();
        for (Pair task2 : tasks) {
            if (progressIndicator2.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module = (Module)((Future)task2.first).get();
                if (module == null) continue;
                moduleModel.addModule(module);
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)task2.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split(MODULE_GROUP_SEPARATOR));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        service.shutdown();
        progressIndicator2.checkCanceled();
        this.myModulesLoaded = true;
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            THashMap track = new THashMap();
            for (Module module : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance((Module)module).getContentRootUrls()) {
                    Module oldModule = track.put(url, module);
                    if (oldModule == null) continue;
                    LOG.warn("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification((List<? extends Module>)modulesWithUnknownTypes);
    }

    @NotNull
    private static Module loadModuleInternal(@NotNull String filePath, @NotNull ModuleManagerImpl manager) throws IOException {
        VirtualFile virtualFile;
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            ModuleManagerImpl.$$$reportNull$$$0(9);
        }
        if ((virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(filePath)) != null) {
            virtualFile.setCharset(StandardCharsets.UTF_8, null, false);
        }
        Module module = (Module)ReadAction.compute(() -> {
            ModuleEx module = manager.createAndLoadModule(filePath);
            ModuleManagerImpl.initModule(module, () -> ((ModuleStore)module.getService(IComponentStore.class)).setPath(filePath, virtualFile, false));
            return module;
        });
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(10);
        }
        return module;
    }

    private static void initModule(@NotNull ModuleEx module, @NotNull Runnable beforeComponentCreation) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(11);
        }
        if (beforeComponentCreation == null) {
            ModuleManagerImpl.$$$reportNull$$$0(12);
        }
        try {
            module.init(beforeComponentCreation);
        }
        catch (Throwable e) {
            ModuleManagerImpl.disposeModuleLater(module);
            throw e;
        }
    }

    private void reportError(@NotNull List<? super ModuleLoadingErrorDescription> errors, @NotNull ModulePath modulePath, @NotNull Exception e) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(13);
        }
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ModuleManagerImpl.$$$reportNull$$$0(15);
        }
        errors.add(new ModuleLoadingErrorDescription(ProjectModelBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public boolean areModulesLoaded() {
        return this.myModulesLoaded;
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(16);
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> types) {
        if (types == null) {
            ModuleManagerImpl.$$$reportNull$$$0(17);
        }
    }

    protected void fireModuleAdded(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(18);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module);
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(19);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(20);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(21);
        }
        if (oldNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(22);
        }
        if (modules.isEmpty()) {
            return;
        }
        try {
            for (Module module : this.getModules()) {
                ModuleRootManagerImpl moduleRootManager = (ModuleRootManagerImpl)((Object)ObjectUtils.tryCast((Object)ModuleRootManager.getInstance((Module)module), ModuleRootManagerImpl.class));
                if (moduleRootManager == null) continue;
                moduleRootManager.stateChanged();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules, oldNames::get);
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(23);
        }
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(24);
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription moduleLoadingErrorDescription : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(moduleLoadingErrorDescription.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ModuleManagerImpl.disposeModuleLater(module);
        }
        this.fireModuleLoadErrors(errors);
    }

    private static void disposeModuleLater(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module), module.getDisposed());
    }

    protected void fireModuleLoadErrors(@NotNull List<? extends ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(26);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(27);
        }
        this.myFailedModulePaths.remove(modulePath);
        this.incModificationCount();
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new ModuleModelImpl(this.myModuleModel);
    }

    public void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(28);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(29);
        }
        ModuleManagerImpl.writeExternal(element2, collection, this);
    }

    @ApiStatus.Internal
    public static void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection, ModuleManagerEx moduleManager) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(30);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(31);
        }
        Collection<ModulePath> failedModulePaths = moduleManager.getFailedModulePaths();
        Collection unloadedModuleDescriptions = moduleManager.getUnloadedModuleDescriptions();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.size() + failedModulePaths.size() + unloadedModuleDescriptions.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module, moduleManager));
        }
        for (ModulePath modulePath : failedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModuleDescriptions) {
            sorted.add(new ModulePathSaveItem(((UnloadedModuleDescriptionImpl)unloadedModuleDescription).getModulePath()));
        }
        if (!sorted.isEmpty()) {
            sorted.sort(Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element2.addContent(modules);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(32);
        }
        if (moduleTypeId == null) {
            ModuleManagerImpl.$$$reportNull$$$0(33);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(34);
        }
        return module2;
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String id2) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(35);
        }
        if (id2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(36);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newNonPersistentModule(moduleName, id2);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(37);
        }
        return module2;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(38);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(39);
        }
        return module2;
    }

    public void disposeModule(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    public Module @NotNull [] getModules() {
        ModuleModelImpl model = this.myModuleModel;
        if (model.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = model.getModules();
        if (moduleArray == null) {
            ModuleManagerImpl.$$$reportNull$$$0(41);
        }
        return moduleArray;
    }

    public Module @NotNull [] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Module[] sortedModules = this.myCachedSortedModules;
        if (sortedModules == null) {
            this.myCachedSortedModules = sortedModules = this.myModuleModel.getSortedModules();
        }
        if (sortedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(42);
        }
        return sortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(43);
        }
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Comparator cachedModuleComparator = this.myCachedModuleComparator;
        if (cachedModuleComparator == null) {
            this.myCachedModuleComparator = cachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator comparator2 = cachedModuleComparator;
        if (comparator2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(44);
        }
        return comparator2;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph2 = this.moduleGraph(true);
        if (graph2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(45);
        }
        return graph2;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        Graph graph2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = graph2 = includeTests ? this.myCachedModuleTestGraph : this.myCachedModuleProductionGraph;
        if (graph2 != null) {
            Graph graph3 = graph2;
            if (graph3 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(46);
            }
            return graph3;
        }
        graph2 = this.myModuleModel.moduleGraph(includeTests);
        if (includeTests) {
            this.myCachedModuleTestGraph = graph2;
        } else {
            this.myCachedModuleProductionGraph = graph2;
        }
        Graph graph4 = graph2;
        if (graph4 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(47);
        }
        return graph4;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(48);
        }
        SmartList result2 = new SmartList();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result2.add(aModule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(49);
        }
        return smartList;
    }

    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(50);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(51);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(52);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(53);
        }
        return ModuleRootManager.getInstance((Module)module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(54);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!module.isLoaded()) {
                module.moduleAdded();
                this.fireModuleAdded(module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, @NotNull Runnable runnable2) {
        if (model == null) {
            ModuleManagerImpl.$$$reportNull$$$0(55);
        }
        if (runnable2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(56);
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    protected ModuleEx createNonPersistentModule(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(57);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(@NotNull ModuleModelImpl moduleModel, @NotNull Runnable runnable2) {
        THashSet removedModules;
        THashSet addedModules;
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(58);
        }
        if (runnable2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(59);
        }
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        THashSet newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new THashSet(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new THashSet(oldModules);
            removedModules.removeAll((Collection<?>)newModules);
        }
        this.myProjectRootManager.makeRootsChange(() -> this.lambda$commitModel$7(removedModules, moduleModel, oldModules, runnable2, (Collection)addedModules), false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        Module moduleInMap;
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(60);
        }
        if (oldName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(61);
        }
        LOG.assertTrue((moduleInMap = this.myModuleModel.myModules.remove(oldName)) == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        this.myProjectRootManager.makeRootsChange(() -> this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName)), false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(62);
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    @NotNull
    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules.length + this.myUnloadedModules.size());
        for (Module module : modules) {
            descriptions.add((ModuleDescription)new LoadedModuleDescriptionImpl(module));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        ArrayList<ModuleDescription> arrayList = descriptions;
        if (arrayList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        Collection<UnloadedModuleDescription> collection = Collections.unmodifiableCollection(this.myUnloadedModules.values());
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(64);
        }
        return collection;
    }

    @Override
    public Collection<ModulePath> getFailedModulePaths() {
        return Collections.unmodifiableSet(this.myFailedModulePaths);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(65);
        }
        return this.myUnloadedModules.get(moduleName);
    }

    @NotNull
    public ModuleGrouper getModuleGrouper(@Nullable ModifiableModuleModel model) {
        ModuleGrouper moduleGrouper = ModuleGroupersKt.createGrouper(this.myProject, model);
        if (moduleGrouper == null) {
            ModuleManagerImpl.$$$reportNull$$$0(66);
        }
        return moduleGrouper;
    }

    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(67);
        }
        if (this.myUnloadedModules.keySet().equals(new HashSet<String>(unloadedModuleNames))) {
            return;
        }
        this.setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name : unloadedModuleNames) {
            if (toLoad.containsKey(name)) {
                this.myUnloadedModules.put(name, (UnloadedModuleDescriptionImpl)toLoad.remove(name));
                continue;
            }
            Module module = this.findModuleByName(name);
            if (module == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module);
            ModuleSaveItem saveItem = new ModuleSaveItem(module, this);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List contentRoots2 = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module).getContentRootUrls(), url -> pointerManager.create(url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots2);
            StateStorageManagerKt.saveComponentManager((ComponentManager)module);
            model.disposeModule(module);
            this.myUnloadedModules.put(name, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model).commit());
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void removeUnloadedModules(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(68);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModules) {
            this.myUnloadedModules.remove(unloadedModuleDescription.getName());
        }
        this.setUnloadedModuleNames(new ArrayList<String>(this.myUnloadedModules.keySet()));
    }

    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(69);
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
    }

    public void setModuleGroupPath(@NotNull Module module, String @Nullable [] groupPath2) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(70);
        }
        this.myModuleModel.setModuleGroupPath(module, groupPath2);
    }

    private /* synthetic */ void lambda$commitModel$7(Collection removedModules, ModuleModelImpl moduleModel, Collection oldModules, Runnable runnable2, Collection addedModules) {
        for (Object removedModule : removedModules) {
            this.fireBeforeModuleRemoved((Module)removedModule);
            this.cleanCachedStuff();
        }
        if (!moduleModel.myModulesToDispose.isEmpty()) {
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(oldModules);
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                Disposer.dispose((Disposable)neverAddedModule);
            }
        }
        runnable2.run();
        Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
        Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
        modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap<Module, String> oldNames = new HashMap<Module, String>();
        for (Module module : modulesToBeRenamed) {
            oldNames.put(module, module.getName());
            moduleModel.myModules.remove(module.getName());
            modules.add(module);
            ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module), true);
            moduleModel.myModules.put(module.getName(), module);
            this.myUnloadedModules.remove(module.getName());
        }
        moduleModel.myIsWritable = false;
        this.myModuleModel = moduleModel;
        for (Module module : removedModules) {
            this.fireModuleRemoved(module);
            this.cleanCachedStuff();
            Disposer.dispose((Disposable)module);
            this.cleanCachedStuff();
        }
        for (Module addedModule : addedModules) {
            this.myUnloadedModules.remove(addedModule.getName());
            ((ModuleEx)addedModule).moduleAdded();
            this.cleanCachedStuff();
            this.fireModuleAdded(addedModule);
            this.cleanCachedStuff();
        }
        this.cleanCachedStuff();
        this.fireModulesRenamed(modules, oldNames);
        this.cleanCachedStuff();
        UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
        this.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
    }

    private /* synthetic */ Module lambda$loadModules$1(ProgressIndicator progressIndicator2, String path, List errors, ModulePath modulePath) throws Exception {
        progressIndicator2.setFraction(progressIndicator2.getFraction() + this.myProgressStep);
        return (Module)ProgressManager.getInstance().runProcess(() -> {
            try {
                return this.myProject.isDisposed() ? null : ModuleManagerImpl.loadModuleInternal(path, this);
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
            catch (ProcessCanceledException e) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 63: 
            case 64: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 63: 
            case 64: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToLoad";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToUnload";
                break;
            }
            case 5: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 10: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 63: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 7: 
            case 23: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 8: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 40: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 60: 
            case 62: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULE;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeComponentCreation";
                break;
            }
            case 13: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_MODULES;
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNames";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeId";
                break;
            }
            case 35: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 43: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onModule";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToModuleFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModuleInternal";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "newNonPersistentModule";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModules";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleDependencyComparator";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleGraph";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependentModules";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDescriptions";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModuleDescriptions";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unloadNewlyAddedModulesIfPossible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToModuleFiles";
                break;
            }
            case 6: 
            case 10: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 63: 
            case 64: 
            case 66: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadModuleInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initModule";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAdded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRemoved";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeModuleRemoved";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fireModulesRenamed";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onModuleLoadErrors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disposeModuleLater";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleLoadErrors";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeFailedModulePath";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "newNonPersistentModule";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "disposeModule";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependentModules";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependent";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependsOn";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAddedInWriteAction";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "commitModelWithRunnable";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createNonPersistentModule";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "commitModel";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRenamedByVfsEvent";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroupPath";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModules";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "removeUnloadedModules";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "setModuleGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 34: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 63: 
            case 64: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                ModuleModelImpl.$$$reportNull$$$0(0);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                ModuleModelImpl.$$$reportNull$$$0(1);
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath2 = that.myModuleGroupPath;
            if (groupPath2 != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        public Module @NotNull [] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                this.myModulesCache = cache = modules.toArray(Module.EMPTY_ARRAY);
            }
            if (cache == null) {
                ModuleModelImpl.$$$reportNull$$$0(2);
            }
            return cache;
        }

        private Module @NotNull [] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                ModuleModelImpl.$$$reportNull$$$0(3);
            }
            return allModules;
        }

        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(4);
            }
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(5);
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(6);
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            Module moduleToBeRenamed;
            if (newName == null) {
                ModuleModelImpl.$$$reportNull$$$0(7);
            }
            if ((moduleToBeRenamed = this.getModuleToBeRenamed(newName)) != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(8);
            }
            return this.myModuleToNewName.get(module);
        }

        @NotNull
        public String getActualName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(9);
            }
            String string = (String)ObjectUtils.notNull((Object)this.getNewName(module), (Object)module.getName());
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(11);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(12);
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(13);
            }
            return module;
        }

        @NotNull
        public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
            if (moduleName == null) {
                ModuleModelImpl.$$$reportNull$$$0(14);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(15);
            }
            this.assertWritable();
            ModuleEx module = this.myManager.createNonPersistentModule(moduleName);
            ModuleManagerImpl.initModule(module, () -> module.setModuleType(moduleTypeId));
            this.addModule(module);
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(16);
            }
            return moduleEx;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(17);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(18);
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module != null) {
                ModuleEx moduleEx = module;
                if (moduleEx == null) {
                    ModuleModelImpl.$$$reportNull$$$0(19);
                }
                return moduleEx;
            }
            ModuleEx newModule = module = this.myManager.createModule(filePath);
            String finalFilePath = filePath;
            ModuleManagerImpl.initModule(module, () -> {
                ((ModuleStore)newModule.getService(IComponentStore.class)).setPath(finalFilePath, null, true);
                newModule.setModuleType(moduleTypeId);
                if (options != null) {
                    for (Map.Entry option2 : options.entrySet()) {
                        newModule.setOption((String)option2.getKey(), (String)option2.getValue());
                    }
                }
            });
            this.addModule(module);
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(20);
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(21);
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    ModuleModelImpl.$$$reportNull$$$0(23);
                }
                return string2;
            }
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(22);
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull @SystemIndependent String filePath) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(24);
            }
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull @SystemIndependent String filePath) throws IOException {
            ModuleEx moduleEx;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(25);
            }
            this.assertWritable();
            String resolvedPath = FileUtilRt.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            try {
                ModuleEx module = this.getModuleByFilePath(resolvedPath);
                if (module == null) {
                    module = ModuleManagerImpl.loadModuleInternal(resolvedPath, this.myManager);
                    this.addModule(module);
                }
                moduleEx = module;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectModelBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtilRt.toSystemDependentName((String)resolvedPath), e.getMessage()}), e);
            }
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(26);
            }
            return moduleEx;
        }

        private void addModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(27);
            }
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(28);
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            Module module;
            if (name == null) {
                ModuleModelImpl.$$$reportNull$$$0(29);
            }
            if ((module = this.myModules.get(name)) != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        @NotNull
        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder2 = new DFSTBuilder(this.moduleGraph(true));
            Comparator comparator2 = builder2.comparator();
            if (comparator2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(30);
            }
            return comparator2;
        }

        @NotNull
        private Graph<Module> moduleGraph(final boolean includeTests) {
            Graph graph2 = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

                @NotNull
                public Collection<Module> getNodes() {
                    Collection<Module> collection = myModules.values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                @NotNull
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    Iterator<Module> iterator2 = Arrays.asList(dependentModules).iterator();
                    if (iterator2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNodes";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIn";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }));
            if (graph2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(31);
            }
            return graph2;
        }

        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(32);
            }
            this.myManager.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Set existingModules = ContainerUtil.set((Object[])this.myManager.myModuleModel.getModules());
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            ModuleModelImpl model = this.myManager.myModuleModel;
            return !this.myModules.equals(model.myModules) || !Comparing.equal(model.myModuleGroupPath, this.myModuleGroupPath) || !this.myModuleToNewName.isEmpty();
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            this.myModules.clear();
            for (Module module : modules) {
                Disposer.dispose((Disposable)module);
            }
            this.myModuleGroupPath = null;
        }

        public String[] getModuleGroupPath(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(33);
            }
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module, String @Nullable(value="null means remove") [] groupPath2) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(34);
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath2 == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath2);
            }
        }

        @NotNull
        public Project getProject() {
            Project project = this.myManager.myProject;
            if (project == null) {
                ModuleModelImpl.$$$reportNull$$$0(35);
            }
            return project;
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 27: 
                case 28: 
                case 33: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 11: 
                case 17: 
                case 21: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedModules";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualName";
                    break;
                }
                case 13: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newModule";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newNonPersistentModule";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveShortWindowsName";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModule";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleDependencyComparator";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleGraph";
                    break;
                }
                case 35: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renameModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleToBeRenamed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualName";
                    break;
                }
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "newModule";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "newNonPersistentModule";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveShortWindowsName";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByFilePath";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModule";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "addModule";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeModule";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleByName";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "commitWithRunnable";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleGroupPath";
                    break;
                }
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleGroupPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 26: 
                case 30: 
                case 31: 
                case 35: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;
        private final ModuleManager myModuleManager;

        ModuleSaveItem(@NotNull Module module, @NotNull ModuleManager moduleManager) {
            if (module == null) {
                ModuleSaveItem.$$$reportNull$$$0(0);
            }
            if (moduleManager == null) {
                ModuleSaveItem.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myModuleManager = moduleManager;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath2 = this.myModuleManager.getModuleGroupPath(this.myModule);
            return groupPath2 != null ? StringUtil.join((String[])groupPath2, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleManager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ModuleGroupInterner {
        private final Interner<String> groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, String @Nullable [] group) {
            String[] cached;
            if (model == null) {
                ModuleGroupInterner.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleGroupInterner.$$$reportNull$$$0(1);
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i = 0; i < group.length; ++i) {
                    String g = group[i];
                    cached[i] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = ModuleManagerImpl.ELEMENT_MODULE;
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner";
            objectArray[2] = "setModuleGroupPath";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

