/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ProgressIndicatorUtils {
    private static final Logger LOG = Logger.getInstance(ProgressIndicatorUtils.class);

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress2, @NotNull Disposable parentDisposable) {
        if (progress2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (progress2.isRunning()) {
                    progress2.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$1", "beforeWriteActionStart"));
            }
        }, parentDisposable);
        ProgressIndicator progressIndicator2 = progress2;
        if (progressIndicator2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(2);
        }
        return progressIndicator2;
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task2) {
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(3);
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(false, false), task2);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull ProgressIndicator progressIndicator2, @NotNull ReadTask readTask) {
        if (progressIndicator2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(4);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(5);
        }
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(progressIndicator2, PooledThreadExecutor.INSTANCE, readTask);
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(@NotNull Executor executor, @NotNull ReadTask task2) {
        if (executor == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(6);
        }
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(7);
        }
        return ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(false, false), executor, task2);
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator progressIndicator2) {
        if (action2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(8);
        }
        Ref result2 = new Ref((Object)Boolean.FALSE);
        ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action2)), progressIndicator2 == null ? new ProgressIndicatorBase(false, false) : progressIndicator2);
        return (Boolean)result2.get();
    }

    public static boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2) {
        if (action2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(9);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action2, null);
    }

    public static boolean runWithWriteActionPriority(@NotNull Runnable action2, final @NotNull ProgressIndicator progressIndicator2) {
        ApplicationEx application;
        if (action2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(10);
        }
        if (progressIndicator2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(11);
        }
        if ((application = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            throw new IllegalStateException("Must not call from EDT");
        }
        if (ProgressIndicatorUtils.isWriting(application)) {
            ProgressIndicatorUtils.cancelProcess(progressIndicator2);
            return false;
        }
        Disposable listenerDisposable = Disposer.newDisposable();
        ApplicationListener listener2 = new ApplicationListener(){

            public void beforeWriteActionStart(@NotNull Object action2) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProgressIndicatorUtils.cancelProcess(progressIndicator2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "beforeWriteActionStart"));
            }
        };
        Ref wasCancelled = new Ref();
        ProgressManager.getInstance().runProcess(() -> {
            application.addApplicationListener(listener2, listenerDisposable);
            try {
                if (ProgressIndicatorUtils.isWriting(application)) {
                    ProgressIndicatorUtils.cancelProcess(progressIndicator2);
                    wasCancelled.set((Object)Boolean.TRUE);
                    return;
                }
                action2.run();
            }
            catch (ProcessCanceledException ignore) {
                wasCancelled.set((Object)Boolean.TRUE);
            }
            finally {
                Disposer.dispose((Disposable)listenerDisposable);
            }
        }, progressIndicator2);
        return wasCancelled.get() != Boolean.TRUE;
    }

    private static void cancelProcess(ProgressIndicator progressIndicator2) {
        if (!progressIndicator2.isCanceled()) {
            progressIndicator2.cancel();
        }
    }

    private static boolean isWriting(ApplicationEx application) {
        return application.isWriteActionPending() || application.isWriteActionInProgress();
    }

    @NotNull
    public static CompletableFuture<?> scheduleWithWriteActionPriority(final @NotNull ProgressIndicator progressIndicator2, @NotNull Executor executor, final @NotNull ReadTask readTask) {
        if (progressIndicator2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(12);
        }
        if (executor == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(13);
        }
        if (readTask == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(14);
        }
        final CompletableFuture future2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            if (application.isDisposed() || progressIndicator2.isCanceled() || future2.isCancelled()) {
                future2.complete(null);
                return;
            }
            final Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!progressIndicator2.isCanceled()) {
                        progressIndicator2.cancel();
                        readTask.onCanceled(progressIndicator2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$3", "beforeWriteActionStart"));
                }
            };
            application.addApplicationListener(listener2, listenerDisposable);
            future2.whenComplete((__, ___) -> Disposer.dispose((Disposable)listenerDisposable));
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadTask.Continuation continuation;
                        try {
                            continuation = ProgressIndicatorUtils.runUnderProgress(progressIndicator2, readTask);
                        }
                        catch (Throwable e) {
                            future2.completeExceptionally(e);
                            throw e;
                        }
                        if (continuation == null) {
                            future2.complete(null);
                        } else if (!future2.isCancelled()) {
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (future2.isCancelled()) {
                                        return;
                                    }
                                    Disposer.dispose((Disposable)listenerDisposable);
                                    try {
                                        if (!progressIndicator2.isCanceled()) {
                                            continuation.getAction().run();
                                        }
                                    }
                                    finally {
                                        future2.complete(null);
                                    }
                                }

                                public String toString() {
                                    return "continuation of " + readTask;
                                }
                            }, continuation.getModalityState());
                        }
                    }

                    public String toString() {
                        return readTask.toString();
                    }
                });
            }
            catch (Throwable e) {
                future2.completeExceptionally(e);
                throw e;
            }
        }, ModalityState.any());
        CompletableFuture completableFuture = future2;
        if (completableFuture == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(15);
        }
        return completableFuture;
    }

    private static ReadTask.Continuation runUnderProgress(@NotNull ProgressIndicator progressIndicator2, @NotNull ReadTask task2) {
        if (progressIndicator2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(16);
        }
        if (task2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(17);
        }
        return (ReadTask.Continuation)ProgressManager.getInstance().runProcess(() -> {
            try {
                return task2.runBackgroundProcess(progressIndicator2);
            }
            catch (ProcessCanceledException ignore) {
                return null;
            }
        }, progressIndicator2);
    }

    public static void yieldToPendingWriteActions() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            throw new IllegalStateException("Mustn't be called from within read action");
        }
        if (application.isDispatchThread()) {
            throw new IllegalStateException("Mustn't be called from EDT");
        }
        application.invokeAndWait(EmptyRunnable.INSTANCE, ModalityState.any());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T withTimeout(long timeoutMs, @NotNull Computable<T> computable) {
        if (computable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(18);
        }
        ProgressManager.checkCanceled();
        ProgressIndicator outer = ProgressIndicatorProvider.getGlobalProgressIndicator();
        AbstractProgressIndicatorBase inner = outer != null ? new SensitiveProgressWrapper(outer) : new ProgressIndicatorBase(false, false);
        AtomicBoolean canceledByTimeout = new AtomicBoolean();
        ScheduledFuture<?> cancelProgress = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            canceledByTimeout.set(true);
            inner.cancel();
        }, timeoutMs, TimeUnit.MILLISECONDS);
        try {
            void computation;
            Object object = ProgressManager.getInstance().runProcess((Computable)computation, (ProgressIndicator)inner);
            return (T)object;
        }
        catch (ProcessCanceledException e) {
            if (canceledByTimeout.get()) {
                T t = null;
                return t;
            }
            throw e;
        }
        finally {
            cancelProgress.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithLockAndCheckingCanceled(@NotNull Lock lock, int timeout, @NotNull TimeUnit timeUnit, @NotNull ThrowableComputable<T, E> computable) throws E, ProcessCanceledException {
        if (lock == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(19);
        }
        if (timeUnit == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(20);
        }
        if (computable == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(21);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled(lock, timeout, timeUnit);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    public static void awaitWithCheckCanceled(@NotNull CountDownLatch waiter) {
        if (waiter == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(22);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> waiter.await(10L, TimeUnit.MILLISECONDS)));
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future2) {
        if (future2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(23);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return ProgressIndicatorUtils.awaitWithCheckCanceled(future2, indicator);
    }

    public static <T> T awaitWithCheckCanceled(@NotNull Future<T> future2, @Nullable ProgressIndicator indicator) {
        if (future2 == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(24);
        }
        while (true) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                return future2.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException | TimeoutException exception) {
                continue;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)cause;
                }
                if (cause instanceof CancellationException) {
                    throw new ProcessCanceledException(cause);
                }
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Lock lock, int timeout, @NotNull TimeUnit timeUnit) {
        if (lock == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(25);
        }
        if (timeUnit == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(26);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((ThrowableComputable<Boolean, ? extends Exception>)((ThrowableComputable)() -> lock.tryLock(timeout, timeUnit)));
    }

    public static void awaitWithCheckCanceled(@NotNull ThrowableComputable<Boolean, ? extends Exception> waiter) {
        if (waiter == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(27);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        boolean success = false;
        while (!success) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
            try {
                success = (Boolean)waiter.compute();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                throw new ProcessCanceledException((Throwable)e);
            }
        }
    }

    public static void checkCancelledEvenWithPCEDisabled(@Nullable ProgressIndicator indicator) {
        if (indicator != null && indicator.isCanceled()) {
            indicator.checkCanceled();
            throw new ProcessCanceledException();
        }
    }

    public static void awaitWithCheckCanceled(@NotNull Semaphore semaphore, @Nullable ProgressIndicator indicator) {
        if (semaphore == null) {
            ProgressIndicatorUtils.$$$reportNull$$$0(28);
        }
        while (!semaphore.waitFor(10L)) {
            ProgressIndicatorUtils.checkCancelledEvenWithPCEDisabled(indicator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 3: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readTask";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waiter";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semaphore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/ProgressIndicatorUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forceWriteActionPriority";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleWithWriteActionPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forceWriteActionPriority";
                break;
            }
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWithWriteActionPriority";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithWriteActionPriority";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withTimeout";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeWithLockAndCheckingCanceled";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "awaitWithCheckCanceled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

