/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.CycleFinder;
import com.intellij.util.graph.impl.KShortestPathsFinder;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph2, @NotNull Node start2, @NotNull Node finish) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(0);
        }
        if (start2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(2);
        }
        return this.findShortestPath((InboundSemiGraph<Node>)graph2, start2, finish);
    }

    @Nullable
    public <Node> List<Node> findShortestPath(@NotNull InboundSemiGraph<Node> graph2, @NotNull Node start2, @NotNull Node finish) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(3);
        }
        if (start2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(4);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(5);
        }
        return new ShortestPathFinder<Node>(graph2).findPath(start2, finish);
    }

    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph2, @NotNull Node start2, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(6);
        }
        if (start2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(7);
        }
        if (finish == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(8);
        }
        if (progressIndicator2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(9);
        }
        List<List<Node>> list2 = new KShortestPathsFinder<Node>(graph2, start2, finish, progressIndicator2).findShortestPaths(k);
        if (list2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph2, @NotNull Node node) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(11);
        }
        if (node == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(12);
        }
        Set<List<Node>> set = new CycleFinder<Node>(graph2).getNodeCycles(node);
        if (set == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(14);
        }
        return new Graph<Node>(){

            @NotNull
            public Collection<Node> getNodes() {
                Collection collection = graph2.getNodes();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @NotNull
            public Iterator<Node> getIn(Node n) {
                Iterator iterator2 = graph2.getOut(n);
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            @NotNull
            public Iterator<Node> getOut(Node n) {
                Iterator iterator2 = graph2.getIn(n);
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOut";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(15);
        }
        DFSTBuilder builder2 = new DFSTBuilder(graph2);
        Collection components = builder2.getComponents();
        final ArrayList<Chunk> chunks = new ArrayList<Chunk>(components.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        for (Collection component2 : components) {
            Set chunkNodes = component2.size() == 1 ? Collections.singleton(component2.iterator().next()) : new LinkedHashSet(component2);
            Chunk chunk = new Chunk(chunkNodes);
            chunks.add(chunk);
            for (Object node : component2) {
                nodeToChunkMap.put(node, chunk);
            }
        }
        Graph graph3 = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Chunk<Node>>(){

            @NotNull
            public Collection<Chunk<Node>> getNodes() {
                List list2 = chunks;
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @NotNull
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph2.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                Iterator iterator2 = ins.iterator();
                if (iterator2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph3 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(16);
        }
        return graph3;
    }

    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph2, Node start2, Set<? super Node> set) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(17);
        }
        if (!set.add(start2)) {
            return;
        }
        Stack stack = new Stack();
        stack.push(start2);
        while (!stack.empty()) {
            Object currentNode = stack.pop();
            Iterator successorIterator = graph2.getOut(currentNode);
            while (successorIterator.hasNext()) {
                Object successor = successorIterator.next();
                if (!set.add(successor)) continue;
                stack.push(successor);
            }
        }
    }

    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph2) {
        if (graph2 == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(18);
        }
        Collection collection = this.computeSCCGraph(graph2).getNodes();
        if (collection == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<? extends List<Node>> paths) {
        if (paths == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(20);
        }
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result2.add(path);
        }
        ArrayList<List<Node>> arrayList = result2;
        if (arrayList == null) {
            GraphAlgorithmsImpl.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/impl/GraphAlgorithmsImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findKShortestPaths";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSCCGraph";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStronglyConnectedComponents";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "removePathsWithCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findShortestPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findKShortestPaths";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCycles";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invertEdgeDirections";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSCCGraph";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectOutsRecursively";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeStronglyConnectedComponents";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removePathsWithCycles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

