/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.api;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspace.api.VirtualFileUrl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001dJ@\u0010\u001e\u001a\u00020\u001b*\u00060\u001fj\u0002` 2\u0006\u0010\u0016\u001a\u00020\u00052\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u000b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/workspace/api/VirtualFileUrlManager;", "", "()V", "id2parent", "Ljava/util/concurrent/ConcurrentMap;", "", "id2segment", "", "nextId", "Ljava/util/concurrent/atomic/AtomicInteger;", "parent2id", "Lkotlin/Pair;", "segmentInterner", "fromPath", "Lcom/intellij/workspace/api/VirtualFileUrl;", "path", "fromUrl", "url", "getOrCreateId", "parent", "segmentName", "getParentVirtualUrlById", "id", "getParentVirtualUrlById$intellij_platform_workspaceModel_core", "getUrlById", "getUrlById$intellij_platform_workspaceModel_core", "isEqualOrParentOf", "", "child", "isEqualOrParentOf$intellij_platform_workspaceModel_core", "buildUrlById", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "hierarchyMap", "segmentMap", "intellij.platform.workspaceModel.core"})
public final class VirtualFileUrlManager {
    private static final ConcurrentMap<Integer, Integer> id2parent;
    private static final ConcurrentMap<Integer, String> id2segment;
    private static final ConcurrentMap<Pair<Integer, String>, Integer> parent2id;
    private static final ConcurrentMap<String, String> segmentInterner;
    private static final AtomicInteger nextId;
    public static final VirtualFileUrlManager INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VirtualFileUrl fromUrl(@NotNull String url) {
        int n;
        void $this$fold$iv;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Object object = url;
        boolean bl = false;
        if (object.length() == 0) {
            return new VirtualFileUrl(0);
        }
        object = StringsKt.split$default((CharSequence)url, (char[])new char[]{'/', '\\'}, (boolean)false, (int)0, (int)6, null);
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void segmentName;
            String string = (String)element$iv;
            int parentId = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = INSTANCE.getOrCreateId(parentId, (String)segmentName);
        }
        int n2 = n = accumulator$iv;
        return new VirtualFileUrl(n2);
    }

    @NotNull
    public final VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = path;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return new VirtualFileUrl(0);
        }
        return this.fromUrl("file://" + FileUtil.toSystemIndependentName((String)path));
    }

    private final int getOrCreateId(int parent, String segmentName) {
        ConcurrentMap<String, String> $this$getOrPut$iv = segmentInterner;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(segmentName);
        if (object == null) {
            boolean bl = false;
            String string = segmentName;
            boolean bl2 = false;
            boolean bl3 = false;
            String default$iv = string;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(segmentName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        String internedSegmentName = (String)object;
        Integer n = (Integer)parent2id.get(TuplesKt.to((Object)parent, (Object)internedSegmentName));
        return n != null ? n.intValue() : ((Number)((Function0)new Function0<Integer>(parent, internedSegmentName){
            final /* synthetic */ int $parent;
            final /* synthetic */ String $internedSegmentName;

            /*
             * WARNING - void declaration
             */
            public final int invoke() {
                void var1_1;
                int newId = VirtualFileUrlManager.access$getNextId$p(VirtualFileUrlManager.INSTANCE).getAndIncrement();
                ((Map)VirtualFileUrlManager.access$getId2parent$p(VirtualFileUrlManager.INSTANCE)).put(newId, this.$parent);
                ((Map)VirtualFileUrlManager.access$getId2segment$p(VirtualFileUrlManager.INSTANCE)).put(newId, this.$internedSegmentName);
                ((Map)VirtualFileUrlManager.access$getParent2id$p(VirtualFileUrlManager.INSTANCE)).put(TuplesKt.to((Object)this.$parent, (Object)this.$internedSegmentName), newId);
                return (int)var1_1;
            }
            {
                this.$parent = n;
                this.$internedSegmentName = string;
                super(0);
            }
        }).invoke()).intValue();
    }

    @NotNull
    public final String getUrlById$intellij_platform_workspaceModel_core(int id2) {
        String string;
        if (id2 <= 0) {
            string = "";
        } else {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl4 = false;
            INSTANCE.buildUrlById($this$buildString, id2, id2parent, id2segment);
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    @Nullable
    public final VirtualFileUrl getParentVirtualUrlById$intellij_platform_workspaceModel_core(int id2) {
        Integer n = (Integer)id2parent.get(id2);
        if (n == null) {
            return null;
        }
        int parentId = n;
        if (parentId <= 0) {
            return null;
        }
        return new VirtualFileUrl(parentId);
    }

    private final boolean buildUrlById(@NotNull StringBuilder $this$buildUrlById, int id2, ConcurrentMap<Integer, Integer> hierarchyMap, ConcurrentMap<Integer, String> segmentMap) {
        String segmentName = (String)MapsKt.getValue((Map)segmentMap, (Object)id2);
        Integer parent = (Integer)MapsKt.getValue((Map)hierarchyMap, (Object)id2);
        if (Intrinsics.compare((int)parent, (int)0) <= 0) {
            $this$buildUrlById.append(segmentName);
            return true;
        }
        Integer n = parent;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"parent");
        this.buildUrlById($this$buildUrlById, n, id2parent, id2segment);
        $this$buildUrlById.append("/");
        $this$buildUrlById.append(segmentName);
        return false;
    }

    public final boolean isEqualOrParentOf$intellij_platform_workspaceModel_core(@NotNull VirtualFileUrl parent, @NotNull VirtualFileUrl child2) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)child2, (String)"child");
        if (parent.getId$intellij_platform_workspaceModel_core() == 0 && child2.getId$intellij_platform_workspaceModel_core() == 0) {
            return true;
        }
        int current2 = child2.getId$intellij_platform_workspaceModel_core();
        while (current2 > 0) {
            if (parent.getId$intellij_platform_workspaceModel_core() == current2) {
                return true;
            }
            Integer n = (Integer)id2parent.get(current2);
            if (n == null) {
                return false;
            }
            current2 = n;
        }
        return false;
    }

    private VirtualFileUrlManager() {
    }

    static {
        VirtualFileUrlManager virtualFileUrlManager;
        INSTANCE = virtualFileUrlManager = new VirtualFileUrlManager();
        id2parent = new ConcurrentHashMap();
        id2segment = new ConcurrentHashMap();
        parent2id = new ConcurrentHashMap();
        segmentInterner = new ConcurrentHashMap();
        nextId = new AtomicInteger(1);
    }

    public static final /* synthetic */ AtomicInteger access$getNextId$p(VirtualFileUrlManager $this) {
        VirtualFileUrlManager virtualFileUrlManager = $this;
        return nextId;
    }

    public static final /* synthetic */ ConcurrentMap access$getId2parent$p(VirtualFileUrlManager $this) {
        VirtualFileUrlManager virtualFileUrlManager = $this;
        return id2parent;
    }

    public static final /* synthetic */ ConcurrentMap access$getId2segment$p(VirtualFileUrlManager $this) {
        VirtualFileUrlManager virtualFileUrlManager = $this;
        return id2segment;
    }

    public static final /* synthetic */ ConcurrentMap access$getParent2id$p(VirtualFileUrlManager $this) {
        VirtualFileUrlManager virtualFileUrlManager = $this;
        return parent2id;
    }
}

