/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateKeyStore;
import com.intellij.execution.rmi.ssl.SslSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public class SslTrustStore
extends DelegateKeyStore {
    private static final String NAME = "idea-trust-store";

    public SslTrustStore() {
        super(KeyStore.getDefaultType());
    }

    public static void setDefault() {
        System.setProperty("javax.net.ssl.trustStoreType", NAME);
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", SslTrustStore.getDefaultKeyStorePath());
        }
    }

    private void appendUserCert() {
        try {
            List<X509Certificate> certs = SslSocketFactory.loadCertificates(System.getProperty("sslCaCertPath"));
            for (int i = 0; i < certs.size(); ++i) {
                this.delegate.setCertificateEntry("user-provided-ca" + (i == 0 ? "" : "-" + i), certs.get(i));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.delegate.load(null, null);
        this.appendUserCert();
    }

    static {
        ourProvider.setProperty("KeyStore.idea-trust-store", SslTrustStore.class.getName());
    }
}

