/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.converters.curl.parser;

import com.intellij.ws.converters.curl.exceptions.CurlParseException;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlFormData {
    private final String myName;
    private final List<RestClientRequest.KeyValuePair> myHeaders;
    private String myContent;
    private boolean hasFileContent;
    private File myFile;
    private ContentType myFormContentType;

    public CurlFormData(@NotNull String formData) {
        if (formData == null) {
            CurlFormData.$$$reportNull$$$0(0);
        }
        this.myHeaders = new ArrayList<RestClientRequest.KeyValuePair>();
        this.myFormContentType = ContentType.create((String)"*/*", (String)"UTF-8");
        int equalSignPosition = formData.indexOf(61);
        if (equalSignPosition < 0) {
            throw CurlParseException.newInvalidFormDataException(formData);
        }
        this.myName = formData.substring(0, equalSignPosition);
        int semicolonPosition = formData.indexOf(59);
        String contentString = formData.substring(equalSignPosition + 1, semicolonPosition < 0 ? formData.length() : semicolonPosition);
        this.parseContent(contentString);
        if (semicolonPosition >= 0) {
            this.parseAdditionalOption(formData.substring(semicolonPosition + 1));
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CurlFormData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            CurlFormData.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean hasFileContent() {
        return this.hasFileContent;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public ContentType getFormContentType() {
        ContentType contentType = this.myFormContentType;
        if (contentType == null) {
            CurlFormData.$$$reportNull$$$0(3);
        }
        return contentType;
    }

    @NotNull
    public List<RestClientRequest.KeyValuePair> getHeaders() {
        List<RestClientRequest.KeyValuePair> list = this.myHeaders;
        if (list == null) {
            CurlFormData.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void parseContent(@NotNull String contentString) {
        if (contentString == null) {
            CurlFormData.$$$reportNull$$$0(5);
        }
        if (contentString.startsWith("@")) {
            this.myContent = contentString.substring(1);
            this.hasFileContent = true;
            this.myFile = new File(this.myContent);
        } else {
            this.myContent = contentString;
            this.hasFileContent = false;
        }
    }

    private void parseAdditionalOption(@NotNull String additionalFormData) {
        int equalSignPosition;
        if (additionalFormData == null) {
            CurlFormData.$$$reportNull$$$0(6);
        }
        if ((equalSignPosition = additionalFormData.indexOf(61)) >= 0) {
            String additionalOptionKey = additionalFormData.substring(0, equalSignPosition);
            String additionalOptionValue = additionalFormData.substring(equalSignPosition + 1).replaceAll("^\"|\"$|^'|'$", "");
            if (additionalOptionKey.equals("filename") && this.hasFileContent) {
                this.myFile = new File(this.myFile.getParent(), additionalOptionValue);
            } else if (additionalOptionKey.equals("type")) {
                this.myFormContentType = ContentType.create((String)additionalOptionValue, (String)"UTF-8");
            } else if (additionalOptionKey.equals("headers")) {
                int colonPosition = additionalOptionValue.indexOf(58);
                if (colonPosition < 0) {
                    this.myHeaders.add(new RestClientRequest.KeyValuePair(additionalOptionValue, ""));
                } else {
                    this.myHeaders.add(new RestClientRequest.KeyValuePair(additionalOptionValue.substring(0, colonPosition), additionalOptionValue.substring(colonPosition + 1).trim()));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formData";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/converters/curl/parser/CurlFormData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFormData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/converters/curl/parser/CurlFormData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormContentType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAdditionalOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

