/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.ws.http.request.HttpRequestPsiConverter;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpResponseHandler;
import com.intellij.ws.http.request.psi.HttpResponseScript;
import com.intellij.ws.http.request.psi.HttpScriptBody;
import com.intellij.ws.http.request.run.HttpClientResponseHandler;
import com.intellij.ws.http.request.run.HttpRequestNotifications;
import com.intellij.ws.http.request.run.HttpRequestPostProcessor;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.http.request.run.HttpScratchRequestPostProcessor;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRunRequestInfo {
    private final ThrowableComputable<RestClientRequest, HttpRequestValidationException> myRequestComputable;
    private final HttpClientResponseHandler myResponseHandler;
    private final HttpRequestPostProcessor myPostProcessor;
    private final SmartPsiElementPointer<HttpRequest> myRequestPointer;
    private RestClientRequest myCachedRequest;

    private HttpRunRequestInfo(@NotNull ThrowableComputable<RestClientRequest, HttpRequestValidationException> requestComputable, @NotNull HttpRequestPostProcessor postProcessor, @NotNull SmartPsiElementPointer<HttpRequest> pointer, @Nullable HttpClientResponseHandler responseHandler) {
        if (requestComputable == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(0);
        }
        if (postProcessor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(1);
        }
        if (pointer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(2);
        }
        this.myRequestComputable = requestComputable;
        this.myResponseHandler = responseHandler;
        this.myPostProcessor = postProcessor;
        this.myRequestPointer = pointer;
    }

    public static HttpRunRequestInfo create(@NotNull HttpRequest psiRequest, @NotNull SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (psiRequest == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(3);
        }
        if (pointerToOriginalElement == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(5);
        }
        ThrowableComputable request = () -> HttpRequestPsiConverter.toRestClientRequest(psiRequest, substitutor);
        HttpClientResponseHandler responseHandler = HttpRunRequestInfo.createHandler(psiRequest.getResponseHandler());
        PsiFile file = psiRequest.getContainingFile();
        HttpRequestPostProcessor processor = file != null && ScratchUtil.isScratch((VirtualFile)file.getOriginalFile().getVirtualFile()) ? new HttpScratchRequestPostProcessor(pointerToOriginalElement) : HttpRequestPostProcessor.EMPTY_PROCESSOR;
        return new HttpRunRequestInfo((ThrowableComputable<RestClientRequest, HttpRequestValidationException>)request, processor, pointerToOriginalElement, responseHandler);
    }

    @Nullable
    public static HttpClientResponseHandler createHandler(@Nullable HttpResponseHandler handler) {
        if (handler != null) {
            PsiElement scriptHolder = handler.getResponseScriptHolder();
            if (scriptHolder instanceof HttpResponseScript) {
                String text;
                HttpScriptBody body = ((HttpResponseScript)scriptHolder).getScriptBody();
                String string = text = body != null ? body.getText() : null;
                if (StringUtil.isNotEmpty((String)text)) {
                    return new HttpClientResponseHandler(text);
                }
            } else if (scriptHolder instanceof HttpFilePath) {
                PsiFile file = FileReferenceUtil.findFile((PsiElement)scriptHolder);
                if (file != null) {
                    return new HttpClientResponseHandler(file.getText());
                }
                Project project = handler.getProject();
                String title = RestClientBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]);
                String path = ((HttpFilePath)scriptHolder).getPresentablePath();
                HttpRequestNotifications.showWarningBalloon(project, title, RestClientBundle.message("rest.client.request.cannot.find.response.handler", path));
            }
        }
        return null;
    }

    @NotNull
    public RestClientRequest getRequest() throws HttpRequestValidationException {
        if (this.myCachedRequest == null) {
            this.myCachedRequest = (RestClientRequest)this.myRequestComputable.compute();
        }
        RestClientRequest restClientRequest = this.myCachedRequest;
        if (restClientRequest == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(6);
        }
        return restClientRequest;
    }

    @NotNull
    public HttpRequestPostProcessor getPostProcessor() {
        HttpRequestPostProcessor httpRequestPostProcessor = this.myPostProcessor;
        if (httpRequestPostProcessor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(7);
        }
        return httpRequestPostProcessor;
    }

    @Nullable
    public HttpClientResponseHandler getResponseHandler() {
        return this.myResponseHandler;
    }

    @NotNull
    public SmartPsiElementPointer<HttpRequest> getRequestPointer() {
        SmartPsiElementPointer<HttpRequest> smartPsiElementPointer = this.myRequestPointer;
        if (smartPsiElementPointer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(8);
        }
        return smartPsiElementPointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestComputable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRequest";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerToOriginalElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/run/HttpRunRequestInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/run/HttpRunRequestInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

