/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.console;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.rest.client.RestClientBundle;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter;", "Lcom/intellij/execution/filters/AbstractFileHyperlinkFilter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "messagePattern", "Ljava/util/regex/Pattern;", "getErrorInformation", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "line", "", "parse", "", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "Companion", "ErrorInformation", "intellij.restClient"})
public final class HttpRequestErrorFileFilter
extends AbstractFileHyperlinkFilter {
    private final Pattern messagePattern = com.intellij.ws.http.request.run.console.HttpRequestErrorFileFilter$Companion.access$createPattern(Companion);
    private static final long REG_EXP_TIMEOUT = 100L;
    private static final int MESSAGE_GROUP = 1;
    private static final int POSITION_GROUP = 2;
    private static final int PATH_GROUP = 3;
    private static final int LINE_GROUP = 4;
    private static final int COLUMN_GROUP = 5;
    private static final String BASE_DIR;
    public static final Companion Companion;

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        ErrorInformation errorInformation = this.getErrorInformation(line);
        return CollectionsKt.listOfNotNull((Object)(errorInformation != null ? errorInformation.getPosition() : null));
    }

    @Nullable
    public final ErrorInformation getErrorInformation(@NotNull String line) {
        MatchResult matcher;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        try {
            matcher = this.messagePattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
            if (!((Matcher)matcher).find()) {
                return null;
            }
            matcher = ((Matcher)matcher).toMatchResult();
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        MatchResult matchResult = matcher;
        if (matchResult.group(2) == null) {
            return null;
        }
        int pathBegin = matchResult.start(2);
        int pathEnd = matchResult.end(2);
        String path = matchResult.group(3);
        Object object = matchResult.group(4);
        Integer linePosition = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
        Object object2 = matchResult.group(5);
        Integer columnPosition = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? Integer.valueOf((Integer)object2 - 1) : null;
        String message = matchResult.group(1);
        if (path == null || linePosition == null || columnPosition == null || message == null) {
            return null;
        }
        return new ErrorInformation(new FileHyperlinkRawData(path, linePosition.intValue(), columnPosition.intValue(), pathBegin, pathEnd), message);
    }

    private HttpRequestErrorFileFilter(Project project) {
        super(project, BASE_DIR);
    }

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    @NotNull
    public static final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$ErrorInformation;", "", "position", "Lcom/intellij/execution/filters/FileHyperlinkRawData;", "message", "", "(Lcom/intellij/execution/filters/FileHyperlinkRawData;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getPosition", "()Lcom/intellij/execution/filters/FileHyperlinkRawData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    public static final class ErrorInformation {
        @NotNull
        private final FileHyperlinkRawData position;
        @NotNull
        private final String message;

        @NotNull
        public final FileHyperlinkRawData getPosition() {
            return this.position;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public ErrorInformation(@NotNull FileHyperlinkRawData position, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.position = position;
            this.message = message;
        }

        @NotNull
        public final FileHyperlinkRawData component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ErrorInformation copy(@NotNull FileHyperlinkRawData position, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            return new ErrorInformation(position, message);
        }

        public static /* synthetic */ ErrorInformation copy$default(ErrorInformation errorInformation, FileHyperlinkRawData fileHyperlinkRawData, String string, int n, Object object) {
            if ((n & 1) != 0) {
                fileHyperlinkRawData = errorInformation.position;
            }
            if ((n & 2) != 0) {
                string = errorInformation.message;
            }
            return errorInformation.copy(fileHyperlinkRawData, string);
        }

        @NotNull
        public String toString() {
            return "ErrorInformation(position=" + this.position + ", message=" + this.message + ")";
        }

        public int hashCode() {
            FileHyperlinkRawData fileHyperlinkRawData = this.position;
            String string = this.message;
            return (fileHyperlinkRawData != null ? fileHyperlinkRawData.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ErrorInformation)) break block3;
                    ErrorInformation errorInformation = (ErrorInformation)object;
                    if (!Intrinsics.areEqual((Object)this.position, (Object)errorInformation.position) || !Intrinsics.areEqual((Object)this.message, (Object)errorInformation.message)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter$Companion;", "", "()V", "BASE_DIR", "", "COLUMN_GROUP", "", "LINE_GROUP", "MESSAGE_GROUP", "PATH_GROUP", "POSITION_GROUP", "REG_EXP_TIMEOUT", "", "createPattern", "Ljava/util/regex/Pattern;", "getInstance", "Lcom/intellij/ws/http/request/run/console/HttpRequestErrorFileFilter;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.restClient"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final HttpRequestErrorFileFilter getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, HttpRequestErrorFileFilter.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026orFileFilter::class.java)");
            return (HttpRequestErrorFileFilter)((Object)object);
        }

        private final Pattern createPattern() {
            String descriptionPattern = "(.+)";
            String pathPattern = "(([^:]+):(\\d+):(\\d+))$";
            String string = RestClientBundle.message("http.client.request.error.message.begin", descriptionPattern, pathPattern);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RestClientBundle.message\u2026tionPattern, pathPattern)");
            String string2 = string;
            int n = 0;
            boolean bl = false;
            Pattern pattern = Pattern.compile(string2, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
            return pattern;
        }

        private Companion() {
        }

        public static final /* synthetic */ Pattern access$createPattern(Companion $this) {
            return $this.createPattern();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

