/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.appcfg;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.commandInterface.command.Argument;
import com.jetbrains.commandInterface.command.ArgumentsInfo;
import com.jetbrains.commandInterface.command.Help;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppcfgArgumentsInfo
implements ArgumentsInfo {
    @NotNull
    private final List<? extends Pair<Boolean, Argument>> myArgs;

    public AppcfgArgumentsInfo(@NotNull List<? extends Pair<Boolean, Argument>> args2) {
        if (args2 == null) {
            AppcfgArgumentsInfo.$$$reportNull$$$0(0);
        }
        this.myArgs = args2;
    }

    @Override
    @Nullable
    public Pair<Boolean, Argument> getArgument(int argumentPosition) {
        return argumentPosition >= this.myArgs.size() ? null : this.myArgs.get(argumentPosition);
    }

    public static ArgumentsInfo parseArguments(@NotNull Module module, @NotNull String arguments) {
        if (module == null) {
            AppcfgArgumentsInfo.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            AppcfgArgumentsInfo.$$$reportNull$$$0(2);
        }
        String[] tokens = arguments.split(" ");
        ArrayList<Pair> parsedArgs = new ArrayList<Pair>(tokens.length);
        for (String arg : tokens) {
            Help helpText = new Help(arg);
            if (arg.startsWith("<") && arg.endsWith(">")) {
                Pair<List<String>, Boolean> values = null;
                if (arg.equals("<directory>")) {
                    values = AppcfgArgumentsInfo.getProjectDirectoryArg(module);
                }
                Argument argument = values == null ? new Argument(helpText) : new Argument(helpText, values);
                parsedArgs.add(Pair.create((Object)true, (Object)argument));
            }
            if (!arg.startsWith("[") || !arg.endsWith("]")) continue;
            parsedArgs.add(Pair.create((Object)false, (Object)new Argument(helpText)));
        }
        return new AppcfgArgumentsInfo(parsedArgs);
    }

    protected static Pair<List<String>, Boolean> getProjectDirectoryArg(@NotNull Module module) {
        AppEngineFacetConfiguration config;
        if (module == null) {
            AppcfgArgumentsInfo.$$$reportNull$$$0(3);
        }
        if ((config = AppEngineFacet.getConfig(module)) != null) {
            String path = FileUtil.toSystemDependentName((String)config.getProjectRoot());
            String basePath = module.getProject().getBasePath();
            if (basePath != null) {
                path = FileUtil.getRelativePath((String)FileUtil.toSystemDependentName((String)basePath), (String)path, (char)File.separatorChar);
            }
            return Pair.create(Collections.singletonList(path), (Object)false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/appcfg/AppcfgArgumentsInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectDirectoryArg";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

