/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.ref;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.SyntheticFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.util.AppEngineUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class AppEngineStaticFileReferenceHelper
extends FileReferenceHelper {
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file2) {
        Module module;
        if (file2 == null) {
            AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project)) == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<PsiFileSystemItem> list = AppEngineStaticFileReferenceHelper.getContexts(project, module);
        if (list == null) {
            AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static List<PsiFileSystemItem> getContexts(Project project, Module module) {
        AppEngineFacetConfiguration config = AppEngineFacet.getConfig(module);
        if (config == null) {
            return Collections.emptyList();
        }
        YAMLFile yaml = AppEngineUtil.getAppYaml(project, config.getProjectRoot());
        if (yaml == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        for (YAMLDocument document : yaml.getDocuments()) {
            YAMLValue compoundValue;
            YAMLKeyValue topKeyValue = YAMLUtil.findKeyInProbablyMapping((YAMLValue)document.getTopLevelValue(), (String)"handlers");
            if (topKeyValue == null || !((compoundValue = topKeyValue.getValue()) instanceof YAMLSequence)) continue;
            for (YAMLSequenceItem sequenceItem : ((YAMLSequence)compoundValue).getItems()) {
                String url = null;
                String staticDir = null;
                for (YAMLKeyValue keyValue : sequenceItem.getKeysValues()) {
                    String keyText = keyValue.getKeyText();
                    String valueText = keyValue.getValueText();
                    if ("url".equals(keyText)) {
                        url = valueText;
                        continue;
                    }
                    if (!"static_dir".equals(keyText)) continue;
                    staticDir = valueText;
                }
                if (url == null || staticDir == null) continue;
                url = StringUtil.trimStart(url, (String)"/");
                staticDir = StringUtil.trimStart(staticDir, (String)"/");
                VirtualFile root = project.getBaseDir().findFileByRelativePath(staticDir);
                if (root == null || !root.isDirectory()) continue;
                PsiDirectory directory2 = PsiManager.getInstance((Project)project).findDirectory(root);
                contexts.add((PsiFileSystemItem)new AppEngineStaticDirectory(project, directory2, url));
            }
        }
        return contexts;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(3);
        }
        List<PsiFileSystemItem> list = AppEngineStaticFileReferenceHelper.getContexts(module.getProject(), module);
        if (list == null) {
            AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isMine(Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            AppEngineStaticFileReferenceHelper.$$$reportNull$$$0(5);
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/ref/AppEngineStaticFileReferenceHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/ref/AppEngineStaticFileReferenceHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AppEngineStaticDirectory
    extends SyntheticFileSystemItem {
        private final PsiDirectory myStaticRoot;
        private final String myUrl;

        AppEngineStaticDirectory(Project project, PsiDirectory root, String url) {
            super(project);
            this.myStaticRoot = root;
            this.myUrl = url;
        }

        @NotNull
        public String getName() {
            String string = this.myUrl;
            if (string == null) {
                AppEngineStaticDirectory.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public PsiFileSystemItem getParent() {
            return null;
        }

        public VirtualFile getVirtualFile() {
            return this.myStaticRoot.getVirtualFile();
        }

        public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
            if (processor2 == null) {
                AppEngineStaticDirectory.$$$reportNull$$$0(1);
            }
            return this.myStaticRoot.processChildren(processor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/appengine/ref/AppEngineStaticFileReferenceHelper$AppEngineStaticDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/appengine/ref/AppEngineStaticFileReferenceHelper$AppEngineStaticDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

