/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.languagescope;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.clones.languagescope.common.CommonDuplicateScope;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyFileElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyDuplicateScope
extends CommonDuplicateScope {
    @NotNull
    public String getLanguageName() {
        return "Python";
    }

    public boolean isNoise(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(0);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(1);
        }
        return Lazy.NOISE.contains(node.getTokenType()) || PyDuplicateScope.isDocString(ast, node) || PyDuplicateScope.isConstructor(ast, node);
    }

    private static boolean isConstructor(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(2);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(3);
        }
        if (node.getTokenType() == PyElementTypes.FUNCTION_DECLARATION) {
            LighterASTTokenNode name = (LighterASTTokenNode)LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (IElementType)PyTokenTypes.IDENTIFIER);
            if (name == null) {
                return false;
            }
            if ("__init__".contentEquals(name.getText())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isDocString(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        LighterASTNode stringExpression;
        List expressionChildren;
        List children2;
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(4);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(5);
        }
        return node.getTokenType() == PyElementTypes.EXPRESSION_STATEMENT && !(children2 = ast.getChildren(node)).isEmpty() && !(expressionChildren = ast.getChildren(stringExpression = (LighterASTNode)children2.get(0))).isEmpty() && ((LighterASTNode)expressionChildren.get(0)).getTokenType() == PyTokenTypes.DOCSTRING;
    }

    private static boolean isMethodCall(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        LighterASTNode parent;
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(6);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(7);
        }
        if ((parent = ast.getParent((LighterASTNode)node)) == null) {
            return false;
        }
        LighterASTNode grandParent = ast.getParent(parent);
        if (grandParent == null) {
            return false;
        }
        boolean isIdentifier = node.getTokenType() == PyTokenTypes.IDENTIFIER;
        boolean hasCallGrandparent = grandParent.getTokenType() == PyElementTypes.CALL_EXPRESSION;
        return isIdentifier && hasCallGrandparent;
    }

    public boolean isAnonymized(@NotNull LighterAST ast, @NotNull LighterASTTokenNode node) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(8);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(9);
        }
        if (Lazy.LITERALS.contains(node.getTokenType())) {
            return this.getIndexConfiguration().getAnonymizeLiterals();
        }
        if (PyDuplicateScope.isMethodCall(ast, node)) {
            return this.getIndexConfiguration().getAnonymizeFunctions();
        }
        if (node.getTokenType() == PyTokenTypes.IDENTIFIER) {
            return this.getIndexConfiguration().getAnonymizeIdentifiers();
        }
        return true;
    }

    public boolean shouldAnalyzeChildSubsequences(@NotNull LighterAST ast, @NotNull LighterASTNode parent) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(10);
        }
        if (parent == null) {
            PyDuplicateScope.$$$reportNull$$$0(11);
        }
        if (Lazy.SEPARABLE_NODES.contains(parent.getTokenType())) {
            LighterASTNode grandParent = ast.getParent(parent);
            return grandParent == null || grandParent.getTokenType() != PyElementTypes.CLASS_DECLARATION;
        }
        return false;
    }

    public boolean isIgnoredAsDuplicate(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(12);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(13);
        }
        return Lazy.IGNORED_DUPLICATE_NODES.contains(node.getTokenType());
    }

    public int weightOf(@NotNull LighterAST ast, @NotNull LighterASTNode node) {
        if (ast == null) {
            PyDuplicateScope.$$$reportNull$$$0(14);
        }
        if (node == null) {
            PyDuplicateScope.$$$reportNull$$$0(15);
        }
        IElementType type = node.getTokenType();
        if (Lazy.EXPRESSIONS.contains(type)) {
            return 1;
        }
        if (Lazy.STATEMENTS.contains(type)) {
            return 2;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/languagescope/PyDuplicateScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isNoise";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCall";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnonymized";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAnalyzeChildSubsequences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredAsDuplicate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "weightOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Lazy {
        private static final TokenSet NOISE = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, PyTokenTypes.DOCSTRING, PyElementTypes.IMPORT_STATEMENT, PyElementTypes.FROM_IMPORT_STATEMENT, PyTokenTypes.END_OF_LINE_COMMENT});
        private static final TokenSet LITERALS = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.INTEGER_LITERAL, PyTokenTypes.FLOAT_LITERAL, PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.TRIPLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE, PyTokenTypes.TRIPLE_QUOTED_UNICODE, PyTokenTypes.IMAGINARY_LITERAL});
        private static final TokenSet STATEMENTS = PythonDialectsTokenSetProvider.INSTANCE.getStatementTokens();
        private static final TokenSet EXPRESSIONS = PythonDialectsTokenSetProvider.INSTANCE.getExpressionTokens();
        private static final TokenSet SEPARABLE_NODES = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.STATEMENT_LIST, PyFileElementType.INSTANCE});
        private static final TokenSet IGNORED_DUPLICATE_NODES = TokenSet.orSet((TokenSet[])new TokenSet[]{PyElementTypes.CLASS_OR_FUNCTION, PyElementTypes.PARTS, PyElementTypes.PARAMETER_LIST_SET, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.ARGUMENT_LIST})});

        private Lazy() {
        }
    }
}

