/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cython.CythonNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NotNull;

public class CythonBuiltinAnnotator
extends PyRecursiveElementVisitor
implements Annotator {
    private final TokenSet IDENTIFIERS_FILTER = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IDENTIFIER});
    private AnnotationHolder myHolder;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            CythonBuiltinAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CythonBuiltinAnnotator.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        try {
            element.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitPyElement(PyElement element) {
        String name;
        if (!(!(element instanceof PyReferenceExpression) && !(element instanceof PyTargetExpression) || CythonNames.BASE_C_TYPES.contains((Object)(name = element.getName())) || CythonNames.BASE_CYTHON_TYPES.contains((Object)name) || CythonNames.BUILTINS.contains((Object)name))) {
            super.visitPyElement(element);
            return;
        }
        ASTNode node = element.getNode();
        if (node.getElementType() == PyTokenTypes.IDENTIFIER) {
            this.annotateBuiltinIdentifier(node);
        }
        for (ASTNode child : node.getChildren(this.IDENTIFIERS_FILTER)) {
            this.annotateBuiltinIdentifier(child);
        }
        super.visitPyElement(element);
    }

    private void annotateBuiltinIdentifier(ASTNode node) {
        String text2 = node.getText();
        if (CythonNames.BASE_C_TYPES.contains((Object)text2) || CythonNames.BASE_CYTHON_TYPES.contains((Object)text2) || CythonNames.BASE_TYPE_MODIFIERS.contains((Object)text2) || CythonNames.VISIBILITY_MODIFIERS.contains((Object)text2) || CythonNames.CALLING_CONVENTIONS.contains((Object)text2) || CythonNames.NON_RESERVED_KEYWORDS.contains((Object)text2) || CythonNames.BUILTINS.contains((Object)text2)) {
            this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(node).textAttributes(PyHighlighter.PY_BUILTIN_NAME).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cython/CythonBuiltinAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

