/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cython.CythonNames;
import com.jetbrains.cython.parser.CythonTokenTypes;
import com.jetbrains.cython.psi.CythonCdefBlock;
import com.jetbrains.cython.psi.CythonClass;
import com.jetbrains.cython.psi.CythonEnum;
import com.jetbrains.cython.psi.CythonFile;
import com.jetbrains.cython.psi.CythonFusedType;
import com.jetbrains.cython.psi.CythonNameDecl;
import com.jetbrains.cython.psi.CythonStructOrUnion;
import com.jetbrains.python.codeInsight.completion.PyKeywordCompletionContributor;
import com.jetbrains.python.codeInsight.completion.PythonLookupElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithStatement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CythonKeywordCompletionContributor
extends CompletionContributor {
    private static final ElementPattern IN_CYTHON_FILE = PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiElement(CythonFile.class));
    private static final TokenSet CDEF_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{CythonTokenTypes.CDEF_KEYWORD, CythonTokenTypes.CPDEF_KEYWORD});

    public CythonKeywordCompletionContributor() {
        this.addToplevelImports();
        this.addToplevelTypedef();
        this.addCdefs();
        this.addMacros();
        this.addKeywordsAfterCdef();
        this.addKeywordsInsideNameDecl();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            CythonKeywordCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            CythonKeywordCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
    }

    private void addToplevelImports() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).andNot(CythonKeywordCompletionContributor.inCompoundStatements(new Class[0]))).and((ElementPattern)PyKeywordCompletionContributor.FIRST_ON_LINE), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("cimport", "include")}));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and(PyKeywordCompletionContributor.IN_FROM_IMPORT_AFTER_REF)).andNot(PyKeywordCompletionContributor.AFTER_QUALIFIER), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("cimport")}));
    }

    private void addToplevelTypedef() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).andNot(CythonKeywordCompletionContributor.inCompoundStatements(new Class[0]))).and((ElementPattern)PyKeywordCompletionContributor.FIRST_ON_LINE), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("ctypedef")}));
    }

    private void addCdefs() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and(StandardPatterns.or((ElementPattern[])new ElementPattern[]{CythonKeywordCompletionContributor.inCompoundStatements(PyFunction.class, CythonClass.class), StandardPatterns.not(CythonKeywordCompletionContributor.inCompoundStatements(new Class[0]))}))).and((ElementPattern)PyKeywordCompletionContributor.FIRST_ON_LINE), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("cdef", "cpdef")}));
    }

    private void addMacros() {
        ObjectPattern place = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and((ElementPattern)PyKeywordCompletionContributor.FIRST_ON_LINE);
        this.extend(CompletionType.BASIC, (ElementPattern)place, CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("DEF")}));
        this.extend(CompletionType.BASIC, (ElementPattern)place, CythonKeywordCompletionContributor.variants(TailType.NONE, new Collection[]{CythonKeywordCompletionContributor.set("IF", "ELIF")}));
        this.extend(CompletionType.BASIC, (ElementPattern)place, CythonKeywordCompletionContributor.variants(TailType.CASE_COLON, new Collection[]{CythonKeywordCompletionContributor.set("ELSE")}));
    }

    private void addKeywordsAfterCdef() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and((ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)PlatformPatterns.psiElement().withElementType(CDEF_KEYWORDS))), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonNames.VISIBILITY_MODIFIERS}));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and((ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType(CDEF_KEYWORDS), CythonKeywordCompletionContributor.withText(CythonNames.VISIBILITY_MODIFIERS)}))), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("api")}));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and((ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType(CDEF_KEYWORDS), CythonKeywordCompletionContributor.withText(CythonNames.VISIBILITY_MODIFIERS), PlatformPatterns.psiElement().withText("api")}))), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("struct", "union", "enum", "packed", "class")}));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).and((ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), CythonKeywordCompletionContributor.withText(CythonKeywordCompletionContributor.set("extern")))), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonKeywordCompletionContributor.set("from")}));
    }

    private void addKeywordsInsideNameDecl() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().and(IN_CYTHON_FILE)).inside(CythonNameDecl.class), CythonKeywordCompletionContributor.variants(TailType.SPACE, new Collection[]{CythonNames.CALLING_CONVENTIONS}));
    }

    private static <T> ImmutableSet<T> set(T ... xs) {
        return ImmutableSet.copyOf((Object[])xs);
    }

    private static ElementPattern<Object> withText(final Collection<String> names) {
        return new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return element instanceof PsiElement && names.contains(((PsiElement)element).getText());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        });
    }

    private static boolean isCompoundStatement(PsiElement stmt) {
        return stmt instanceof PyIfStatement || stmt instanceof PyWhileStatement || stmt instanceof PyForStatement || stmt instanceof PyTryExceptStatement || stmt instanceof PyWithStatement || stmt instanceof PyFunction || stmt instanceof PyClass || stmt instanceof CythonStructOrUnion || stmt instanceof CythonCdefBlock || stmt instanceof CythonEnum || stmt instanceof CythonFusedType;
    }

    private static ElementPattern<Object> inCompoundStatements(final Class ... classes) {
        final boolean any = classes.length == 0;
        return new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (element instanceof PsiElement) {
                    PsiElement stmt = (PsiElement)element;
                    while (stmt != null) {
                        stmt = PsiTreeUtil.getParentOfType((PsiElement)stmt, PyStatement.class);
                        for (Class cls : classes) {
                            if (!cls.isInstance(stmt)) continue;
                            return true;
                        }
                        if (!CythonKeywordCompletionContributor.isCompoundStatement(stmt)) continue;
                        return any;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        });
    }

    private static CompletionProvider<CompletionParameters> variants(final TailType tail, final Collection<String> ... wordGroups) {
        return new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    3.$$$reportNull$$$0(2);
                }
                for (Collection group2 : wordGroups) {
                    CythonKeywordCompletionContributor.putKeywords(result, tail, group2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cython/CythonKeywordCompletionContributor$3";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void putKeywords(CompletionResultSet result, TailType tail, Collection<String> words) {
        for (String s : words) {
            result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)new PythonLookupElement(s, true, null), (TailType)tail));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cython/CythonKeywordCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

