/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cython.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cython.CythonResolveUtil;
import com.jetbrains.cython.psi.CythonIncludeStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonIncludeReference
implements PsiReference {
    private final CythonIncludeStatement myElement;

    public CythonIncludeReference(@NotNull CythonIncludeStatement element) {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @NotNull
    public PsiElement getElement() {
        CythonIncludeStatement cythonIncludeStatement = this.myElement;
        if (cythonIncludeStatement == null) {
            CythonIncludeReference.$$$reportNull$$$0(1);
        }
        return cythonIncludeStatement;
    }

    @Nullable
    public PsiElement resolve() {
        PyStringLiteralExpression arg = this.myElement.getArgument();
        if (arg != null) {
            String filename = arg.getStringValue();
            VirtualFile includedFile = CythonResolveUtil.findFile(CythonResolveUtil.getIncludePath((PsiElement)this.myElement, true), filename);
            if (includedFile != null) {
                return CythonResolveUtil.toCythonFile(this.myElement.getProject(), includedFile);
            }
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        PyStringLiteralExpression arg = this.myElement.getArgument();
        return arg != null ? arg.getStringValue() : "";
    }

    @NotNull
    public TextRange getRangeInElement() {
        List<TextRange> ranges;
        PyStringLiteralExpression arg = this.myElement.getArgument();
        if (arg != null && (ranges = arg.getStringValueTextRanges()).size() > 0) {
            Iterator<TextRange> iterator = ranges.iterator();
            TextRange result = iterator.next();
            while (iterator.hasNext()) {
                result = result.union(iterator.next());
            }
            TextRange textRange = result.shiftRight(arg.getStartOffsetInParent());
            if (textRange == null) {
                CythonIncludeReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = TextRange.EMPTY_RANGE;
        if (textRange == null) {
            CythonIncludeReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PyStringLiteralExpression arg;
        if (newElementName == null) {
            CythonIncludeReference.$$$reportNull$$$0(4);
        }
        if ((arg = this.myElement.getArgument()) != null) {
            ElementManipulators.handleContentChange((PsiElement)arg, (String)newElementName);
        }
        return this.myElement;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(5);
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CythonIncludeReference.$$$reportNull$$$0(6);
        }
        if (element instanceof PyFile) {
            return this.resolve() == element;
        }
        return false;
    }

    public boolean isSoft() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CythonIncludeReference) {
            CythonIncludeReference other = (CythonIncludeReference)o;
            return this.myElement.equals(other.getElement());
        }
        return false;
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cython/psi/CythonIncludeReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cython/psi/CythonIncludeReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

