/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight.djangoForms;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.djangoForms.DjangoFormsCompletionProviderKt;
import com.jetbrains.django.model.DjangoMeta;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/django/codeInsight/djangoForms/DjangoFormsCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python"})
public final class DjangoFormsCompletionProvider
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parameters.position");
        PsiElement position = psiElement;
        ASTNode aSTNode = position.getNode();
        if (aSTNode == null) {
            return;
        }
        ASTNode node = aSTNode;
        TypeEvalContext context = TypeEvalContext.userInitiated(position.getProject(), position.getContainingFile());
        boolean elementIsId = Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)PyTokenTypes.IDENTIFIER));
        boolean elementIsString = Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)PyTokenTypes.SINGLE_QUOTED_STRING));
        if (!elementIsId && !elementIsString) {
            return;
        }
        PsiQuery<PyClass> psiQuery = new PsiQuery<PsiElement>(position).ancestors(PyClass.class).ancestors(PyStatementList.class).ancestors(PyClass.class);
        Intrinsics.checkExpressionValueIsNotNull(psiQuery, (String)"PsiQuery(position)\n     \u2026tors(PyClass::class.java)");
        PyClass pyClass = psiQuery.getFirstElement();
        if (pyClass == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pyClass, (String)"PsiQuery(position)\n     \u2026  .firstElement ?: return");
        PyClass formClass = pyClass;
        if (!NameResolverTools.isSubclass(formClass, DjangoFQNamesProvider.MODEL_FORM_CLASS, context)) {
            return;
        }
        DjangoMeta meta = DjangoMeta.fromAnyClass(formClass);
        PsiElement positionParent = position.getParent();
        if (meta == null && positionParent instanceof PyClass) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"Meta").withIcon(AllIcons.Nodes.Class));
        }
        if (meta != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)meta.getMetaClass()), (PsiElement)position, (boolean)true)) {
            if (elementIsId) {
                for (String field : DjangoFormsCompletionProviderKt.access$getMETA_FIELDS$p()) {
                    if (meta.getMetaClass().findClassAttribute(field, false, context) != null) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)field).withIcon(AllIcons.Nodes.Field));
                }
            } else {
                PsiQuery<PyAssignmentStatement> psiQuery2 = new PsiQuery<PsiElement>(position).ancestors(PyStringLiteralExpression.class).ancestors(PyAssignmentStatement.class);
                Intrinsics.checkExpressionValueIsNotNull(psiQuery2, (String)"PsiQuery(position).ances\u2026entStatement::class.java)");
                PyAssignmentStatement pyAssignmentStatement = psiQuery2.getFirstElement();
                if (pyAssignmentStatement == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyAssignmentStatement, (String)"PsiQuery(position).ances\u2026  .firstElement ?: return");
                PyAssignmentStatement assignmentStatement = pyAssignmentStatement;
                PyExpression pyExpression = assignmentStatement.getLeftHandSideExpression();
                if (pyExpression == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"assignmentStatement.left\u2026dSideExpression ?: return");
                PyExpression sideExpression = pyExpression;
                if (!(assignmentStatement.getAssignedValue() instanceof PyStringLiteralExpression)) {
                    return;
                }
                String fieldName = sideExpression.getName();
                if (Intrinsics.areEqual((Object)"fields", (Object)fieldName) || Intrinsics.areEqual((Object)"localized_fields", (Object)fieldName)) {
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)"__all__");
                    Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder, (String)"LookupElementBuilder.create(PyNames.ALL)");
                    LookupElementBuilder builder = lookupElementBuilder;
                    result.addElement(builder.withBoldness(true).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE));
                }
            }
        }
    }
}

