/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.extension;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.refactoring.RenameDjangoParameterProcessor;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.magicLiteral.PyMagicLiteralExtensionPoint;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public final class PyDjangoContextParamMagicLiteralExtensionPoint
implements PyMagicLiteralExtensionPoint {
    @Override
    public boolean isEnabled(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyDjangoContextParamMagicLiteralExtensionPoint.$$$reportNull$$$0(0);
        }
        return DjangoFacet.isPresent(anchor);
    }

    @Override
    public boolean isMagicLiteral(@NotNull StringLiteralExpression element) {
        if (element == null) {
            PyDjangoContextParamMagicLiteralExtensionPoint.$$$reportNull$$$0(1);
        }
        if (!element.getContainingFile().getFileType().equals((Object)PythonFileType.INSTANCE)) {
            return false;
        }
        if (RenameDjangoParameterProcessor.isDjangoTemplateParameter(element)) {
            return true;
        }
        Module djangoModule = DjangoUtil.getDjangoModule(element.getProject());
        if (djangoModule == null) {
            return false;
        }
        DjangoTemplateManager templateManager = DjangoTemplateManager.getInstance(djangoModule);
        for (PsiFile template : templateManager.getAllTemplates()) {
            for (LookupElement lookupElement : TemplateParametersEvaluator.getTemplateContext(template)) {
                if (!element.equals(lookupElement.getPsiElement())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getLiteralType() {
        String string = DjangoBundle.message("magic_literals.django_template_context_param", new Object[0]);
        if (string == null) {
            PyDjangoContextParamMagicLiteralExtensionPoint.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/extension/PyDjangoContextParamMagicLiteralExtensionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/extension/PyDjangoContextParamMagicLiteralExtensionPoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMagicLiteral";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

