/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.formatter;

import com.google.common.collect.Lists;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlockerExtension;
import com.intellij.psi.impl.source.html.HtmlScriptLanguageInjector;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.django.lang.template.DjangoTemplateFileViewProvider;
import com.jetbrains.django.lang.template.formatter.DjangoCompositeBlock;
import com.jetbrains.django.lang.template.formatter.DjangoTemplateBlock;
import com.jetbrains.django.lang.template.formatter.DjangoTemplateBlockTreeFormatter;
import com.jetbrains.django.lang.template.formatter.DjangoXmlBlock;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.DjangoTemplatePsiUtil;
import com.jetbrains.django.lang.template.psi.impl.DjangoTemplateFileImpl;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder
implements FormattingModelBuilderEx {
    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, CodeStyleSettings settings) {
        PsiFile psiFile;
        if (element == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if ((psiFile = element.getContainingFile()).getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider vProvider = (TemplateLanguageFileViewProvider)psiFile.getViewProvider();
            if (element instanceof DjangoTemplateFileImpl) {
                Language templateDataLanguage = vProvider.getTemplateDataLanguage();
                Language baseLanguage = vProvider.getBaseLanguage();
                if (templateDataLanguage instanceof XMLLanguage) {
                    FormattingModel formattingModel = DjangoTemplateFormattingModelBuilder.createXmlFormattingModel((PsiElement)vProvider.getPsi(templateDataLanguage), (PsiElement)vProvider.getPsi(baseLanguage), settings, psiFile);
                    if (formattingModel == null) {
                        DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(1);
                    }
                    return formattingModel;
                }
                if (templateDataLanguage.getID().equals("JavaScript")) {
                    FormattingModel formattingModel = DjangoTemplateFormattingModelBuilder.createJavascriptFormattingModel((PsiElement)vProvider.getPsi(templateDataLanguage), (PsiElement)vProvider.getPsi(baseLanguage), settings, psiFile, templateDataLanguage);
                    if (formattingModel == null) {
                        DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(2);
                    }
                    return formattingModel;
                }
                FormattingModel formattingModel = this.createBaseLanguageFormattingModel(templateDataLanguage, (PsiElement)vProvider.getPsi(templateDataLanguage), settings);
                if (formattingModel == null) {
                    DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(3);
                }
                return formattingModel;
            }
            if (element instanceof OuterLanguageElement && element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_INJECTION_IN_HTML) {
                List<PsiElement> list = DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElement(element, vProvider);
                return DjangoTemplateFormattingModelBuilder.createDjangoFormattingModel(element, list, settings, psiFile);
            }
        }
        FormattingModel formattingModel = super.createModel(element, settings);
        if (formattingModel == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        return formattingModel;
    }

    private FormattingModel createBaseLanguageFormattingModel(Language language, PsiElement element, CodeStyleSettings settings) {
        FormattingModelBuilder modelBuilder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(language);
        if (modelBuilder != null && !(modelBuilder instanceof SimpleTemplateLanguageFormattingModelBuilder)) {
            return modelBuilder.createModel(element, settings);
        }
        return super.createModel(element, settings);
    }

    private static FormattingModel createXmlFormattingModel(PsiElement templateElement, PsiElement djangoPsiRoot, CodeStyleSettings settings, PsiFile psiFile) {
        assert (templateElement.getNode() != null);
        assert (psiFile != null);
        XmlFormattingPolicy policy = DjangoTemplateFormattingModelBuilder.getPolicy(settings, psiFile);
        DjangoXmlBlock block = new DjangoXmlBlock(templateElement.getNode(), null, Alignment.createAlignment(), policy, Indent.getNoneIndent(), templateElement.getTextRange());
        DjangoTemplateBlockTreeFormatter formatter = new DjangoTemplateBlockTreeFormatter();
        Block djangoBlock = formatter.reformat(policy, (Block)block, djangoPsiRoot);
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)psiFile, (Block)djangoBlock, (CodeStyleSettings)settings);
    }

    private static FormattingModel createJavascriptFormattingModel(PsiElement templateElement, PsiElement djangoPsiRoot, CodeStyleSettings settings, PsiFile psiFile, Language javascript) {
        FormattingModelBuilder modelBuilder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(javascript);
        if (modelBuilder != null) {
            return modelBuilder.createModel(templateElement, settings);
        }
        return DjangoTemplateFormattingModelBuilder.createXmlFormattingModel(templateElement, djangoPsiRoot, settings, psiFile);
    }

    @NotNull
    private static FormattingModel createDjangoFormattingModel(PsiElement elementInTemplate, @NotNull List<PsiElement> elements, @NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        DjangoCompositeBlock block;
        if (elements == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        XmlFormattingPolicy policy = DjangoTemplateFormattingModelBuilder.getPolicy(settings, psiFile);
        ArrayList blocks = Lists.newArrayList();
        for (PsiElement element : elements) {
            assert (element.getNode() != null);
            if (element instanceof PsiErrorElement || element instanceof PsiWhiteSpace) continue;
            DjangoTemplateBlock block2 = new DjangoTemplateBlock(element.getNode(), DjangoTemplateFormattingModelBuilder.selectWrap(elementInTemplate), null, policy);
            blocks.add(block2);
        }
        if (blocks.size() > 1) {
            block = new DjangoCompositeBlock(blocks);
        } else if (blocks.size() > 0) {
            block = (Block)blocks.get(0);
        } else {
            throw new IllegalStateException("Block list cant be empty!");
        }
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)psiFile, (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        return formattingModel;
    }

    private static Wrap selectWrap(PsiElement elementInTemplate) {
        Wrap wrap = DjangoTemplateFormattingModelBuilder.isInAttribute(elementInTemplate) ? Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false) : null;
        return wrap;
    }

    public static boolean isInAttribute(PsiElement elementInTemplate) {
        return PsiTreeUtil.getParentOfType((PsiElement)elementInTemplate, XmlAttribute.class) != null;
    }

    private static XmlFormattingPolicy getPolicy(CodeStyleSettings settings, PsiFile psiFile) {
        FormattingDocumentModelImpl documentModel;
        if (psiFile.getViewProvider() instanceof DjangoTemplateFileViewProvider) {
            DjangoTemplateFileViewProvider viewProvider = (DjangoTemplateFileViewProvider)psiFile.getViewProvider();
            Language language = viewProvider.getTemplateDataLanguage();
            documentModel = FormattingDocumentModelImpl.createOn((PsiFile)viewProvider.getPsi(language));
            if (language == XMLLanguage.INSTANCE) {
                return new XmlPolicy(settings, (FormattingDocumentModel)documentModel);
            }
        } else {
            documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        }
        return new HtmlPolicy(settings, (FormattingDocumentModel)documentModel){

            public boolean isTextElement(XmlTag tag) {
                return super.isTextElement(tag) || DjangoTemplateFormattingModelBuilder.isProtectedFromInjection(tag);
            }
        };
    }

    private static boolean isProtectedFromInjection(@NotNull XmlTag tag) {
        Language language;
        if (tag == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        return (language = HtmlScriptLanguageInjector.getScriptLanguageToInject((XmlTag)tag)) != null && HtmlScriptInjectionBlockerExtension.isInjectionBlocked((XmlTag)tag, (Language)language);
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(12);
        }
        FormattingModel formattingModel = this.createModel(element, settings);
        if (formattingModel == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(13);
        }
        return formattingModel;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file2 == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(14);
        }
        if (ranges == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(16);
        }
        return DjangoTemplateFormattingModelBuilder.getIndentOptions(file2, settings);
    }

    @Nullable
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file2, @NotNull CodeStyleSettings settings) {
        Language language;
        if (file2 == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(17);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(18);
        }
        return (language = PyTemplatesUtil.getTemplateDataLanguage((PsiElement)file2, DjangoTemplateFileViewProvider.class)) != null ? settings.getIndentOptions((FileType)language.getAssociatedFileType()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/formatter/DjangoTemplateFormattingModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/formatter/DjangoTemplateFormattingModelBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDjangoFormattingModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDjangoFormattingModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isProtectedFromInjection";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsToUse";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

