/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.tags;

import com.intellij.lang.PsiBuilder;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTagParser;
import com.jetbrains.django.lang.template.parsing.parser.DjangoTemplateParsing;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.Nullable;

public class DjangoBlockTagParser<T extends DjangoTemplateParsing>
extends DjangoTagParser<T> {
    private final String myAcceptSuffix;

    public DjangoBlockTagParser(@Nullable String acceptSuffix) {
        this.myAcceptSuffix = acceptSuffix;
    }

    @Override
    public void parse(PsiBuilder builder, PsiBuilder.Marker tagStartMarker, T templateParser) {
        if (!DjangoBlockTagParser.parseName(builder)) {
            builder.error(DjangoBundle.message("django.parse.error.block.identifier.expected", new Object[0]));
        }
        if (this.myAcceptSuffix != null && ((DjangoTemplateParsing)templateParser).hasTokenText(this.myAcceptSuffix)) {
            builder.advanceLexer();
        }
        tagStartMarker.done(DjangoTemplateElementTypes.BLOCK_TAG);
    }

    protected static boolean parseName(PsiBuilder builder) {
        PsiBuilder.Marker blockName = builder.mark();
        if (builder.getTokenType() != DjangoTemplateTokenTypes.ID) {
            blockName.drop();
            return false;
        }
        builder.advanceLexer();
        while (builder.getTokenType() == DjangoTemplateTokenTypes.DOT) {
            builder.advanceLexer();
            if (builder.getTokenType() != DjangoTemplateTokenTypes.ID) {
                builder.error(DjangoBundle.message("django.parse.error.identifier.expected.after", new Object[0]));
                break;
            }
            builder.advanceLexer();
        }
        blockName.done(DjangoTemplateElementTypes.BLOCK_NAME);
        return true;
    }
}

