/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.openapi.module.Module;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.NoArgumentsInfo;
import com.jetbrains.commandInterface.command.SimpleCommand;
import com.jetbrains.django.manage.DjangoConsoleExecutor;
import com.jetbrains.django.manage.FailedToProvideCommandsException;
import com.jetbrains.django.manage.RealCommandsProvider;
import com.jetbrains.django.manage.SpecialCaseCommandsProvider;
import com.jetbrains.django.manage.SpecialCaseInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class DjangoManageCommandsApi {
    private static final SimpleCommand[] SPECIAL_COMMANDS = new SimpleCommand[]{new SimpleCommand("version", new Help("Show Django version"), NoArgumentsInfo.INSTANCE, DjangoConsoleExecutor.INSTANCE, Collections.emptyList())};

    private DjangoManageCommandsApi() {
    }

    @NotNull
    public static Collection<SimpleCommand> getCommands(@NotNull Module module, @NotNull Consumer<String> errorStream) throws FailedToProvideCommandsException {
        if (module == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(0);
        }
        if (errorStream == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(1);
        }
        Collection collection = Stream.concat(Collections2.transform(RealCommandsProvider.getCommands(module, errorStream), (Function)new CommandsTransformer(new SpecialCaseCommandsProvider(module))).stream(), Arrays.stream(SPECIAL_COMMANDS)).collect(Collectors.toList());
        if (collection == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static CommandExecutor getDefaultExecutor() {
        CommandExecutor commandExecutor = DjangoConsoleExecutor.INSTANCE;
        if (commandExecutor == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(3);
        }
        return commandExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/manage/DjangoManageCommandsApi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/manage/DjangoManageCommandsApi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommands";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommands";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CommandsTransformer
    implements Function<SimpleCommand, SimpleCommand> {
        @NotNull
        private final SpecialCaseCommandsProvider myProvider;

        CommandsTransformer(@NotNull SpecialCaseCommandsProvider provider) {
            if (provider == null) {
                CommandsTransformer.$$$reportNull$$$0(0);
            }
            this.myProvider = provider;
        }

        public SimpleCommand apply(SimpleCommand input) {
            SpecialCaseInfo specialCaseInfo = this.myProvider.getSpecialCaseInfo(input.getName());
            if (specialCaseInfo != null) {
                return specialCaseInfo.apply(input);
            }
            return input;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/jetbrains/django/manage/DjangoManageCommandsApi$CommandsTransformer", "<init>"));
        }
    }
}

