/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.manage;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.jetbrains.commandInterface.command.ArgumentsInfo;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.command.Help;
import com.jetbrains.commandInterface.command.Option;
import com.jetbrains.commandInterface.command.SimpleCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpecialCaseInfo {
    @Nullable
    private final CommandExecutor myExecutor;
    @Nullable
    private final String myCommandExternalHelpUrl;
    @Nullable
    private final ArgumentsInfo myArgumentsInfo;
    @NotNull
    private final Map<String, String> myOptionsExternalUrl = new HashMap<String, String>();

    SpecialCaseInfo(@Nullable CommandExecutor executor, @Nullable String commandExternalHelpUrl, @Nullable ArgumentsInfo argumentsInfo, @Nullable Map<String, String> optionsExternalUrl) {
        this.myExecutor = executor;
        this.myCommandExternalHelpUrl = commandExternalHelpUrl;
        this.myArgumentsInfo = argumentsInfo;
        if (optionsExternalUrl != null) {
            this.myOptionsExternalUrl.putAll(optionsExternalUrl);
        }
    }

    @NotNull
    SimpleCommand apply(@NotNull SimpleCommand command) {
        Help originalHelp;
        if (command == null) {
            SpecialCaseInfo.$$$reportNull$$$0(0);
        }
        CommandExecutor commandExecutor = this.myExecutor != null ? this.myExecutor : command.getExecutor();
        ArgumentsInfo argumentsInfo = this.myArgumentsInfo != null ? this.myArgumentsInfo : command.getArgumentsInfo();
        Collection options = Collections2.transform(command.getOptions(), (Function)new OptionReplacer());
        Help newCommandHelp = originalHelp = command.getHelp(false);
        if (this.myCommandExternalHelpUrl != null) {
            newCommandHelp = new Help(originalHelp != null ? originalHelp.getHelpString() : "Check external url", this.myCommandExternalHelpUrl);
        }
        return new SimpleCommand(command.getName(), newCommandHelp, argumentsInfo, commandExecutor, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/jetbrains/django/manage/SpecialCaseInfo", "apply"));
    }

    private class OptionReplacer
    implements Function<Option, Option> {
        private OptionReplacer() {
        }

        @Nullable
        public Option apply(@Nullable Option input) {
            if (input == null) {
                return null;
            }
            for (String optionName : input.getAllNames()) {
                String newHelpUrl = (String)SpecialCaseInfo.this.myOptionsExternalUrl.get(optionName);
                if (newHelpUrl == null) continue;
                Help newHelp = new Help(input.getHelp().getHelpString(), newHelpUrl);
                return new Option(input.getArgumentAndQuantity(), newHelp, input.getShortNames(), input.getLongNames());
            }
            return input;
        }
    }
}

