/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.ref.DjangoViewItemReference;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewMethodReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        PyExpression[] arguments;
        PyArgumentList argumentList;
        String prefix;
        if (psiElement == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(0);
        }
        if (processingContext == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!DjangoFacet.isPresent(psiElement)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (ViewMethodReferenceProvider.isPrefixElement(psiElement) && !StringUtil.isEmpty((String)(prefix = PyStringLiteralUtil.getStringValue(psiElement)))) {
            ArrayList result = Lists.newArrayList();
            List<PsiReference> references2 = ViewMethodReferenceProvider.getViewFSItemReferences(psiElement);
            result.addAll(ViewMethodReferenceProvider.removeFunctionReference(references2));
            PsiReference[] res = new PsiReference[result.size()];
            PsiReference[] psiReferenceArray = result.toArray(res);
            if (psiReferenceArray == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        PyCallExpression call = DjangoPsiUtil.getUrlCall(psiElement);
        if (call != null && (argumentList = call.getArgumentList()) != null && (arguments = argumentList.getArguments()).length >= 2) {
            if (ViewMethodReferenceProvider.isViewArgument(psiElement, call) && psiElement instanceof PyStringLiteralExpression) {
                List<PsiReference> refs = ViewMethodReferenceProvider.getViewFSItemReferences(psiElement);
                PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    ViewMethodReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            List<PsiReference> refs = ViewMethodReferenceProvider.getIncludeUrlsReference(psiElement, arguments[1]);
            PsiReference[] res = new PsiReference[refs.size()];
            PsiReference[] psiReferenceArray = refs.toArray(res);
            if (psiReferenceArray == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        call = DjangoPsiUtil.getIncludeCall(psiElement);
        if (call != null && call.getArgument(0, PyExpression.class) == psiElement) {
            List<PsiReference> refs = ViewMethodReferenceProvider.getIncludeUrlsReference(psiElement, call);
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }
        PyTupleExpression tuple = DjangoPsiUtil.getTuple(psiElement);
        if (tuple != null) {
            List<PsiReference> result = ViewMethodReferenceProvider.getReferencesForTuple(psiElement, tuple);
            PsiReference[] ar = new PsiReference[result.size()];
            PsiReference[] psiReferenceArray = result.toArray(ar);
            if (psiReferenceArray == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(7);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(8);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isViewArgument(PsiElement psiElement, PyCallExpression call) {
        if (call == null) {
            return false;
        }
        return psiElement == call.getArgument(1, "view", PsiElement.class);
    }

    @NotNull
    public static String getFullPath(PyStringLiteralExpression str) {
        return ViewMethodReferenceProvider.withPrefix(str.getStringValue(), ViewMethodReferenceProvider.getPrefix(str));
    }

    @Nullable
    public static String getPrefix(PsiElement element) {
        return ViewMethodReferenceProvider.getPrefixText(ViewMethodReferenceProvider.getPatternsPrefixElement(element));
    }

    private static List<PsiReference> removeFunctionReference(List<PsiReference> references2) {
        for (int i = 0; i < references2.size(); ++i) {
            if (!(references2.get(i).resolve() instanceof PyFile)) continue;
            references2 = references2.subList(0, i + 1);
            break;
        }
        return references2;
    }

    @NotNull
    private static List<PsiReference> getReferencesForTuple(PsiElement psiElement, PyTupleExpression tuple) {
        if (ViewMethodReferenceProvider.isInUrlPatternsAssignment((PsiElement)tuple) && ViewMethodReferenceProvider.isSecondArgumentOfTuple(psiElement, tuple)) {
            return ViewMethodReferenceProvider.getUrlPatternsReferences(psiElement, tuple);
        }
        List<PsiReference> list = Collections.emptyList();
        if (list == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isSecondArgumentOfTuple(PsiElement psiElement, PyTupleExpression tuple) {
        PyExpression[] elements = tuple.getElements();
        return elements.length > 1 && psiElement == elements[1];
    }

    public static boolean isInUrlPatternsAssignment(PsiElement element) {
        PyExpression[] targets;
        PyAssignmentStatement statement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
        if (statement != null && (targets = statement.getTargets()).length == 1 && targets[0].getText().equals("urlpatterns")) {
            return true;
        }
        PyAugAssignmentStatement augAssignmentStatement = (PyAugAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAugAssignmentStatement.class);
        return augAssignmentStatement != null && augAssignmentStatement.getTarget().getText().equals("urlpatterns");
    }

    @NotNull
    private static List<PsiReference> getUrlPatternsReferences(PsiElement psiElement, PyTupleExpression tuple) {
        ArrayList result = Lists.newArrayList();
        PyExpression[] elements = tuple.getElements();
        if (elements.length >= 2) {
            if (psiElement.equals(elements[1])) {
                result.addAll(ViewMethodReferenceProvider.getViewFSItemReferences(psiElement));
            } else {
                result.addAll(ViewMethodReferenceProvider.getIncludeUrlsReference(psiElement, elements[1]));
                if (psiElement instanceof PyStringLiteralExpression) {
                    result.addAll(ViewMethodReferenceProvider.getViewFSItemReferences(psiElement));
                }
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiReference> getViewFSItemReferences(@NotNull PsiElement element) {
        if (element == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(11);
        }
        PyStringLiteralExpression prefixElement = ViewMethodReferenceProvider.getPatternsPrefixElement(element);
        String prefix = ViewMethodReferenceProvider.getPatternsPrefix(prefixElement);
        DjangoItemReferenceSet referenceSet = new DjangoItemReferenceSet(element, DjangoItemFilter.FUNCTIONS){

            @Override
            protected DjangoItemReference createDjangoReference(TextRange range, int index, String subreferenceText, boolean isLast) {
                if (isLast) {
                    return new DjangoViewItemReference(this, range, index, subreferenceText);
                }
                return super.createDjangoReference(range, index, subreferenceText, isLast);
            }
        };
        referenceSet.setShouldResolveDjangoRoot(true);
        if (prefix != null && prefixElement != element) {
            referenceSet.setPrefix(prefix);
        }
        List<PsiReference> list = referenceSet.getAllReferencesAsList();
        if (list == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static List<PsiReference> getIncludeUrlsReference(PsiElement psiElement, PyExpression element) {
        PyArgumentList argumentList;
        PyCallExpression callExpression;
        ArrayList result = Lists.newArrayList();
        if (element instanceof PyCallExpression && psiElement instanceof PyStringLiteralExpression && (callExpression = (PyCallExpression)element).isCalleeText("include") && (argumentList = callExpression.getArgumentList()) != null && argumentList.getArguments().length >= 1 && argumentList.getArguments()[0].equals(psiElement)) {
            result.addAll(DjangoItemReferenceSet.createFilesReferenceSet(psiElement).getAllReferencesAsList());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private static String getPatternsPrefix(@Nullable PsiElement psiElement) {
        PyStringLiteralExpression prefixElement = ViewMethodReferenceProvider.getPatternsPrefixElement(psiElement);
        return ViewMethodReferenceProvider.getPrefixText(prefixElement);
    }

    @Nullable
    private static String getPrefixText(PyStringLiteralExpression prefixElement) {
        String prefix;
        if (prefixElement != null && !StringUtil.isEmpty((String)(prefix = PyStringLiteralUtil.getStringValue(prefixElement)))) {
            return prefix;
        }
        return null;
    }

    private static boolean isPrefixElement(PsiElement psiElement) {
        PyStringLiteralExpression prefixElement = ViewMethodReferenceProvider.getPatternsPrefixElement(psiElement);
        return prefixElement == psiElement;
    }

    @Nullable
    private static PyStringLiteralExpression getPatternsPrefixElement(@Nullable PsiElement psiElement) {
        PyExpression[] patternsArgs;
        PyKeywordArgument arg;
        PyArgumentList argList;
        PyCallExpression call = DjangoPsiUtil.getUrlCall(psiElement);
        if (call != null && (argList = call.getArgumentList()) != null && (arg = argList.getKeywordArgument("prefix")) != null && arg.getValueExpression() instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)arg.getValueExpression();
        }
        call = DjangoPsiUtil.getPatternCall(psiElement);
        if (call != null && DjangoPsiUtil.isPatternsCall(call) && (patternsArgs = call.getArguments()).length > 0 && patternsArgs[0] instanceof PyStringLiteralExpression) {
            return (PyStringLiteralExpression)patternsArgs[0];
        }
        return null;
    }

    @NotNull
    static String withPrefix(@NotNull String text2, @Nullable String prefix) {
        if (text2 == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            String string = text2;
            if (string == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (prefix.endsWith(".") || text2.startsWith(".")) {
            String string = prefix + text2;
            if (string == null) {
                ViewMethodReferenceProvider.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = prefix + "." + text2;
        if (string == null) {
            ViewMethodReferenceProvider.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/ViewMethodReferenceProvider";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/ViewMethodReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForTuple";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPatternsReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewFSItemReferences";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeUrlsReference";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "withPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getViewFSItemReferences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

