/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.run;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.PlatformUtils;
import com.jetbrains.django.DjangoRunnerUtilsKt;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.run.DjangoServerRunCommandLineState;
import com.jetbrains.django.run.DjangoServerRunConfigurationEditor;
import com.jetbrains.django.run.EditDjangoSettingsFix;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.run.AbstractServerPythonRunConfiguration;
import com.jetbrains.python.run.PyRemoteProcessStarter;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DjangoServerRunConfiguration
extends AbstractServerPythonRunConfiguration<DjangoServerRunConfiguration> {
    @NonNls
    private static final String ATTR_PORT = "port";
    @NonNls
    private static final String ATTR_HOST = "host";
    @NonNls
    private static final String ATTR_ADDITIONAL_OPTIONS = "additionalOptions";
    @NonNls
    private static final String ATTR_BROWSER_URL = "browserUrl";
    @NonNls
    private static final String RUN_TEST_SERVER = "runTestServer";
    @NonNls
    private static final String RUN_NO_RELOAD = "runNoReload";
    @NonNls
    private static final String ATTR_USE_CUSTOM_RUN_COMMAND = "useCustomRunCommand";
    @NonNls
    private static final String ATTR_CUSTOM_RUN_COMMAND = "customRunCommand";
    private Integer myPort = 8000;
    private String myHost = "";
    private String myAdditionalOptions = "";
    private String myBrowserUrl = null;
    private boolean myRunTestServer = false;
    private boolean myRunNoReload = false;
    private boolean myUseCustomRunCommand = false;
    private String myCustomRunCommand = "";

    public DjangoServerRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
        this.setUnbufferedEnv();
    }

    @Override
    public List<Module> getValidModules() {
        ArrayList result = Lists.newArrayList();
        for (Module module : super.getValidModules()) {
            if (!DjangoFacet.isPresent(module)) continue;
            result.add(module);
        }
        return result;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Module module;
        if (executor == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(1);
        }
        if ((module = this.getConfigurationModule().getModule()) == null || !DjangoFacet.isPresent(module)) {
            throw new ExecutionException("Please select Django module");
        }
        if (this.isUseCustomRunCommand() && this.getCustomRunCommand().trim().isEmpty()) {
            throw new ExecutionException("Please specify run command");
        }
        return new DjangoServerRunCommandLineState(this, env);
    }

    @Override
    protected SettingsEditor<DjangoServerRunConfiguration> createConfigurationEditor() {
        return new DjangoServerRunConfigurationEditor(this);
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        String s = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_PORT);
        this.myPort = !StringUtil.isEmpty((String)s) ? Integer.valueOf(Integer.parseInt(s)) : null;
        this.myHost = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_HOST);
        this.myAdditionalOptions = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS);
        String url = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_BROWSER_URL);
        s = JDOMExternalizerUtil.readField((Element)element, (String)RUN_TEST_SERVER);
        this.myRunTestServer = !StringUtil.isEmpty((String)s) ? Boolean.parseBoolean(s) : false;
        s = JDOMExternalizerUtil.readField((Element)element, (String)RUN_NO_RELOAD);
        this.myRunNoReload = !StringUtil.isEmpty((String)s) ? Boolean.parseBoolean(s) : false;
        this.myBrowserUrl = url != null && url.length() > 0 ? url : null;
        this.myCustomRunCommand = JDOMExternalizerUtil.readField((Element)element, (String)ATTR_CUSTOM_RUN_COMMAND);
        this.myUseCustomRunCommand = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)ATTR_USE_CUSTOM_RUN_COMMAND));
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            DjangoServerRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        if (this.myPort != null) {
            JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_PORT, (String)Integer.toString(this.myPort));
        }
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_HOST, (String)this.myHost);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_ADDITIONAL_OPTIONS, (String)this.myAdditionalOptions);
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_BROWSER_URL, (String)this.myBrowserUrl);
        JDOMExternalizerUtil.writeField((Element)element, (String)RUN_TEST_SERVER, (String)Boolean.toString(this.myRunTestServer));
        JDOMExternalizerUtil.writeField((Element)element, (String)RUN_NO_RELOAD, (String)Boolean.toString(this.myRunNoReload));
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_USE_CUSTOM_RUN_COMMAND, (String)Boolean.toString(this.myUseCustomRunCommand));
        JDOMExternalizerUtil.writeField((Element)element, (String)ATTR_CUSTOM_RUN_COMMAND, (String)this.myCustomRunCommand);
    }

    @Override
    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
        if (StringUtil.isNotEmpty((String)this.myHost) && this.myPort != null) {
            commandLine.putUserData(PyRemoteProcessStarter.WEB_SERVER_HOST_AND_PORT, (Object)HostAndPort.fromParts((String)this.myHost, (int)this.myPort));
        }
    }

    @Override
    protected void patchCommandLineForBuildout(GeneralCommandLine commandLine, String sdkHome) {
        BuildoutFacet facet;
        Module module = this.getModule();
        if (module != null && (facet = BuildoutFacet.getInstance(module)) != null) {
            facet.patchCommandLineForBuildout(commandLine);
        }
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        VirtualFile projectRoot;
        Module module = this.getConfigurationModule().getModule();
        if (module == null || !DjangoFacet.isPresent(module)) {
            DjangoRunnerUtilsKt.reportNoDjangoOnModule(this.getProject());
            return;
        }
        if (this.isUseCustomRunCommand() && this.getCustomRunCommand().trim().isEmpty()) {
            throw new RuntimeConfigurationError("Please specify run command");
        }
        if (this.getPort() != null && (this.getPort() < 0 || this.getPort() > 65535)) {
            throw new RuntimeConfigurationError("Port number is not within acceptable range (0-65535)");
        }
        String projectRootString = DjangoUtil.getProjectRoot(module);
        if (projectRootString != null && (projectRoot = VirtualFileUtil.findFile(projectRootString)) == null) {
            RuntimeConfigurationError exc = new RuntimeConfigurationError("Django project root not configured");
            if (PlatformUtils.isPyCharm()) {
                exc.setQuickFix((Runnable)new EditDjangoSettingsFix(this.getProject()));
            }
            throw exc;
        }
        if (!DjangoServerRunConfiguration.isRemoteSdkSelected(this.getInterpreterPath()) && !DjangoUtil.isDjangoAvailable(module, this.getInterpreterPath())) {
            throw new RuntimeConfigurationError("Django is not importable in this environment");
        }
    }

    public boolean isDjango13OnUnix() {
        Module module = this.getConfigurationModule().getModule();
        Sdk pythonSdk2 = PythonSdkUtil.findSdkByPath(this.getInterpreterPath());
        if (pythonSdk2 == null || module == null || !SystemInfo.isUnix) {
            return false;
        }
        Project project = module.getProject();
        List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)"django.utils.autoreload"), PyResolveImportUtil.fromSdk(project, pythonSdk2));
        PyFile file2 = !results.isEmpty() ? PyUtil.as(results.get(0), PyFile.class) : null;
        return file2 != null && file2.getText().length() == 4623;
    }

    public static boolean isRemoteSdkSelected(String sdkHome) {
        Sdk sdk = PythonSdkUtil.findSdkByPath(sdkHome);
        return PythonSdkUtil.isRemote(sdk);
    }

    public boolean isRunNoReload() {
        return this.myRunNoReload;
    }

    public void setRunNoReload(boolean runNoReload) {
        this.myRunNoReload = runNoReload;
    }

    public Integer getPort() {
        return this.myPort;
    }

    public void setPort(Integer port) {
        this.myPort = port;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    public String getAdditionalOptions() {
        return this.myAdditionalOptions;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.myAdditionalOptions = additionalOptions;
    }

    public String getBrowserUrl() {
        return this.myBrowserUrl;
    }

    public void setBrowserUrl(String browserUrl) {
        this.myBrowserUrl = browserUrl;
    }

    public boolean isRunTestServer() {
        return this.myRunTestServer;
    }

    public void setRunTestServer(boolean runTestServer) {
        this.myRunTestServer = runTestServer;
    }

    public boolean isUseCustomRunCommand() {
        return this.myUseCustomRunCommand;
    }

    public void setUseCustomRunCommand(boolean useCustomRunCommand) {
        this.myUseCustomRunCommand = useCustomRunCommand;
    }

    public String getCustomRunCommand() {
        return this.myCustomRunCommand;
    }

    public void setCustomRunCommand(String customRunCommand) {
        this.myCustomRunCommand = customRunCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/run/DjangoServerRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

