/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDataflowUtil {
    private PythonDataflowUtil() {
    }

    @Nullable
    public static Set<LookupElement> getDictionaryKeys(PyExpression expr) {
        Set<LookupElement> result;
        if (expr instanceof PyDictLiteralExpression) {
            return DjangoPythonUtil.getKeys((PyDictLiteralExpression)expr);
        }
        if (expr instanceof PyCallExpression && (result = PythonDataflowUtil.processCall((PyCallExpression)expr)) != null) {
            return result;
        }
        if (expr instanceof PyReferenceExpression) {
            return PythonDataflowUtil.processVariableReference(expr);
        }
        return Collections.emptySet();
    }

    @Nullable
    private static Set<LookupElement> processCall(PyCallExpression call) {
        String text2 = call.getCallee().getText();
        if ("locals".equals(text2)) {
            return PythonDataflowUtil.getLocals(call);
        }
        if ("dict".equals(text2)) {
            return PythonDataflowUtil.processDictConstructorCall(call);
        }
        return null;
    }

    private static Set<LookupElement> processVariableReference(PyExpression expr) {
        final String name = expr.getText();
        PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        if (func == null) {
            return null;
        }
        final HashSet result = Sets.newHashSet();
        PyRecursiveElementVisitor visitor2 = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyAssignmentStatement(PyAssignmentStatement node) {
                for (Pair<PyExpression, PyExpression> targetValue : DjangoPythonUtil.getTargetsToValuesMapping(node)) {
                    PyStringLiteralExpression key;
                    PyExpression left = (PyExpression)targetValue.getFirst();
                    if (DjangoPythonUtil.isVariable(left, name)) {
                        Set callDict;
                        PyExpression value2 = (PyExpression)targetValue.getSecond();
                        if (value2 instanceof PyDictLiteralExpression) {
                            result.addAll(DjangoPythonUtil.getKeys((PyDictLiteralExpression)value2));
                        }
                        if (!(value2 instanceof PyCallExpression) || (callDict = PythonDataflowUtil.processCall((PyCallExpression)value2)) == null) continue;
                        result.addAll(callDict);
                        continue;
                    }
                    if (!DjangoPythonUtil.isKeyAccess(left, name) || (key = DjangoPythonUtil.getKey(left)) == null) continue;
                    result.add(LookupElementBuilder.createWithSmartPointer((String)key.getStringValue(), (PsiElement)key));
                }
            }
        };
        func.accept(visitor2);
        return result;
    }

    @Nullable
    private static Set<LookupElement> processDictConstructorCall(PyCallExpression call) {
        boolean keyword = true;
        HashSet result = Sets.newHashSet();
        for (PyExpression ex : call.getArguments()) {
            if (!(ex instanceof PyKeywordArgument)) {
                keyword = false;
                break;
            }
            PyKeywordArgument kw = (PyKeywordArgument)ex;
            if (kw.getKeywordNode() == null || kw.getKeyword() == null) continue;
            result.add(LookupElementBuilder.createWithSmartPointer((String)kw.getKeyword(), (PsiElement)kw.getKeywordNode().getPsi()));
        }
        if (keyword) {
            return result;
        }
        if (call.getArguments().length == 1) {
            return PythonDataflowUtil.getDictionaryKeys(call.getArguments()[0]);
        }
        return null;
    }

    public static Set<PyCallExpression> getCalls(PyExpression expr) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
        if (call != null) {
            return Collections.singleton(call);
        }
        HashSet<PyCallExpression> result = new HashSet<PyCallExpression>();
        PyStatement stat = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyStatement.class);
        if (stat instanceof PyAssignmentStatement) {
            PyAssignmentStatement assign = (PyAssignmentStatement)stat;
            for (Pair<PyExpression, PyExpression> pair : DjangoPythonUtil.getTargetsToValuesMapping(assign)) {
                if (!((PyExpression)pair.getSecond()).equals(expr)) continue;
                CallVisitor visitor2 = new CallVisitor(stat, expr, result);
                stat.getParent().accept((PsiElementVisitor)visitor2);
            }
        }
        return result;
    }

    private static boolean isCallWithArgument(@NotNull PyCallExpression call, @NotNull PyExpression arg) {
        PyArgumentList args2;
        if (call == null) {
            PythonDataflowUtil.$$$reportNull$$$0(0);
        }
        if (arg == null) {
            PythonDataflowUtil.$$$reportNull$$$0(1);
        }
        if ((args2 = call.getArgumentList()) != null) {
            for (PyExpression callArg : args2.getArguments()) {
                QualifiedResolveResult res;
                if (callArg instanceof PyReferenceExpressionImpl && arg.equals((res = ((PyReferenceExpressionImpl)callArg).followAssignmentsChain(PyResolveContext.defaultContext())).getElement())) {
                    return true;
                }
                if (!arg.equals(callArg)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<LookupElement> getLocals(PyElement element) {
        ArrayList ret = Lists.newArrayList();
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)element);
        CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor((PsiElement)element, (Condition<PsiElement>)((Condition)psiElement -> psiElement instanceof PyTargetExpression || psiElement instanceof PyParameter), null);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyFunction.class);
        if (function != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, function, null, (PsiElement)function);
            ret.addAll(processor2.getResultList());
        }
        return Sets.newLinkedHashSet((Iterable)ret);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "arg";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/util/PythonDataflowUtil";
        objectArray[2] = "isCallWithArgument";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CallVisitor
    extends PyRecursiveElementVisitor {
        private final PyStatement myStartStatement;
        private final PyExpression myArgument;
        private boolean myStarted = false;
        private final Set<PyCallExpression> myResult;

        private CallVisitor(PyStatement startStatement, PyExpression argument, Set<PyCallExpression> result) {
            this.myStartStatement = startStatement;
            this.myArgument = argument;
            this.myResult = result;
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            if (this.myStarted && PythonDataflowUtil.isCallWithArgument(node, this.myArgument)) {
                this.myResult.add(node);
            }
            super.visitPyCallExpression(node);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            if (node.equals(this.myStartStatement)) {
                this.myStarted = true;
            }
            super.visitPyAssignmentStatement(node);
        }
    }
}

