/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.jetbrains.mako.MakoUtil;
import com.jetbrains.mako.psi.impl.MakoExpr;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.mako.psi.impl.MakoSubstitution;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MakoExprReference
extends PyReferenceImpl {
    public MakoExprReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @Override
    public Object @NotNull [] getVariants() {
        Object[] superVariants;
        MakoNamespace[] name;
        ArrayList result = Lists.newArrayList();
        HashSet<PyTargetExpression> elementsSet = new HashSet<PyTargetExpression>();
        MakoNamespace parentNamespace = (MakoNamespace)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, MakoNamespace.class);
        if (parentNamespace != null) {
            for (Map.Entry entry : MakoUtil.functionsFromNamespace(parentNamespace, "*", false, this.myElement.getProject()).entrySet()) {
                name = (String)entry.getKey();
                result.add(LookupElementBuilder.create(entry.getValue(), (String)name).withIcon(PlatformIcons.METHOD_ICON));
            }
        }
        for (PyTargetExpression target : MakoUtil.elementsFromControl((PsiElement)this.myElement)) {
            name = target.getName();
            if (name == null) continue;
            elementsSet.add(target);
            result.add(LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)target));
        }
        for (String name2 : MakoUtil.getDefaultNamespaces()) {
            result.add(LookupElementBuilder.create((String)name2));
        }
        PsiFile file2 = this.myElement.getContainingFile();
        MakoNamespace[] namespaces = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, MakoNamespace.class);
        if (namespaces != null) {
            for (MakoNamespace namespace : namespaces) {
                String name3 = namespace.getName();
                if (name3 == null) continue;
                result.add(LookupElementBuilder.create((String)name3));
            }
        }
        for (Object variant : superVariants = super.getVariants()) {
            if (!(variant instanceof LookupElementBuilder) || elementsSet.contains(((LookupElementBuilder)variant).getPsiElement())) continue;
            result.add(variant);
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            MakoExprReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        List<ResolveResult> result = MakoUtil.resolveFunctionCall((PsiElement)this.myElement);
        if (this.myElement.getParent() instanceof MakoExpr || this.myElement.getParent() instanceof MakoSubstitution) {
            result.addAll(this.resolveNamespace());
        }
        if (!result.isEmpty()) {
            ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                MakoExprReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = super.multiResolve(incompleteCode);
        if (resolveResultArray == null) {
            MakoExprReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    private Collection<? extends ResolveResult> resolveNamespace() {
        ArrayList<PsiElementResolveResult> result = new ArrayList<PsiElementResolveResult>();
        PsiFile file2 = this.myElement.getContainingFile();
        MakoNamespace[] namespaces = (MakoNamespace[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, MakoNamespace.class);
        if (namespaces != null) {
            for (MakoNamespace namespace : namespaces) {
                String refName = this.myElement.getReferencedName();
                if (refName == null || !refName.equals(namespace.getName())) continue;
                result.add(new PsiElementResolveResult((PsiElement)namespace));
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/mako/ref/MakoExprReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

