/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.annotator;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.pyramid.project.PyramidUtils;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyramidViewLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            PyramidViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PyramidViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        PyramidViewLineMarkerProvider.collectLineMarkersForElement(result, element);
    }

    public static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement element) {
        if (!(element instanceof PyFunction)) {
            return;
        }
        if (!PyramidUtils.isPyramidProject(element)) {
            return;
        }
        PyFunction function = (PyFunction)element;
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList == null) {
            return;
        }
        for (PyDecorator decorator : decoratorList.getDecorators()) {
            QualifiedName qualifiedName = decorator.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.matches(new String[]{"view_config"}) && !qualifiedName.matches(new String[]{"view", "view_config"})) continue;
            PyStringLiteralExpression argument = decorator.getArgument(1, "renderer", PyStringLiteralExpression.class);
            if (argument == null) {
                return;
            }
            Project project = element.getProject();
            String filePath = argument.getStringValue();
            VirtualFile virtualFile2 = project.getBaseDir().findFileByRelativePath(project.getName() + File.separator + filePath);
            if (virtualFile2 == null) {
                VirtualFile folder;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                List<VirtualFile> folders = TemplatesService.getInstance(module).getTemplateFolders();
                Iterator<VirtualFile> iterator = folders.iterator();
                while (iterator.hasNext() && (virtualFile2 = (folder = iterator.next()).findFileByRelativePath(filePath)) == null) {
                }
            }
            if (virtualFile2 == null) {
                return;
            }
            PsiFile file2 = PsiManager.getInstance((Project)project).findFile(virtualFile2);
            if (file2 == null) {
                return;
            }
            String msg = "Goto template";
            PsiElement identifier = function.getNameIdentifier();
            if (identifier == null) continue;
            RelatedItemLineMarkerInfo info = new RelatedItemLineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.FileTypes.Html, 11, (Function)new ConstantFunction((Object)"Goto template"), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler((Collection)Lists.newArrayList((Object[])new PsiFile[]{file2}), "Goto template"), GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems((Collection)Lists.newArrayList((Object[])new PsiFile[]{file2}), (String)"Views"));
            result.add((RelatedItemLineMarkerInfo)info);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/pyramid/annotator/PyramidViewLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

