/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.templates.completion;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.pyramid.templates.file.ChameleonFileViewProvider;
import com.jetbrains.pyramid.templates.lexer.ChameleonTokenTypes;
import com.jetbrains.pyramid.templates.psi.ChameleonAttribute;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChameleonNamespaceCompletionContributor
extends CompletionContributor {
    public static final Set<String> PREDEFINED = Sets.newHashSet();
    private static final int KEYWORD_PRIORITY = 1;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiFile file2;
        FileViewProvider provider;
        if (parameters == null) {
            ChameleonNamespaceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ChameleonNamespaceCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((provider = (file2 = parameters.getOriginalFile()).getViewProvider()) instanceof ChameleonFileViewProvider) {
            PsiElement chameleonElement = provider.findElementAt(parameters.getOffset() - 1, ChameleonLanguage.class);
            PsiElement xmlElement = provider.findElementAt(parameters.getOffset() - 1, XMLLanguage.class);
            PsiElement xmlAnchor = PsiTreeUtil.getParentOfType((PsiElement)xmlElement, (Class[])new Class[]{XmlAttribute.class, XmlTag.class, ChameleonAttribute.class});
            int offset = parameters.getOffset();
            result = result.withPrefixMatcher(ChameleonNamespaceCompletionContributor.getPrefix(offset, file2));
            if (!(chameleonElement != null && chameleonElement.getNode().getElementType() != ChameleonTokenTypes.TEMPLATE_CHARACTERS || xmlElement != null && !(xmlElement.getParent() instanceof XmlText) && xmlElement.getNode().getElementType() != XmlTokenType.XML_PI_TARGET)) {
                ChameleonNamespaceCompletionContributor.addPythonOpenTag(result);
            }
            if (chameleonElement != null) {
                IElementType elementType = chameleonElement.getNode().getElementType();
                if (xmlAnchor == null) {
                    PsiElement psiElement = xmlAnchor = elementType == ChameleonTokenTypes.TEMPLATE_CHARACTERS ? chameleonElement.getPrevSibling() : chameleonElement.getParent();
                }
            }
            if (xmlAnchor instanceof XmlTag || xmlAnchor instanceof XmlAttribute || xmlAnchor instanceof ChameleonAttribute) {
                for (String tag : PREDEFINED) {
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)tag).withInsertHandler((InsertHandler)new XmlAttributeInsertHandler()), (double)1.0));
                }
            }
        }
    }

    private static void addPythonOpenTag(CompletionResultSet result) {
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"<?python"), (double)1.0));
    }

    private static String getPrefix(int offset, PsiFile file2) {
        if (offset > 0) {
            --offset;
        }
        String text2 = file2.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && (text2.charAt(offset) == ':' || text2.charAt(offset) == '-' || text2.charAt(offset) == '?' || text2.charAt(offset) == '<' || Character.isLetterOrDigit(text2.charAt(offset)))) {
            prefixBuilder.insert(0, text2.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    static {
        PREDEFINED.add("tal:define");
        PREDEFINED.add("tal:switch");
        PREDEFINED.add("tal:condition");
        PREDEFINED.add("tal:repeat");
        PREDEFINED.add("tal:case");
        PREDEFINED.add("tal:content");
        PREDEFINED.add("tal:replace");
        PREDEFINED.add("tal:omit-tag");
        PREDEFINED.add("tal:attributes");
        PREDEFINED.add("tal:on-error");
        PREDEFINED.add("metal:define-macro");
        PREDEFINED.add("metal:use-macro");
        PREDEFINED.add("metal:extend-macro");
        PREDEFINED.add("metal:define-slot");
        PREDEFINED.add("metal:fill-slot");
        PREDEFINED.add("i18n:translate");
        PREDEFINED.add("i18n:domain");
        PREDEFINED.add("i18n:source");
        PREDEFINED.add("i18n:target");
        PREDEFINED.add("i18n:name");
        PREDEFINED.add("i18n:attributes");
        PREDEFINED.add("i18n:data");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/pyramid/templates/completion/ChameleonNamespaceCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

