/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SectionBasedDocString
extends DocStringLineParser
implements StructuredDocString {
    @NonNls
    public static final String RETURNS_SECTION = "returns";
    @NonNls
    public static final String RAISES_SECTION = "raises";
    @NonNls
    public static final String KEYWORD_ARGUMENTS_SECTION = "keyword arguments";
    @NonNls
    public static final String PARAMETERS_SECTION = "parameters";
    @NonNls
    public static final String ATTRIBUTES_SECTION = "attributes";
    @NonNls
    public static final String METHODS_SECTION = "methods";
    @NonNls
    public static final String OTHER_PARAMETERS_SECTION = "other parameters";
    @NonNls
    public static final String YIELDS_SECTION = "yields";
    private static final Pattern PLAIN_TEXT = Pattern.compile("\\w+(\\s+\\w+){2}");
    protected static final Map<String, String> SECTION_ALIASES = ImmutableMap.builder().put((Object)"arguments", (Object)"parameters").put((Object)"args", (Object)"parameters").put((Object)"parameters", (Object)"parameters").put((Object)"keyword args", (Object)"keyword arguments").put((Object)"keyword arguments", (Object)"keyword arguments").put((Object)"other parameters", (Object)"other parameters").put((Object)"attributes", (Object)"attributes").put((Object)"methods", (Object)"methods").put((Object)"note", (Object)"notes").put((Object)"notes", (Object)"notes").put((Object)"example", (Object)"examples").put((Object)"examples", (Object)"examples").put((Object)"return", (Object)"returns").put((Object)"returns", (Object)"returns").put((Object)"yield", (Object)"yields").put((Object)"yields", (Object)"yields").put((Object)"raises", (Object)"raises").put((Object)"references", (Object)"references").put((Object)"see also", (Object)"see also").put((Object)"warning", (Object)"warnings").put((Object)"warns", (Object)"warnings").put((Object)"warnings", (Object)"warnings").build();
    private static final Pattern SPHINX_REFERENCE_RE = Pattern.compile("(:\\w+:\\S+:`.+?`|:\\S+:`.+?`|`.+?`)");
    public static final Set<String> SECTION_NAMES = SECTION_ALIASES.keySet();
    private final Substring mySummary;
    private final List<Section> mySections;
    private final List<Substring> myOtherContent;

    @Nullable
    public static String getNormalizedSectionTitle(@NotNull @NonNls String title) {
        if (title == null) {
            SectionBasedDocString.$$$reportNull$$$0(0);
        }
        return SECTION_ALIASES.get(StringUtil.toLowerCase((String)title));
    }

    public static boolean isValidSectionTitle(@NotNull @NonNls String title) {
        if (title == null) {
            SectionBasedDocString.$$$reportNull$$$0(1);
        }
        return StringUtil.isCapitalized((String)title) && SectionBasedDocString.getNormalizedSectionTitle(title) != null;
    }

    protected SectionBasedDocString(@NotNull Substring text2) {
        int startLine;
        if (text2 == null) {
            SectionBasedDocString.$$$reportNull$$$0(2);
        }
        super(text2);
        this.mySections = new ArrayList<Section>();
        this.myOtherContent = new ArrayList<Substring>();
        List summary = Collections.emptyList();
        int lineNum = startLine = this.consumeEmptyLines(this.parseHeader(0));
        while (lineNum < this.getLineCount()) {
            Pair<Section, Integer> parsedSection = this.parseSection(lineNum);
            if (parsedSection.getFirst() != null) {
                this.mySections.add((Section)parsedSection.getFirst());
                lineNum = (Integer)parsedSection.getSecond();
            } else if (lineNum == startLine) {
                Pair<List<Substring>, Integer> parsedSummary = this.parseSummary(lineNum);
                summary = (List)parsedSummary.getFirst();
                lineNum = (Integer)parsedSummary.getSecond();
            } else {
                this.myOtherContent.add(this.getLine(lineNum));
                ++lineNum;
            }
            lineNum = this.consumeEmptyLines(lineNum);
        }
        this.mySummary = summary.isEmpty() ? null : ((Substring)summary.get(0)).union((Substring)summary.get(summary.size() - 1)).trim();
    }

    @NotNull
    private Pair<List<Substring>, Integer> parseSummary(int lineNum) {
        ArrayList<Substring> result = new ArrayList<Substring>();
        while (!this.isEmptyOrDoesNotExist(lineNum) && !this.isBlockEnd(lineNum)) {
            result.add(this.getLine(lineNum));
            ++lineNum;
        }
        Pair pair = Pair.create(result, (Object)lineNum);
        if (pair == null) {
            SectionBasedDocString.$$$reportNull$$$0(3);
        }
        return pair;
    }

    protected int parseHeader(int startLine) {
        return startLine;
    }

    @NotNull
    protected Pair<Section, Integer> parseSection(int sectionStartLine) {
        Pair<Substring, Integer> parsedHeader = this.parseSectionHeader(sectionStartLine);
        if (parsedHeader.getFirst() == null) {
            Pair pair = Pair.create(null, (Object)sectionStartLine);
            if (pair == null) {
                SectionBasedDocString.$$$reportNull$$$0(4);
            }
            return pair;
        }
        String normalized = SectionBasedDocString.getNormalizedSectionTitle(((Substring)parsedHeader.getFirst()).toString());
        if (normalized == null) {
            Pair pair = Pair.create(null, (Object)sectionStartLine);
            if (pair == null) {
                SectionBasedDocString.$$$reportNull$$$0(5);
            }
            return pair;
        }
        ArrayList<SectionField> fields = new ArrayList<SectionField>();
        int sectionIndent = this.getLineIndentSize(sectionStartLine);
        int lineNum = this.consumeEmptyLines((Integer)parsedHeader.getSecond());
        while (!this.isSectionBreak(lineNum, sectionIndent)) {
            if (!this.isEmpty(lineNum)) {
                Pair<SectionField, Integer> parsedField = this.parseSectionField(lineNum, normalized, sectionIndent);
                if (parsedField.getFirst() != null) {
                    fields.add((SectionField)parsedField.getFirst());
                    lineNum = (Integer)parsedField.getSecond();
                    continue;
                }
                this.myOtherContent.add(this.getLine(lineNum));
            }
            ++lineNum;
        }
        Pair pair = Pair.create((Object)new Section((Substring)parsedHeader.getFirst(), fields), (Object)lineNum);
        if (pair == null) {
            SectionBasedDocString.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @NotNull
    protected Pair<SectionField, Integer> parseSectionField(int lineNum, @NotNull String normalizedSectionTitle, int sectionIndent) {
        FieldType fieldType;
        if (normalizedSectionTitle == null) {
            SectionBasedDocString.$$$reportNull$$$0(7);
        }
        if ((fieldType = this.getFieldType(normalizedSectionTitle)) != null) {
            Pair<SectionField, Integer> pair = this.parseSectionField(lineNum, sectionIndent, fieldType);
            if (pair == null) {
                SectionBasedDocString.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair<SectionField, Integer> pair = this.parseGenericField(lineNum, sectionIndent);
        if (pair == null) {
            SectionBasedDocString.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @Nullable
    protected abstract FieldType getFieldType(@NotNull String var1);

    protected abstract Pair<SectionField, Integer> parseSectionField(int var1, int var2, @NotNull FieldType var3);

    @NotNull
    protected Pair<SectionField, Integer> parseGenericField(int lineNum, int sectionIndent) {
        Pair<List<Substring>, Integer> pair = this.parseIndentedBlock(lineNum, this.getSectionIndentationThreshold(sectionIndent));
        Substring firstLine = (Substring)ContainerUtil.getFirstItem((List)((List)pair.getFirst()));
        Substring lastLine = (Substring)ContainerUtil.getLastItem((List)((List)pair.getFirst()));
        if (firstLine != null && lastLine != null) {
            Pair pair2 = Pair.create((Object)new SectionField((Substring)null, null, firstLine.union(lastLine).trim()), (Object)pair.getSecond());
            if (pair2 == null) {
                SectionBasedDocString.$$$reportNull$$$0(10);
            }
            return pair2;
        }
        Pair pair3 = Pair.create(null, (Object)pair.getSecond());
        if (pair3 == null) {
            SectionBasedDocString.$$$reportNull$$$0(11);
        }
        return pair3;
    }

    @NotNull
    protected abstract Pair<Substring, Integer> parseSectionHeader(int var1);

    protected boolean isSectionStart(int lineNum) {
        Pair<Substring, Integer> pair = this.parseSectionHeader(lineNum);
        return pair.getFirst() != null;
    }

    protected boolean isSectionBreak(int lineNum, int curSectionIndent) {
        return lineNum >= this.getLineCount() || !this.isEmpty(lineNum) && this.getLineIndentSize(lineNum) <= this.getSectionIndentationThreshold(curSectionIndent) || this.isSectionStart(lineNum);
    }

    @NotNull
    protected Pair<List<Substring>, Integer> parseIndentedBlock(int lineNum, int blockIndent) {
        int blockEnd = this.consumeIndentedBlock(lineNum, blockIndent);
        Pair pair = Pair.create(this.myLines.subList(lineNum, blockEnd), (Object)blockEnd);
        if (pair == null) {
            SectionBasedDocString.$$$reportNull$$$0(12);
        }
        return pair;
    }

    protected int getSectionIndentationThreshold(int sectionIndent) {
        return sectionIndent;
    }

    @Override
    protected boolean isBlockEnd(int lineNum) {
        return this.isSectionStart(lineNum);
    }

    protected boolean isValidType(@NotNull String type) {
        if (type == null) {
            SectionBasedDocString.$$$reportNull$$$0(13);
        }
        return !type.isEmpty() && !SectionBasedDocString.isPlainText(type);
    }

    protected static boolean isPlainText(@NotNull String type) {
        if (type == null) {
            SectionBasedDocString.$$$reportNull$$$0(14);
        }
        return PLAIN_TEXT.matcher(type).find();
    }

    protected boolean isValidName(@NotNull String name) {
        if (name == null) {
            SectionBasedDocString.$$$reportNull$$$0(15);
        }
        return PyNames.isIdentifierString(name);
    }

    @NotNull
    protected static List<Substring> splitByFirstColon(@NotNull Substring line2) {
        List<Substring> parts;
        if (line2 == null) {
            SectionBasedDocString.$$$reportNull$$$0(16);
        }
        if ((parts = line2.split(SPHINX_REFERENCE_RE)).size() > 1) {
            for (Substring part : parts) {
                int i = part.indexOf(":");
                if (i < 0) continue;
                Substring beforeColon = new Substring(line2.getSuperString(), line2.getStartOffset(), part.getStartOffset() + i);
                Substring afterColon = new Substring(line2.getSuperString(), part.getStartOffset() + i + 1, line2.getEndOffset());
                List<Substring> list = Arrays.asList(beforeColon, afterColon);
                if (list == null) {
                    SectionBasedDocString.$$$reportNull$$$0(17);
                }
                return list;
            }
            List<Substring> list = Collections.singletonList(line2);
            if (list == null) {
                SectionBasedDocString.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<Substring> list = line2.split(":", 1);
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public List<Section> getSections() {
        List<Section> list = Collections.unmodifiableList(this.mySections);
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    public String getSummary() {
        return this.mySummary != null ? this.mySummary.concatTrimmedLines("\n") : "";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "";
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List list = ContainerUtil.map(this.getParameterSubstrings(), substring -> substring.toString());
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Substring> getParameterSubstrings() {
        ArrayList<Substring> result = new ArrayList<Substring>();
        for (SectionField field : this.getParameterFields()) {
            ContainerUtil.addAllNotNull(result, field.getNamesAsSubstrings());
        }
        ArrayList<Substring> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getParamType(@Nullable String paramName) {
        Substring sub = this.getParamTypeSubstring(paramName);
        return sub != null ? sub.toString() : null;
    }

    @Override
    @Nullable
    public Substring getParamTypeSubstring(@Nullable String paramName) {
        SectionField field;
        if (paramName != null && (field = this.getFirstFieldForParameter(paramName)) != null) {
            return field.getTypeAsSubstring();
        }
        return null;
    }

    @Override
    @Nullable
    public String getParamDescription(@Nullable String paramName) {
        SectionField field;
        if (paramName != null && (field = this.getFirstFieldForParameter(paramName)) != null) {
            return field.getDescription();
        }
        return null;
    }

    @Nullable
    public SectionField getFirstFieldForParameter(@NotNull String name) {
        if (name == null) {
            SectionBasedDocString.$$$reportNull$$$0(23);
        }
        return (SectionField)ContainerUtil.find(this.getParameterFields(), field -> field.getNames().contains(name));
    }

    @NotNull
    public List<SectionField> getParameterFields() {
        ArrayList<SectionField> result = new ArrayList<SectionField>();
        for (Section section : this.getParameterSections()) {
            result.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public List<Section> getParameterSections() {
        List<Section> list = this.getSectionsWithNormalizedTitle(PARAMETERS_SECTION);
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getKeywordArguments() {
        ArrayList<String> result = new ArrayList<String>();
        for (SectionField field : this.getKeywordArgumentFields()) {
            result.addAll(field.getNames());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Substring> getKeywordArgumentSubstrings() {
        ArrayList<Substring> result = new ArrayList<Substring>();
        for (SectionField field : this.getKeywordArgumentFields()) {
            ContainerUtil.addAllNotNull(field.getNamesAsSubstrings(), (Object[])new Substring[0]);
        }
        ArrayList<Substring> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getKeywordArgumentDescription(@Nullable String paramName) {
        SectionField argument;
        if (paramName != null && (argument = this.getFirstFieldForKeywordArgument(paramName)) != null) {
            return argument.getDescription();
        }
        return null;
    }

    @NotNull
    public List<SectionField> getKeywordArgumentFields() {
        ArrayList<SectionField> result = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(KEYWORD_ARGUMENTS_SECTION)) {
            result.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Nullable
    private SectionField getFirstFieldForKeywordArgument(@NotNull String name) {
        if (name == null) {
            SectionBasedDocString.$$$reportNull$$$0(29);
        }
        return (SectionField)ContainerUtil.find(this.getKeywordArgumentFields(), field -> field.getNames().contains(name));
    }

    @Override
    @Nullable
    public String getReturnType() {
        Substring sub = this.getReturnTypeSubstring();
        return sub != null ? sub.toString() : null;
    }

    @Override
    @Nullable
    public Substring getReturnTypeSubstring() {
        SectionField field = this.getFirstReturnField();
        return field != null ? field.getTypeAsSubstring() : null;
    }

    @Override
    @Nullable
    public String getReturnDescription() {
        SectionField field = this.getFirstReturnField();
        return field != null ? field.getDescription() : null;
    }

    @NotNull
    public List<SectionField> getReturnFields() {
        ArrayList<SectionField> result = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(RETURNS_SECTION)) {
            result.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Nullable
    private SectionField getFirstReturnField() {
        return (SectionField)ContainerUtil.getFirstItem(this.getReturnFields());
    }

    @Override
    @NotNull
    public List<String> getRaisedExceptions() {
        List list = ContainerUtil.mapNotNull(this.getExceptionFields(), field -> StringUtil.nullize((String)field.getType()));
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Override
    @Nullable
    public String getRaisedExceptionDescription(@Nullable String exceptionName) {
        SectionField exception;
        if (exceptionName != null && (exception = this.getFirstFieldForException(exceptionName)) != null) {
            return exception.getDescription();
        }
        return null;
    }

    @NotNull
    public List<SectionField> getExceptionFields() {
        ArrayList<SectionField> result = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(RAISES_SECTION)) {
            result.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @Nullable
    private SectionField getFirstFieldForException(@NotNull String exceptionType) {
        if (exceptionType == null) {
            SectionBasedDocString.$$$reportNull$$$0(33);
        }
        return (SectionField)ContainerUtil.find(this.getExceptionFields(), field -> exceptionType.equals(field.getType()));
    }

    @NotNull
    public List<SectionField> getAttributeFields() {
        ArrayList<SectionField> result = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(ATTRIBUTES_SECTION)) {
            result.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList = result;
        if (arrayList == null) {
            SectionBasedDocString.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public List<Section> getSectionsWithNormalizedTitle(@NotNull String title) {
        if (title == null) {
            SectionBasedDocString.$$$reportNull$$$0(35);
        }
        List list = ContainerUtil.mapNotNull(this.mySections, section -> section.getNormalizedTitle().equals(SectionBasedDocString.getNormalizedSectionTitle(title)) ? section : null);
        if (list == null) {
            SectionBasedDocString.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    public Section getFirstSectionWithNormalizedTitle(@NotNull String title) {
        if (title == null) {
            SectionBasedDocString.$$$reportNull$$$0(37);
        }
        return (Section)ContainerUtil.getFirstItem(this.getSectionsWithNormalizedTitle(title));
    }

    @Override
    @Nullable
    public String getAttributeDescription() {
        return null;
    }

    @NotNull
    protected static Substring cleanUpName(@NotNull Substring name) {
        int firstNotStar;
        if (name == null) {
            SectionBasedDocString.$$$reportNull$$$0(38);
        }
        for (firstNotStar = 0; firstNotStar < name.length() && name.charAt(firstNotStar) == '*'; ++firstNotStar) {
        }
        Substring substring = name.substring(firstNotStar).trimLeft();
        if (substring == null) {
            SectionBasedDocString.$$$reportNull$$$0(39);
        }
        return substring;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedSectionTitle";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 23: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSummary";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSectionField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGenericField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIndentedBlock";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByFirstColon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSections";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSubstrings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterFields";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSections";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArguments";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArgumentSubstrings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArgumentFields";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnFields";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getRaisedExceptions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionFields";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeFields";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionsWithNormalizedTitle";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedSectionTitle";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSectionTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSectionField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPlainText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitByFirstColon";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForParameter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForKeywordArgument";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForException";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSectionsWithNormalizedTitle";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstSectionWithNormalizedTitle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 36: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SectionField {
        private final List<Substring> myNames;
        private final Substring myType;
        private final Substring myDescription;

        public SectionField(@Nullable Substring name, @Nullable Substring type, @Nullable Substring description) {
            this(name == null ? Collections.emptyList() : Collections.singletonList(name), type, description);
        }

        public SectionField(@NotNull List<Substring> names, @Nullable Substring type, @Nullable Substring description) {
            if (names == null) {
                SectionField.$$$reportNull$$$0(0);
            }
            this.myNames = names;
            this.myType = type;
            this.myDescription = description;
        }

        @Nullable
        public String getName() {
            return this.myNames.isEmpty() ? null : this.myNames.get(0).toString();
        }

        @Nullable
        public Substring getNameAsSubstring() {
            return this.myNames.isEmpty() ? null : this.myNames.get(0);
        }

        @NotNull
        public List<Substring> getNamesAsSubstrings() {
            List<Substring> list = this.myNames;
            if (list == null) {
                SectionField.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public List<String> getNames() {
            List list = ContainerUtil.map(this.myNames, substring -> substring.toString());
            if (list == null) {
                SectionField.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Nullable
        public String getType() {
            return this.myType == null ? null : this.myType.toString();
        }

        @Nullable
        public Substring getTypeAsSubstring() {
            return this.myType;
        }

        @Nullable
        public String getDescription() {
            return this.myDescription == null ? null : PyIndentUtil.removeCommonIndent(this.myDescription.getValue(), true);
        }

        @Nullable
        public Substring getDescriptionAsSubstring() {
            return this.myDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SectionField field = (SectionField)o;
            if (this.myNames != null ? !this.myNames.equals(field.myNames) : field.myNames != null) {
                return false;
            }
            if (this.myType != null ? !this.myType.equals(field.myType) : field.myType != null) {
                return false;
            }
            return !(this.myDescription != null ? !this.myDescription.equals(field.myDescription) : field.myDescription != null);
        }

        public int hashCode() {
            int result = this.myNames != null ? this.myNames.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$SectionField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$SectionField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamesAsSubstrings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Section {
        private final Substring myTitle;
        private final List<SectionField> myFields;

        public Section(@NotNull Substring title, @NotNull List<SectionField> fields) {
            if (title == null) {
                Section.$$$reportNull$$$0(0);
            }
            if (fields == null) {
                Section.$$$reportNull$$$0(1);
            }
            this.myTitle = title;
            this.myFields = new ArrayList<SectionField>(fields);
        }

        @NotNull
        public Substring getTitleAsSubstring() {
            Substring substring = this.myTitle;
            if (substring == null) {
                Section.$$$reportNull$$$0(2);
            }
            return substring;
        }

        @NotNull
        public String getTitle() {
            String string = this.myTitle.toString();
            if (string == null) {
                Section.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getNormalizedTitle() {
            String string = SectionBasedDocString.getNormalizedSectionTitle(this.getTitle());
            if (string == null) {
                Section.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public List<SectionField> getFields() {
            List<SectionField> list = Collections.unmodifiableList(this.myFields);
            if (list == null) {
                Section.$$$reportNull$$$0(5);
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Section section = (Section)o;
            if (!this.myTitle.equals(section.myTitle)) {
                return false;
            }
            return this.myFields.equals(section.myFields);
        }

        public int hashCode() {
            int result = this.myTitle.hashCode();
            result = 31 * result + this.myFields.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$Section";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$Section";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleAsSubstring";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static enum FieldType {
        NAME_WITH_OPTIONAL_TYPE(true, false, false),
        TYPE_WITH_OPTIONAL_NAME(true, true, false),
        ONLY_TYPE(false, true, false),
        OPTIONAL_TYPE(false, true, true),
        ONLY_NAME(false, false, false);

        public final boolean canHaveBothNameAndType;
        public final boolean preferType;
        public final boolean canHaveOnlyDescription;

        private FieldType(boolean canHaveType, boolean preferType, boolean canHaveOnlyDescription) {
            this.canHaveBothNameAndType = canHaveType;
            this.canHaveOnlyDescription = canHaveOnlyDescription;
            this.preferType = preferType;
        }
    }
}

