/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.editor.PythonEnterHandler;
import com.jetbrains.python.psi.PyDocStringOwner;
import org.jetbrains.annotations.NotNull;

public class PythonSpaceHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            PythonSpaceHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PythonSpaceHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            PythonSpaceHandler.$$$reportNull$$$0(2);
        }
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (c == ' ' && codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            PyDocStringOwner docOwner;
            int offset = editor2.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            if (element == null && offset > 1) {
                element = file2.findElementAt(offset - 2);
            }
            if (element == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PythonSpaceHandler.$$$reportNull$$$0(3);
                }
                return result;
            }
            int expectedStringStart = offset - 4;
            Document document = editor2.getDocument();
            if (PythonEnterHandler.canGenerateDocstring(element, expectedStringStart, document) == PythonEnterHandler.DocstringState.INCOMPLETE && (docOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class)) != null) {
                String quotes = document.getText(TextRange.from((int)expectedStringStart, (int)3));
                String docString = PyDocstringGenerator.forDocStringOwner(docOwner).forceNewMode().withInferredParameters(true).withQuotes(quotes).buildDocString();
                document.insertString(offset, (CharSequence)docString.substring(3));
                if (!StringUtil.isEmptyOrSpaces((String)docString.substring(3, docString.length() - 3))) {
                    editor2.getCaretModel().moveCaretRelatively(100, 1, false, false, false);
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    PythonSpaceHandler.$$$reportNull$$$0(4);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PythonSpaceHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PythonSpaceHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PythonSpaceHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

