/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.steps.PyAddExistingSdkPanel;
import com.jetbrains.python.newProject.steps.PyAddNewEnvironmentPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSpecificSettingsStep<T>
extends ProjectSettingsStepBase<T>
implements DumbAware {
    private boolean myInstallFramework;
    @Nullable
    private PyAddSdkGroupPanel myInterpreterPanel;
    @Nullable
    private HideableDecorator myInterpretersDecorator;

    public ProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> projectGenerator, @NotNull AbstractNewProjectStep.AbstractCallback<T> callback2) {
        if (projectGenerator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(0);
        }
        if (callback2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(1);
        }
        super(projectGenerator, callback2);
    }

    protected JPanel createAndFillContentPanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).setErrorCallback(this::setErrorText);
        }
        return this.createContentPanelWithAdvancedSettingsPanel();
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        JComponent advancedSettings = null;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            advancedSettings = ((PythonProjectGenerator)this.myProjectGenerator).getSettingsPanel(this.myProjectDirectory);
        } else if (this.myProjectGenerator instanceof WebProjectTemplate) {
            advancedSettings = this.getPeer().getComponent();
        }
        if (advancedSettings != null) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            HideableDecorator deco = new HideableDecorator(jPanel, PyBundle.message("python.new.project.more.settings", new Object[0]), false);
            if (this.myProjectGenerator instanceof PythonProjectGenerator) {
                ValidationResult result = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(this.getInterpreterPanelSdk());
                deco.setOn(!result.isOk());
            }
            deco.setContentComponent(advancedSettings);
            return jPanel;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        if (!(this.myProjectGenerator instanceof PythonProjectGenerator)) {
            return null;
        }
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddSdkPanel panel2 = interpreterPanel.getSelectedPanel();
        if (panel2 instanceof PyAddNewEnvironmentPanel) {
            PyAddNewEnvironmentPanel newEnvironmentPanel = (PyAddNewEnvironmentPanel)panel2;
            return new PyLazySdk("Uninitialized environment", (NullableComputable<Sdk>)((NullableComputable)newEnvironmentPanel::getOrCreateSdk));
        }
        if (panel2 instanceof PyAddExistingSdkPanel) {
            return panel2.getSdk();
        }
        return null;
    }

    @Nullable
    private Sdk getInterpreterPanelSdk() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        return interpreterPanel.getSdk();
    }

    public boolean installFramework() {
        return this.myInstallFramework;
    }

    protected void registerValidators() {
        super.registerValidators();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            this.addLocationChangeListener((Consumer<DocumentEvent>)((Consumer)event2 -> {
                String fileName = PathUtil.getFileName((String)this.getNewProjectPath());
                ((PythonProjectGenerator)this.myProjectGenerator).locationChanged(fileName);
            }));
        }
    }

    @Nullable
    public final String getRemotePath() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddExistingSdkPanel panel2 = (PyAddExistingSdkPanel)ObjectUtils.tryCast((Object)interpreterPanel.getSelectedPanel(), PyAddExistingSdkPanel.class);
        if (panel2 == null) {
            return null;
        }
        return panel2.getRemotePath();
    }

    protected void initGeneratorListeners() {
        super.initGeneratorListeners();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).addSettingsStateListener(this::checkValid);
            this.myErrorLabel.addMouseListener(((PythonProjectGenerator)this.myProjectGenerator).getErrorLabelMouseListener());
        }
    }

    public void setErrorText(@Nullable String text2) {
        super.setErrorText(text2);
        if (this.myInterpretersDecorator != null && !StringUtil.isEmpty((String)text2)) {
            this.myInterpretersDecorator.setOn(true);
        }
    }

    public void setWarningText(@Nullable String text2) {
        super.setWarningText(text2);
        if (this.myInterpretersDecorator != null && !StringUtil.isEmpty((String)text2)) {
            this.myInterpretersDecorator.setOn(true);
        }
    }

    public boolean checkValid() {
        this.myInstallFramework = false;
        if (!super.checkValid()) {
            return false;
        }
        Map errorsAndWarnings = StreamEx.of(this.myInterpreterPanel == null ? Collections.emptyList() : this.myInterpreterPanel.validateAll()).groupingBy(it -> it.warning, Collectors.mapping(it -> it.message, Collectors.toList()));
        List validationErrors = errorsAndWarnings.getOrDefault(false, Collections.emptyList());
        List validationWarnings = errorsAndWarnings.getOrDefault(true, Collections.emptyList());
        if (!validationErrors.isEmpty()) {
            this.setErrorText(StringUtil.join(validationErrors, (String)"\n"));
            return false;
        }
        if (!validationWarnings.isEmpty()) {
            this.setWarningText(StringUtil.join(validationWarnings, (String)"<br/>"));
        }
        PythonProjectGenerator generator = (PythonProjectGenerator)((Object)ObjectUtils.tryCast((Object)this.myProjectGenerator, PythonProjectGenerator.class));
        Sdk sdk = this.getInterpreterPanelSdk();
        if (generator == null || sdk == null) {
            this.myInstallFramework = true;
            return true;
        }
        try {
            generator.checkProjectCanBeCreatedOnSdk(sdk, new File(this.myLocationField.getText()));
        }
        catch (PythonProjectGenerator.PyNoProjectAllowedOnSdkException e) {
            this.setErrorText(e.getMessage());
            return false;
        }
        ArrayList warnings = new ArrayList(validationWarnings);
        PyFrameworkProjectGenerator frameworkGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.myProjectGenerator, PyFrameworkProjectGenerator.class);
        if (frameworkGenerator != null) {
            String python3Error = ProjectSpecificSettingsStep.validateFrameworkSupportsPython3(frameworkGenerator, sdk);
            if (python3Error != null) {
                this.setErrorText(python3Error);
                return false;
            }
            if (!PythonSdkUtil.isRemote(sdk)) {
                Pair<Boolean, List<String>> validationInfo = ProjectSpecificSettingsStep.validateFramework(frameworkGenerator, sdk);
                this.myInstallFramework = (Boolean)validationInfo.first;
                warnings.addAll((Collection)validationInfo.second);
                ValidationResult warningResult = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(sdk);
                if (!warningResult.isOk()) {
                    warnings.add(warningResult.getErrorMessage());
                }
            }
        }
        if (!warnings.isEmpty()) {
            this.setWarningText(StringUtil.join(warnings, (String)"<br/>"));
        }
        return true;
    }

    private static String validateFrameworkSupportsPython3(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(3);
        }
        String frameworkName = generator.getFrameworkTitle();
        boolean isPy3k = PythonSdkType.getLanguageLevelForSdk(sdk).isPy3K();
        return isPy3k && !generator.supportsPython3() ? frameworkName + " is not supported for the selected interpreter" : null;
    }

    @NotNull
    private static Pair<Boolean, List<String>> validateFramework(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(5);
        }
        ArrayList<String> warnings = new ArrayList<String>();
        boolean installFramework = false;
        if (!generator.isFrameworkInstalled(sdk)) {
            String frameworkName = generator.getFrameworkTitle();
            String messageId = "python.package.installation.notification.message";
            if (PyPackageUtil.packageManagementEnabled(sdk)) {
                installFramework = true;
                List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
                if (!PyPackageUtil.hasManagement(packages)) {
                    messageId = "python.package.and.packaging.tools.installation.notification.message";
                }
            }
            warnings.add(PyBundle.message(messageId, frameworkName));
        }
        Pair pair = Pair.create((Object)installFramework, warnings);
        if (pair == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(6);
        }
        return pair;
    }

    protected JPanel createBasePanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            BorderLayout layout = new BorderLayout();
            JPanel locationPanel = new JPanel(layout);
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
            LabeledComponent location = this.createLocationComponent();
            locationPanel.add((Component)location, "Center");
            panel2.add(locationPanel);
            panel2.add(this.createInterpretersPanel(((PythonProjectGenerator)this.myProjectGenerator).getPreferredEnvironmentType()));
            JPanel basePanelExtension = ((PythonProjectGenerator)this.myProjectGenerator).extendBasePanel();
            if (basePanelExtension != null) {
                panel2.add(basePanelExtension);
            }
            return panel2;
        }
        return super.createBasePanel();
    }

    @NotNull
    private JPanel createInterpretersPanel(@Nullable String preferredEnvironment) {
        JPanel container = new JPanel(new BorderLayout());
        JPanel decoratorPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        List<Sdk> existingSdks = ProjectSpecificSettingsStep.getValidPythonSdks();
        Sdk preferredSdk = this.getPreferredSdk(existingSdks);
        String newProjectPath = this.getNewProjectPath();
        PyAddNewEnvironmentPanel newEnvironmentPanel = new PyAddNewEnvironmentPanel(existingSdks, newProjectPath, preferredEnvironment);
        PyAddExistingSdkPanel existingSdkPanel = new PyAddExistingSdkPanel(null, null, existingSdks, newProjectPath, preferredSdk);
        PyAddSdkPanel defaultPanel = PySdkSettings.getInstance().getUseNewEnvironmentForNewProject() ? newEnvironmentPanel : existingSdkPanel;
        this.myInterpretersDecorator = new HideableDecorator(decoratorPanel, ProjectSpecificSettingsStep.getProjectInterpreterTitle(defaultPanel), false);
        this.myInterpretersDecorator.setContentComponent((JComponent)container);
        List<PyAddSdkPanel> panels = Arrays.asList(newEnvironmentPanel, existingSdkPanel);
        this.myInterpreterPanel = new PyAddSdkGroupPanel(PyBundle.messagePointer("python.add.sdk.panel.name.new.project.interpreter", new Object[0]), this.getIcon(), panels, defaultPanel);
        this.myInterpreterPanel.addChangeListener(() -> {
            this.myInterpretersDecorator.setTitle(ProjectSpecificSettingsStep.getProjectInterpreterTitle(this.myInterpreterPanel.getSelectedPanel()));
            boolean useNewEnvironment = this.myInterpreterPanel.getSelectedPanel() instanceof PyAddNewEnvironmentPanel;
            PySdkSettings.getInstance().setUseNewEnvironmentForNewProject(useNewEnvironment);
            this.checkValid();
        });
        this.addLocationChangeListener((Consumer<DocumentEvent>)((Consumer)event2 -> this.myInterpreterPanel.setNewProjectPath(this.getNewProjectPath())));
        container.add((Component)this.myInterpreterPanel, "North");
        this.checkValid();
        JPanel jPanel = decoratorPanel;
        if (jPanel == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private String getNewProjectPath() {
        TextFieldWithBrowseButton field = this.myLocationField;
        if (field == null) {
            return "";
        }
        String string = field.getText().trim();
        if (string == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(8);
        }
        return string;
    }

    private void addLocationChangeListener(final @NotNull Consumer<DocumentEvent> listener2) {
        TextFieldWithBrowseButton field;
        if (listener2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(9);
        }
        if ((field = this.myLocationField) == null) {
            return;
        }
        field.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                listener2.consume((Object)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep$1", "textChanged"));
            }
        });
    }

    @NotNull
    private static String getProjectInterpreterTitle(@NotNull PyAddSdkPanel panel2) {
        Sdk sdk;
        if (panel2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(10);
        }
        String name = panel2 instanceof PyAddNewEnvironmentPanel ? PyBundle.message("python.sdk.new.environment.kind", ((PyAddNewEnvironmentPanel)panel2).getSelectedPanel().getEnvName()) : ((sdk = panel2.getSdk()) != null ? sdk.getName() : panel2.getPanelName());
        String string = PyBundle.message("python.sdk.python.interpreter.title.0", name);
        if (string == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private Sdk getPreferredSdk(@NotNull List<Sdk> sdks) {
        PyFrameworkProjectGenerator projectGenerator;
        if (sdks == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(12);
        }
        boolean onlyPython2 = (projectGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.getProjectGenerator(), PyFrameworkProjectGenerator.class)) != null && !projectGenerator.supportsPython3();
        Sdk preferred = (Sdk)ContainerUtil.getFirstItem(sdks);
        if (preferred == null) {
            return null;
        }
        if (onlyPython2 && !PythonSdkType.getLanguageLevelForSdk(preferred).isPython2()) {
            Sdk python2Sdk = PythonSdkType.findPython2Sdk(sdks);
            return python2Sdk != null ? python2Sdk : preferred;
        }
        return preferred;
    }

    @NotNull
    private static List<Sdk> getValidPythonSdks() {
        List list = ((StreamEx)((StreamEx)StreamEx.of(PyConfigurableInterpreterList.getInstance(null).getAllPythonSdks()).filter(sdk -> sdk != null && sdk.getSdkType() instanceof PythonSdkType && !PythonSdkUtil.isInvalid(sdk))).sorted((Comparator)new PreferredSdkComparator())).toList();
        if (list == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFramework";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpretersPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewProjectPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInterpreterTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPythonSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validateFrameworkSupportsPython3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateFramework";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLocationChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInterpreterTitle";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

