/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.jetbrains.python.profiler.CallStat;
import com.jetbrains.python.profiler.ProfileStatData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\b\u0010 \u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/profiler/CallStatData;", "Lcom/jetbrains/python/profiler/CallStat;", "fileName", "", "funcName", "lineNumber", "", "callCnt", "totalTime", "", "ownTime", "profileStatData", "Lcom/jetbrains/python/profiler/ProfileStatData;", "(Ljava/lang/String;Ljava/lang/String;IIDDLcom/jetbrains/python/profiler/ProfileStatData;)V", "getCallCnt", "()I", "getFileName", "()Ljava/lang/String;", "getFuncName", "getLineNumber", "getOwnTime", "()D", "getProfileStatData", "()Lcom/jetbrains/python/profiler/ProfileStatData;", "getTotalTime", "getBaseTotalTime", "getCallCount", "getFile", "getLine", "getName", "getOwnTimeMs", "getTotalTimeMs", "toString", "intellij.python.profiler"})
public class CallStatData
implements CallStat {
    @NotNull
    private final String fileName;
    @NotNull
    private final String funcName;
    private final int lineNumber;
    private final int callCnt;
    private final double totalTime;
    private final double ownTime;
    @NotNull
    private final ProfileStatData profileStatData;

    @Override
    @NotNull
    public String getFile() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    @Override
    public int getCallCount() {
        return this.callCnt;
    }

    @Override
    public int getTotalTimeMs() {
        return (int)(this.totalTime * (double)1000);
    }

    @Override
    public int getOwnTimeMs() {
        return (int)(this.ownTime * (double)1000);
    }

    @Override
    public int getBaseTotalTime() {
        return this.profileStatData.getBaseTotalTimeMs();
    }

    @NotNull
    public String toString() {
        return this.getName();
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getFuncName() {
        return this.funcName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getCallCnt() {
        return this.callCnt;
    }

    public final double getTotalTime() {
        return this.totalTime;
    }

    public final double getOwnTime() {
        return this.ownTime;
    }

    @NotNull
    public final ProfileStatData getProfileStatData() {
        return this.profileStatData;
    }

    public CallStatData(@NotNull String fileName, @NotNull String funcName, int lineNumber, int callCnt, double totalTime, double ownTime, @NotNull ProfileStatData profileStatData) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)funcName, (String)"funcName");
        Intrinsics.checkParameterIsNotNull((Object)profileStatData, (String)"profileStatData");
        this.fileName = fileName;
        this.funcName = funcName;
        this.lineNumber = lineNumber;
        this.callCnt = callCnt;
        this.totalTime = totalTime;
        this.ownTime = ownTime;
        this.profileStatData = profileStatData;
    }
}

