/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.profiler.ProfileSessionKt;
import com.jetbrains.python.profiler.ProfileStatData;
import com.jetbrains.python.profiler.ProfilerResponse;
import com.jetbrains.python.profiler.Stats;
import com.jetbrains.python.profiler.TreeStats;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import java.io.DataInputStream;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"addPathMappingsInfo", "", "profileStatData", "Lcom/jetbrains/python/profiler/ProfileStatData;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "generateSnapshotPath", "", "project", "Lcom/intellij/openapi/project/Project;", "processResponse", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "response", "Lcom/jetbrains/python/profiler/ProfilerResponse;", "readProfilerResponse", "reader", "Ljava/io/DataInputStream;", "readResponseFromArray", "array", "", "intellij.python.profiler"})
public final class ProfilerCommunicationKt {
    public static final void processResponse(@NotNull Project project, @NotNull Sdk sdk, @NotNull ProfilerResponse response, @Nullable ProcessHandler processHandler2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        if (response.getSnapshot_filepath() != null) {
            String string = response.getSnapshot_filepath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.getSnapshot_filepath()");
            ProfileSessionKt.processSavedSnapshot(project, sdk, string);
        } else if (response.getYstats() != null) {
            Stats stats = response.ystats;
            TreeStats treeStats = response.tree_stats;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            VirtualFile[] virtualFileArray = projectRootManager.getContentRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"ProjectRootManager.getIn\u2026nce(project).contentRoots");
            ProfileStatData profileStatData = new ProfileStatData(stats, treeStats, virtualFileArray);
            ProfilerCommunicationKt.addPathMappingsInfo(profileStatData, processHandler2);
            ProfileSessionKt.openProfileResultsInEditor(project, profileStatData, null);
        } else {
            throw (Throwable)new IllegalStateException("Response should contain snapshot path or snapshot data");
        }
    }

    private static final void addPathMappingsInfo(ProfileStatData profileStatData, ProcessHandler processHandler2) {
        if (processHandler2 != null) {
            profileStatData.putUserData(PythonRemoteInterpreterManager.PATH_MAPPING_SETTINGS_KEY, processHandler2.getUserData(PythonRemoteInterpreterManager.PATH_MAPPING_SETTINGS_KEY));
        }
    }

    @NotNull
    public static final String generateSnapshotPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return PathManager.getSystemPath() + File.separator + "snapshots" + File.separator + project.getName();
    }

    @NotNull
    public static final ProfilerResponse readProfilerResponse(@NotNull DataInputStream reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        int n = reader.readInt();
        byte[] array = new byte[n];
        reader.readFully(array, 0, n);
        ProfilerResponse response = ProfilerCommunicationKt.readResponseFromArray(array);
        return response;
    }

    @NotNull
    public static final ProfilerResponse readResponseFromArray(@NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        ProfilerResponse response = new ProfilerResponse();
        new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory()).deserialize((TBase)response, array);
        return response;
    }
}

