/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures.image;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.scientific.figures.WithBinaryContent;
import com.jetbrains.python.scientific.figures.WithDockableContent;
import com.jetbrains.python.scientific.figures.base.FigureBase;
import com.jetbrains.python.scientific.figures.base.FigureUtil;
import com.jetbrains.python.scientific.figures.image.ImageVirtualFile;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ImageFigure
extends FigureBase
implements WithDockableContent {
    @NotNull
    private final TabInfo myTabInfo;
    @NotNull
    private final Project myProject;

    public ImageFigure(@NotNull ImageVirtualFile imageVirtualFile, @NotNull Project project) {
        if (imageVirtualFile == null) {
            ImageFigure.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ImageFigure.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myTabInfo = ImageFigure.createTabInfo(imageVirtualFile, project);
    }

    public static ImageFigure createDefault(@NotNull BufferedImage image, @NotNull Project project) {
        if (image == null) {
            ImageFigure.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ImageFigure.$$$reportNull$$$0(3);
        }
        String simpleName = "myplot.png";
        ImageVirtualFile virtualFile2 = new ImageVirtualFile(simpleName, image);
        return new ImageFigure(virtualFile2, project);
    }

    @NotNull
    private static TabInfo createTabInfo(@NotNull ImageVirtualFile imageVirtualFile, Project project) {
        if (imageVirtualFile == null) {
            ImageFigure.$$$reportNull$$$0(4);
        }
        MyContentPanel panel2 = new MyContentPanel(imageVirtualFile, project);
        TabInfo info = new TabInfo((JComponent)panel2);
        info.setTabColor(UIUtil.getPanelBackground());
        BufferedImage image = imageVirtualFile.getImage();
        Image after = FigureUtil.fit(image, 64, 48);
        info.setIcon((Icon)new ImageIcon(after));
        info.setText(" ");
        TabInfo tabInfo = info;
        if (tabInfo == null) {
            ImageFigure.$$$reportNull$$$0(5);
        }
        return tabInfo;
    }

    @Override
    @NotNull
    public TabInfo getTabInfo() {
        TabInfo tabInfo = this.myTabInfo;
        if (tabInfo == null) {
            ImageFigure.$$$reportNull$$$0(6);
        }
        return tabInfo;
    }

    @Override
    @NotNull
    public DockableContent createDockableContent() {
        Image img = JBTabsImpl.getComponentImage((TabInfo)this.myTabInfo);
        Presentation presentation = new Presentation(this.myTabInfo.getText());
        Dimension preferredSize = this.myTabInfo.getComponent().getPreferredSize();
        ImageVirtualFile file2 = ((MyContentPanel)this.myTabInfo.getComponent()).getVirtualFile();
        ImageVirtualFile fileCopy = ImageVirtualFile.makeCopy(file2);
        return new EditorTabbedContainer.DockableEditor(this.myProject, img, (VirtualFile)fileCopy, presentation, preferredSize, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageVirtualFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/scientific/figures/image/ImageFigure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/scientific/figures/image/ImageFigure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTabInfo";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyContentPanel
    extends JPanel
    implements WithBinaryContent,
    Disposable {
        @NotNull
        private final ImageVirtualFile myVirtualFile;
        private FileEditor myEditor;

        private MyContentPanel(@NotNull ImageVirtualFile virtualFile2, Project project) {
            if (virtualFile2 == null) {
                MyContentPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myVirtualFile = virtualFile2;
            ApplicationManager.getApplication().invokeLater(() -> {
                FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider("images");
                if (provider != null) {
                    this.myEditor = provider.createEditor(project, (VirtualFile)this.myVirtualFile);
                    this.add(this.myEditor.getComponent());
                }
            });
            this.setBackground(UIUtil.getEditorPaneBackground());
        }

        @NotNull
        private ImageVirtualFile getVirtualFile() {
            ImageVirtualFile imageVirtualFile = this.myVirtualFile;
            if (imageVirtualFile == null) {
                MyContentPanel.$$$reportNull$$$0(1);
            }
            return imageVirtualFile;
        }

        @Override
        public byte[] getBytes() {
            return this.myVirtualFile.getContent();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myVirtualFile);
            Disposer.dispose((Disposable)this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/scientific/figures/image/ImageFigure$MyContentPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/scientific/figures/image/ImageFigure$MyContentPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

