/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.annotator;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.web2py.Web2PyUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyViewLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            Web2PyViewLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            Web2PyViewLineMarkerProvider.$$$reportNull$$$0(1);
        }
        Web2PyViewLineMarkerProvider.collectLineMarkersForElement(result, element);
    }

    public static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement element) {
        RelatedItemLineMarkerInfo<PsiElement> info;
        if (!(element instanceof PyFunction)) {
            return;
        }
        if (Web2PyUtils.isWeb2PyProject(element.getProject()) && (info = Web2PyViewLineMarkerProvider.createViewMethodLineMarker((PyFunction)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createViewMethodLineMarker(PyFunction pyFunction) {
        PsiFile psiFile;
        ArrayList files = Lists.newArrayList();
        TypeEvalContext context = TypeEvalContext.codeAnalysis(pyFunction.getProject(), pyFunction.getContainingFile());
        PyType type = context.getReturnType(pyFunction);
        if (!PyTypeChecker.match((PyType)PyBuiltinCache.getInstance(pyFunction).getDictType(), type, context)) {
            return null;
        }
        VirtualFile viewFile = Web2PyUtils.getViewFile(pyFunction, true);
        if (viewFile != null && (psiFile = pyFunction.getManager().findFile(viewFile)) != null) {
            files.add(psiFile);
        }
        if ((viewFile = Web2PyUtils.getViewFile(pyFunction, false)) != null && (psiFile = pyFunction.getManager().findFile(viewFile)) != null) {
            files.add(psiFile);
        }
        if (!files.isEmpty()) {
            String msg = PythonProBundle.message("python.web2py.goto.template.message");
            PsiElement identifier = pyFunction.getNameIdentifier();
            if (identifier != null) {
                return new RelatedItemLineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.FileTypes.Html, 11, (Function)new ConstantFunction((Object)msg), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler((Collection)files, msg), GutterIconRenderer.Alignment.RIGHT, (Collection)GotoRelatedItem.createItems((Collection)files, (String)"Views"));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/web2py/annotator/Web2PyViewLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

