/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.web2py.Web2PyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        String name;
        String viewName;
        PsiFile file2;
        PsiDirectory directory2;
        if (!(element instanceof PyFunction)) {
            return null;
        }
        if (Web2PyUtils.isWeb2PyProject(element.getProject()) && (directory2 = (file2 = element.getContainingFile()).getContainingDirectory()) != null && directory2.getName().equals("controllers") && (viewName = Web2PyUtils.getViewNameDefinedInFunction((PyFunction)element)) == null && (name = Web2PyUtils.getViewName((PyFunction)element, false)) != null) {
            return new ViewRefactoringListener(element.getProject(), name);
        }
        return null;
    }

    private static class ViewRefactoringListener
    implements RefactoringElementListener {
        @NotNull
        private final Project myProject;
        private final String myOldName;
        private String myNewViewName;

        ViewRefactoringListener(@NotNull Project project, String oldName) {
            if (project == null) {
                ViewRefactoringListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myOldName = oldName;
        }

        public void elementMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                ViewRefactoringListener.$$$reportNull$$$0(1);
            }
        }

        public void elementRenamed(@NotNull PsiElement newElement) {
            String newViewName;
            if (newElement == null) {
                ViewRefactoringListener.$$$reportNull$$$0(2);
            }
            if ((newViewName = ((PyFunction)newElement).getName()) != null) {
                VirtualFile viewFolder;
                this.myNewViewName = newViewName + ViewRefactoringListener.getExtension(this.myOldName);
                VirtualFile virtualFile2 = Web2PyUtils.getViewFileByFunctionName((PyFunction)newElement, this.myOldName);
                if (virtualFile2 == null) {
                    return;
                }
                for (viewFolder = virtualFile2.getParent(); viewFolder != null && !"views".equals(viewFolder.getName()); viewFolder = viewFolder.getParent()) {
                }
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile2);
                RenameRefactoring rename = RefactoringFactory.getInstance((Project)this.myProject).createRename((PsiElement)psiFile, this.myNewViewName);
                if (psiFile != null) {
                    rename.setSearchInComments(false);
                    rename.setSearchInNonJavaFiles(false);
                    rename.setPreviewUsages(false);
                    UsageInfo[] usage = ViewRefactoringListener.findUsages(psiFile, viewFolder);
                    if (rename.preprocessUsages(new Ref((Object)usage))) {
                        rename.doRefactoring(usage);
                    }
                }
            }
        }

        public static UsageInfo @NotNull [] findUsages(PsiFile element, VirtualFile viewFolder) {
            List<MoveRenameUsageInfo> result = Collections.synchronizedList(new ArrayList());
            List files = VfsUtil.collectChildrenRecursively((VirtualFile)viewFolder);
            Collection refs = ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.filesScope((Project)element.getProject(), (Collection)files)).findAll();
            for (PsiReference ref : refs) {
                if (ref == null) continue;
                PsiElement referenceElement = ref.getElement();
                result.add(new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), (PsiElement)element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0)));
            }
            UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                ViewRefactoringListener.$$$reportNull$$$0(3);
            }
            return usageInfoArray;
        }

        public static String getExtension(@NotNull String name) {
            int index;
            if (name == null) {
                ViewRefactoringListener.$$$reportNull$$$0(4);
            }
            if ((index = name.lastIndexOf(46)) < 0) {
                return "";
            }
            String substring = name.substring(0, index);
            String mobile = ".mobile";
            if (substring.endsWith(".mobile")) {
                int mobileIndex = name.lastIndexOf(".mobile");
                return name.substring(mobileIndex);
            }
            return name.substring(index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/web2py/refactoring/Web2PyRefactoringListenerProvider$ViewRefactoringListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/web2py/refactoring/Web2PyRefactoringListenerProvider$ViewRefactoringListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "elementMoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "elementRenamed";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getExtension";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

