/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import java.io.IOException;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.ContentsApiModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.DirectoryModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileContentsApiKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileWriterOutputStreamImpl;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.HttpSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/HttpSessionFileContentsApi;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileContentsApi;", "httpSession", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/http/HttpSession;)V", "createDirectory", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/DirectoryModel;", "path", "", "delete", "", "fileWriter", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "getFileNode", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/ContentsApiModel;", "content", "", "rename", "oldPath", "newPath", "intellij.python.jupyter"})
public final class HttpSessionFileContentsApi
implements FileContentsApi {
    private final HttpSession httpSession;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ContentsApiModel getFileNode(@NotNull String path, boolean content2) throws IOException {
        Object object;
        void endpoint$iv;
        void $this$getObject$iv;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Object e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Authority " + this.httpSession.getBaseURI().getAuthority() + ", call getFileNode(\"" + path + "\", content=" + content2 + ").";
            logger.debug(string, (Throwable)e$iv);
        }
        $this$debug$iv = this.httpSession;
        e$iv = "/api/contents/" + StringsKt.trim((String)path, (char[])new char[]{'/'});
        String query$iv = "content=" + (content2 ? "1" : "0");
        boolean $i$f$getObject = false;
        URI requestURI$iv = JupyterHttpSessionRestUtilsKt.getRequestURI((HttpSession)$this$getObject$iv, (String)endpoint$iv, query$iv);
        Request request = Request.Get((URI)requestURI$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"Request.Get(requestURI)");
        String response$iv = JupyterHttpSessionRestUtilsKt.executeAndCheck((HttpSession)$this$getObject$iv, request, 200);
        ObjectMapper $this$readValueWrappingError$iv$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            object = $this$readValueWrappingError$iv$iv.readValue(response$iv, ContentsApiModel.class);
        }
        catch (JsonProcessingException err$iv$iv) {
            String prettyJson$iv$iv = $this$readValueWrappingError$iv$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response$iv));
            boolean bl = false;
            String string = "GET " + requestURI$iv;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv$iv)};
            Throwable throwable = err$iv$iv;
            String string2 = string;
            throw (Throwable)new RuntimeExceptionWithAttachments(string2, throwable, attachmentArray);
        }
        return (ContentsApiModel)object;
    }

    @Override
    @NotNull
    public FileWriterOutputStream fileWriter(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new FileWriterOutputStreamImpl(this.httpSession, path);
    }

    @Override
    @NotNull
    public DirectoryModel createDirectory(@NotNull String path) throws IOException {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ObjectNode objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("type", "directory");
        ObjectNode rootNode = objectNode;
        String endpoint = "/api/contents/" + StringsKt.trim((String)path, (char[])new char[]{'/'});
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl4 = false;
            String string = "Authority " + this.httpSession.getBaseURI().getAuthority() + ", call createDirectory(\"" + path + "\").";
            logger.debug(string, (Throwable)e$iv);
        }
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)rootNode);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jackson.writeValueAsString(rootNode)");
        String response = JupyterHttpSessionRestUtilsKt.put$default(this.httpSession, endpoint, string, null, 4, null);
        ObjectMapper $this$readValueWrappingError$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            object = $this$readValueWrappingError$iv.readValue(response, DirectoryModel.class);
        }
        catch (JsonProcessingException err$iv) {
            String prettyJson$iv = $this$readValueWrappingError$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response));
            boolean bl5 = false;
            String string2 = "PUT " + endpoint;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv)};
            Throwable throwable = err$iv;
            String string3 = string2;
            throw (Throwable)new RuntimeExceptionWithAttachments(string3, throwable, attachmentArray);
        }
        return (DirectoryModel)object;
    }

    @Override
    public void delete(@NotNull String path) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Authority " + this.httpSession.getBaseURI().getAuthority() + ", call delete(\"" + path + "\").";
            logger.debug(string, (Throwable)e$iv);
        }
        JupyterHttpSessionRestUtilsKt.delete(this.httpSession, "/api/contents", StringsKt.trim((String)path, (char[])new char[]{'/'}));
    }

    @Override
    @NotNull
    public ContentsApiModel rename(@NotNull String oldPath, @NotNull String newPath) throws IOException {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        ObjectNode objectNode = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("path", newPath);
        ObjectNode rootNode = objectNode;
        String endpoint = "/api/contents/" + StringsKt.trim((String)oldPath, (char[])new char[]{'/'});
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl4 = false;
            String string = "Authority " + this.httpSession.getBaseURI().getAuthority() + ", call rename(oldPath=\"" + oldPath + "\", newPath=\"" + newPath + "\").";
            logger.debug(string, (Throwable)e$iv);
        }
        String string = JupyterJsonKt.getJackson().writeValueAsString((Object)rootNode);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jackson.writeValueAsString(rootNode)");
        String response = JupyterHttpSessionRestUtilsKt.patch$default(this.httpSession, endpoint, string, 0, 4, null);
        ObjectMapper $this$readValueWrappingError$iv = JupyterJsonKt.getJackson();
        boolean $i$f$readValueWrappingError = false;
        try {
            object = $this$readValueWrappingError$iv.readValue(response, ContentsApiModel.class);
        }
        catch (JsonProcessingException err$iv) {
            String prettyJson$iv = $this$readValueWrappingError$iv.writerWithDefaultPrettyPrinter().writeValueAsString((Object)JupyterJsonKt.getJackson().readTree(response));
            boolean bl5 = false;
            String string2 = "PATCH " + endpoint;
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", prettyJson$iv)};
            Throwable throwable = err$iv;
            String string3 = string2;
            throw (Throwable)new RuntimeExceptionWithAttachments(string3, throwable, attachmentArray);
        }
        return (ContentsApiModel)object;
    }

    public HttpSessionFileContentsApi(@NotNull HttpSession httpSession) {
        Intrinsics.checkParameterIsNotNull((Object)httpSession, (String)"httpSession");
        this.httpSession = httpSession;
    }
}

