/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionBase;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterExecutionException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterMessageResultWaiter;
import org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter;
import org.jetbrains.plugins.notebooks.jupyter.debugger.DebugConnectionNotifier;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugAction;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugCellIdManager;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcess;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugRunner;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugSessionManager;
import org.jetbrains.plugins.notebooks.jupyter.debugger.OutputConsumer;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterSource;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugAction;", "Lorg/jetbrains/plugins/notebooks/jupyter/actions/JupyterEditorActionBase;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.python.jupyter"})
public final class JupyterDebugAction
extends JupyterEditorActionBase {
    private static final String DEBUG_PREFIX = "# pydev_debug_cell";
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent event2) {
        Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = event2.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"event.project ?: return");
        Project project2 = project;
        JupyterCell jupyterCell = JupyterEditorActionsKt.getJupyterCell(event2);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell psiCell = jupyterCell;
        NotebookVirtualFile notebookVirtualFile = JupyterEditorActionsKt.getVirtualFile(psiCell);
        if (notebookVirtualFile == null) {
            return;
        }
        NotebookVirtualFile virtualFile2 = notebookVirtualFile;
        if (JupyterEditorActionsKt.getCellType(event2) != JupyterCellType.CODE) {
            return;
        }
        if (JupyterEditorActionsKt.showWarningIfUnderDebugger(project2, psiCell)) {
            return;
        }
        if (JupyterConnectionSettingsUtilKt.isRemoteJupyterServerSettings(project2, virtualFile2)) {
            JupyterEditorActionsKt.showRemoteDebuggerWarning(project2);
            return;
        }
        JupyterDebugCellIdManager.Companion.getInstance(project2).updatePositions(project2, virtualFile2, psiCell);
        try {
            String sessionPath = JupyterCellExecutionManager.Companion.getSessionPath(psiCell);
            JupyterDebugSessionManager.Companion.getInstance(project2).debugInSessionStarted(sessionPath);
            JupyterDebugRunner.Companion.createDebugSession$default(JupyterDebugRunner.Companion, project2, psiCell, new DebugConnectionNotifier(){

                public void executeAfterConnection(@NotNull Project project, @NotNull JupyterCell jupyterCell, @NotNull XDebugSession debugSession, @Nullable OutputConsumer consumer) {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)jupyterCell, (String)"jupyterCell");
                    Intrinsics.checkParameterIsNotNull((Object)debugSession, (String)"debugSession");
                    JupyterDebugAction.Companion.executeCell$intellij_python_jupyter(project, jupyterCell, debugSession, consumer);
                }
            }, null, null, 24, null);
        }
        catch (JupyterExecutionException e) {
            JupyterErrorReporter.Companion.displayAndLogError(project2, e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugAction$Companion;", "", "()V", "DEBUG_PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "executeCell", "", "project", "Lcom/intellij/openapi/project/Project;", "jupyterCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "output", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/OutputConsumer;", "executeCell$intellij_python_jupyter", "replaceFirstEmptyLine", "cell", "intellij.python.jupyter"})
    public static final class Companion {
        public final void executeCell$intellij_python_jupyter(@NotNull Project project, @NotNull JupyterCell jupyterCell, @NotNull XDebugSession debugSession, @Nullable OutputConsumer output) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)jupyterCell, (String)"jupyterCell");
            Intrinsics.checkParameterIsNotNull((Object)debugSession, (String)"debugSession");
            XDebugProcess xDebugProcess = debugSession.getDebugProcess();
            if (!(xDebugProcess instanceof JupyterDebugProcess)) {
                xDebugProcess = null;
            }
            JupyterDebugProcess jupyterDebugProcess = (JupyterDebugProcess)xDebugProcess;
            if (jupyterDebugProcess == null) {
                return;
            }
            JupyterDebugProcess jupyterDebugProcess2 = jupyterDebugProcess;
            jupyterDebugProcess2.setLatestExecutedCell(jupyterCell);
            int cellId = JupyterDebugCellIdManager.Companion.getInstance(project).generateCellId(jupyterCell);
            ExecutorService executorService = JupyterDebugSessionManager.Companion.getInstance(project).getExecutorService();
            String sessionPath = JupyterCellExecutionManager.Companion.getSessionPath(jupyterCell);
            PsiFile psiFile = jupyterCell.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"jupyterCell.containingFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (!(virtualFile2 instanceof NotebookVirtualFile)) {
                virtualFile2 = null;
            }
            NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)virtualFile2;
            if (notebookVirtualFile == null) {
                return;
            }
            NotebookVirtualFile jupyterFile = notebookVirtualFile;
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync((Supplier)new Supplier<Unit>(project, jupyterCell, cellId, output){
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterCell $jupyterCell;
                final /* synthetic */ int $cellId;
                final /* synthetic */ OutputConsumer $output;

                public final void get() {
                    JupyterMessageResultWaiter.executeAndWait$default(new JupyterMessageResultWaiter(this.$project, this.$jupyterCell, JupyterDebugProcess.Companion.setLatestCellIdCommand(this.$cellId), this.$output), false, false, false, true, 7, null);
                }
                {
                    this.$project = project;
                    this.$jupyterCell = jupyterCell;
                    this.$cellId = n;
                    this.$output = outputConsumer;
                }
            }, executorService).thenApply(new Function<T, U>(project, jupyterCell, jupyterFile, output){
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterCell $jupyterCell;
                final /* synthetic */ NotebookVirtualFile $jupyterFile;
                final /* synthetic */ OutputConsumer $output;

                public final void apply(Unit it) {
                    JupyterMessageResultWaiter.executeAndWait$default(new JupyterMessageResultWaiter(this.$project, this.$jupyterCell, JupyterDebugProcess.Companion.enableTracingCommand(this.$project, this.$jupyterFile), this.$output), false, false, false, true, 7, null);
                }
                {
                    this.$project = project;
                    this.$jupyterCell = jupyterCell;
                    this.$jupyterFile = notebookVirtualFile;
                    this.$output = outputConsumer;
                }
            })).thenApply(new Function<T, U>(project, jupyterCell, output){
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterCell $jupyterCell;
                final /* synthetic */ OutputConsumer $output;

                public final void apply(Unit it) {
                    JupyterMessageResultWaiter.executeAndWait$default(new JupyterMessageResultWaiter(this.$project, this.$jupyterCell, org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugAction$Companion.access$replaceFirstEmptyLine(JupyterDebugAction.Companion, this.$jupyterCell), this.$output), false, false, false, false, 2, null);
                }
                {
                    this.$project = project;
                    this.$jupyterCell = jupyterCell;
                    this.$output = outputConsumer;
                }
            })).thenApply(new Function<T, U>(jupyterDebugProcess2, project, jupyterCell, output){
                final /* synthetic */ JupyterDebugProcess $jupyterDebugProcess;
                final /* synthetic */ Project $project;
                final /* synthetic */ JupyterCell $jupyterCell;
                final /* synthetic */ OutputConsumer $output;

                public final void apply(Unit it) {
                    if (this.$jupyterDebugProcess.isConnected()) {
                        JupyterMessageResultWaiter.executeAndWait$default(new JupyterMessageResultWaiter(this.$project, this.$jupyterCell, JupyterDebugProcess.Companion.disableTracingCommand(), this.$output), false, false, false, true, 5, null);
                    }
                }
                {
                    this.$jupyterDebugProcess = jupyterDebugProcess;
                    this.$project = project;
                    this.$jupyterCell = jupyterCell;
                    this.$output = outputConsumer;
                }
            })).thenAccept(new Consumer<Unit>(project, sessionPath, jupyterDebugProcess2, jupyterCell){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $sessionPath;
                final /* synthetic */ JupyterDebugProcess $jupyterDebugProcess;
                final /* synthetic */ JupyterCell $jupyterCell;

                public final void accept(Unit it) {
                    JupyterDebugSessionManager.Companion.getInstance(this.$project).debugInSessionFinished(this.$sessionPath);
                    if (this.$jupyterDebugProcess.isConnected()) {
                        this.$jupyterDebugProcess.stop();
                        ApplicationManager.getApplication().runReadAction(new Runnable(this){
                            final /* synthetic */ executeCell.5 this$0;

                            public final void run() {
                                JupyterCellExecutionManager.Companion.getInstance(this.this$0.$project).cellExecutionFinished$intellij_python_jupyter(this.this$0.$jupyterCell);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    this.$jupyterDebugProcess.executeAfterCell();
                }
                {
                    this.$project = project;
                    this.$sessionPath = string;
                    this.$jupyterDebugProcess = jupyterDebugProcess;
                    this.$jupyterCell = jupyterCell;
                }
            });
        }

        private final String replaceFirstEmptyLine(JupyterCell cell) {
            String cellText2 = (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(cell){
                final /* synthetic */ JupyterCell $cell;

                public final String compute() {
                    JupyterSource jupyterSource = this.$cell.getSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jupyterSource, (String)"cell.source");
                    return jupyterSource.getText();
                }
                {
                    this.$cell = jupyterCell;
                }
            });
            Object[] lines = StringUtil.splitByLinesKeepSeparators((String)cellText2);
            Intrinsics.checkExpressionValueIsNotNull((Object)lines, (String)"lines");
            Object[] objectArray = lines;
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            if (!(objectArray2.length == 0)) {
                String string = lines[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lines[0]");
                if (StringsKt.isBlank((CharSequence)string)) {
                    lines[0] = JupyterDebugAction.DEBUG_PREFIX + (String)lines[0];
                }
            }
            return ArraysKt.joinToString$default((Object[])lines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$replaceFirstEmptyLine(Companion $this, JupyterCell cell) {
            return $this.replaceFirstEmptyLine(cell);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

