/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.nbformat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.CellAdded;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.CellRemoved;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellBuilder;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterMetadataAwareBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase$WhenMappings;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBaseKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookException;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookSchema;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookSchemaFactory;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBuilder;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBuilderBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.NotebookChanged;
import org.jetbrains.plugins.notebooks.jupyter.python.JupyterPyDialect;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002IJB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020/H\u0007J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020)H\u0016J\u0010\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\bH\u0002J\b\u00108\u001a\u000209H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016J\b\u0010;\u001a\u00020<H\u0016J\u0015\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020'H\u0016J\u0010\u0010B\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010C\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010D\u001a\u00020'H\u0016J\u0010\u0010E\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020HH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006K"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookBase;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterMetadataAwareBase;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "cells", "", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCell;", "getCells", "()Ljava/util/List;", "content", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getContent", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "json", "getJson", "jupyterChangeListeners", "", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterChangeListener;", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "kernelSpec", "getKernelSpec", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "setKernelSpec", "(Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;)V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "schema", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchema;", "getSchema", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchema;", "stemCell", "getStemCell", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCell;", "addCell", "", "builder", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellBuilder;", "index", "", "addJupyterChangeListener", "jupyterChangeListener", "asJson", "", "asSource", "", "checkCellBuilder", "createCell", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellBase;", "getCellBuilder", "getCellMarkerSource", "cell", "getCellsNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "getJupyterChangeListeners", "getOutputsBuilder", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterOutputsBuilder;", "notifyListeners", "jupyterEvent", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterEvent;", "notifyListeners$intellij_python_jupyter", "removeAllJupyterChangeListeners", "removeCell", "removeJupyterChangeListener", "removeStemCell", "setStemCell", "writeJson", "writer", "Ljava/io/Writer;", "Companion", "JupyterPrettyPrinter", "intellij.python.jupyter"})
public final class JupyterNotebookBase
extends JupyterMetadataAwareBase
implements JupyterNotebook {
    @NotNull
    private final ObjectNode json;
    private final List<JupyterChangeListener> jupyterChangeListeners;
    @NotNull
    private final JupyterNotebookSchema schema;
    private static final Logger LOG;
    private static final DefaultIndenter indenter;
    private static final PrettyPrinter prettyPrinter;
    public static final Companion Companion;

    @NotNull
    public final ObjectNode getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public JupyterNotebookSchema getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public JupyterCell getStemCell() {
        return JupyterNotebookBaseKt.access$getStemCell(this, this.json, this.getSchema(), this.getLanguage());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<JupyterCell> getCells() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.getCellsNode();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            JupyterCellBase jupyterCellBase = this.createCell((ObjectNode)v0);
            collection.add(jupyterCellBase);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Override
    @Nullable
    public JupyterKernelSpec getKernelSpec() {
        return JupyterKernelSpecBase.Companion.fromJson(this.json.get(this.getSchema().getMetadataFieldName()).get(this.getSchema().getKernelSpecFieldName()), this.getSchema());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setKernelSpec(@Nullable JupyterKernelSpec value) {
        v0 = this.json.get(this.getSchema().getMetadataFieldName());
        if (!(v0 instanceof ObjectNode)) {
            v0 = null;
        }
        metadataField = (ObjectNode)v0;
        v1 = value;
        if (v1 == null) ** GOTO lbl-1000
        var3_3 = v1;
        var4_4 = false;
        var5_5 = false;
        $this$run = var3_3;
        $i$a$-run-JupyterNotebookBase$kernelSpec$1 = false;
        v2 = metadataField;
        if (v2 != null && (v2 = v2.putObject(this.getSchema().getKernelSpecFieldName())) != null) {
            var8_8 = v2;
            var9_9 = false;
            var10_10 = false;
            $this$apply = var8_8;
            $i$a$-apply-JupyterNotebookBase$kernelSpec$1$1 = false;
            $this$apply.put(this.getSchema().getKernelSpecNameFieldName(), value.getName());
            $this$apply.put(this.getSchema().getKernelSpecLanguageFieldName(), value.getLanguage());
            $this$apply.put(this.getSchema().getKernelSpecDisplayNameFieldName(), value.getDisplayName());
            v3 = var8_8;
        } else {
            v3 = null;
        }
        v1 = v3;
        if (v3 != null) {
            (JsonNode)v1;
        } else lbl-1000:
        // 2 sources

        {
            v4 = metadataField;
            if (v4 != null) {
                v4.remove(this.getSchema().getKernelSpecFieldName());
            }
        }
        this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
    }

    @Override
    @NotNull
    public JupyterCellBuilder getCellBuilder() {
        return new JupyterCellBase.JupyterCellBuilderBase(this, null, null, null, false, null, null, this.getSchema(), 126, null);
    }

    @Override
    @NotNull
    public JupyterOutputsBuilder getOutputsBuilder() {
        return new JupyterOutputsBuilderBase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Language getLanguage() {
        Language language;
        String languageField;
        String string = languageField = (String)this.getSchema().getGetLanguage().invoke((Object)this.json);
        if (string != null) {
            if (StringsKt.startsWith$default((String)string, (String)"python", (boolean)false, (int)2, null)) {
                language = JupyterPyDialect.INSTANCE;
                return language;
            }
        }
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)plainTextLanguage, (String)"PlainTextLanguage.INSTANCE");
        language = (Language)plainTextLanguage;
        return language;
    }

    @Override
    public void setStemCell(@NotNull JupyterCellBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.checkCellBuilder(builder);
        JupyterCell stemCell = builder.build();
        CharSequence charSequence = stemCell.getSource();
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.getOrCreateMetadata().set("stem_cell", JupyterJsonKt.getJackson().readTree(((Object)stemCell.asJson()).toString()));
        } else {
            this.removeStemCell();
        }
    }

    @Override
    public void removeStemCell() {
        this.removeMetadata("stem_cell");
    }

    @Override
    public void addCell(@NotNull JupyterCellBuilder builder, int index) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.checkCellBuilder(builder);
        ArrayNode cells2 = this.getCellsNode();
        if (index > cells2.size() + 1) {
            LOG.warn("Trying to add cell to index " + index + " outside of cells range " + cells2.size());
            return;
        }
        JupyterCell cell = builder.build();
        JsonNode cellJson = JupyterJsonKt.getJackson().readTree(((Object)cell.asJson()).toString());
        cells2.insert(index, cellJson);
        this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
        this.notifyListeners$intellij_python_jupyter(new CellAdded(this, cell, index));
    }

    @Override
    public void removeCell(int index) {
        ArrayNode cellsElement = this.getCellsNode();
        if (index >= cellsElement.size()) {
            LOG.warn("Trying to remove cell from index " + index + " outside of cells range " + cellsElement.size());
            return;
        }
        cellsElement.remove(index);
        this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
        this.notifyListeners$intellij_python_jupyter(new CellRemoved(this, index));
    }

    private final void checkCellBuilder(JupyterCellBuilder builder) {
        if (!builder.isCompatible(this.getSchema())) {
            throw (Throwable)new JupyterNotebookException("Version of notebook cell builder " + builder + " is incompatible with notebook version " + this.getSchema());
        }
    }

    private final ArrayNode getCellsNode() {
        JsonNode cellsElement = this.json.get(this.getSchema().getCellFieldName());
        if (cellsElement == null || !cellsElement.isArray()) {
            LOG.error("Can't find proper cells element: " + cellsElement);
            ArrayNode arrayNode = JupyterJsonKt.getJackson().createArrayNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayNode, (String)"jackson.createArrayNode()");
            return arrayNode;
        }
        return (ArrayNode)cellsElement;
    }

    private final JupyterCellBase createCell(ObjectNode content2) {
        return new JupyterCellBase(this, content2, this.getSchema(), this.getLanguage());
    }

    @Override
    @NotNull
    protected ObjectNode getContent() {
        return this.json;
    }

    @Override
    @NotNull
    public CharSequence asSource() {
        StringBuilder builder = new StringBuilder();
        JupyterCell jupyterCell = this.getStemCell();
        if (jupyterCell != null) {
            JupyterCell jupyterCell2 = jupyterCell;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCell it = jupyterCell2;
            boolean bl3 = false;
            builder.append(it.getSource());
            Collection collection = this.getCells();
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                builder.append("\n");
            }
        }
        SequencesKt.joinTo$default((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.getCells()), (Function1)((Function1)new Function1<JupyterCell, Sequence<? extends String>>(this){
            final /* synthetic */ JupyterNotebookBase this$0;

            @NotNull
            public final Sequence<String> invoke(@NotNull JupyterCell it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SequencesKt.sequenceOf((Object[])new String[]{"" + JupyterNotebookBase.access$getCellMarkerSource(this.this$0, it) + it.getSource()});
            }
            {
                this.this$0 = jupyterNotebookBase;
                super(1);
            }
        })), (Appendable)builder, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
        return builder;
    }

    private final CharSequence getCellMarkerSource(JupyterCell cell) {
        CharSequence charSequence;
        Object object = (JsonNode)cell.getMetadata("name");
        if (object != null && (object = object.asText()) != null) {
            charSequence = (CharSequence)object;
        } else {
            String string;
            switch (JupyterNotebookBase$WhenMappings.$EnumSwitchMapping$0[cell.getCellType().ordinal()]) {
                case 1: {
                    string = "#%% raw\n";
                    break;
                }
                case 2: {
                    string = "#%% md\n";
                    break;
                }
                default: {
                    string = "#%%\n";
                }
            }
            charSequence = string;
        }
        return charSequence;
    }

    @Deprecated(message="In a new code use writeJson instead")
    @NotNull
    public final String asJson() {
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        boolean bl2 = false;
        StringWriter it = stringWriter;
        boolean bl3 = false;
        this.writeJson(it);
        String string = it.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringWriter().let {\n   \u2026      it.toString()\n    }");
        return string;
    }

    @Override
    public void writeJson(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        JupyterJsonKt.getJackson().writer(prettyPrinter).writeValue(writer, (Object)this.json);
    }

    @Override
    public void removeJupyterChangeListener(@NotNull JupyterChangeListener jupyterChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterChangeListener, (String)"jupyterChangeListener");
        this.jupyterChangeListeners.remove(jupyterChangeListener);
    }

    @Override
    @NotNull
    public List<JupyterChangeListener> getJupyterChangeListeners() {
        return CollectionsKt.toList((Iterable)this.jupyterChangeListeners);
    }

    @Override
    public void removeAllJupyterChangeListeners() {
        this.jupyterChangeListeners.clear();
    }

    @Override
    public void addJupyterChangeListener(@NotNull JupyterChangeListener jupyterChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterChangeListener, (String)"jupyterChangeListener");
        this.jupyterChangeListeners.add(jupyterChangeListener);
    }

    public final void notifyListeners$intellij_python_jupyter(@NotNull JupyterEvent jupyterEvent) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterEvent, (String)"jupyterEvent");
        Iterable $this$forEach$iv = this.jupyterChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterChangeListener it = (JupyterChangeListener)element$iv;
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(it, jupyterEvent){
                final /* synthetic */ JupyterChangeListener $it;
                final /* synthetic */ JupyterEvent $jupyterEvent$inlined;
                {
                    this.$it = jupyterChangeListener;
                    this.$jupyterEvent$inlined = jupyterEvent;
                }

                public final void run() {
                    this.$it.onEvent(this.$jupyterEvent$inlined);
                }
            });
        }
    }

    public JupyterNotebookBase(@NotNull Reader reader) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(reader);
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        this.json = (ObjectNode)jsonNode;
        JupyterNotebookBase jupyterNotebookBase = this;
        boolean bl = false;
        jupyterNotebookBase.jupyterChangeListeners = list = (List)new ArrayList();
        this.schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(this.json);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
        indenter = new DefaultIndenter(" ", DefaultIndenter.SYS_LF);
        JupyterPrettyPrinter jupyterPrettyPrinter = new JupyterPrettyPrinter();
        boolean bl = false;
        boolean bl2 = false;
        JupyterPrettyPrinter $this$apply = jupyterPrettyPrinter;
        boolean bl3 = false;
        $this$apply.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        $this$apply.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        prettyPrinter = (PrettyPrinter)jupyterPrettyPrinter;
    }

    public static final /* synthetic */ CharSequence access$getCellMarkerSource(JupyterNotebookBase $this, JupyterCell cell) {
        return $this.getCellMarkerSource(cell);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookBase$JupyterPrettyPrinter;", "Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;", "()V", "createInstance", "writeEndArray", "", "g", "Lcom/fasterxml/jackson/core/JsonGenerator;", "nrOfValues", "", "writeEndObject", "nrOfEntries", "writeObjectFieldValueSeparator", "intellij.python.jupyter"})
    private static final class JupyterPrettyPrinter
    extends DefaultPrettyPrinter {
        @NotNull
        public DefaultPrettyPrinter createInstance() {
            JupyterPrettyPrinter jupyterPrettyPrinter = new JupyterPrettyPrinter();
            boolean bl = false;
            boolean bl2 = false;
            JupyterPrettyPrinter $this$apply = jupyterPrettyPrinter;
            boolean bl3 = false;
            $this$apply.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
            $this$apply.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
            return jupyterPrettyPrinter;
        }

        public void writeObjectFieldValueSeparator(@NotNull JsonGenerator g) {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            g.writeRaw(": ");
        }

        public void writeEndObject(@Nullable JsonGenerator g, int nrOfEntries) throws IOException {
            DefaultPrettyPrinter.Indenter indenter = this._objectIndenter;
            Intrinsics.checkExpressionValueIsNotNull((Object)indenter, (String)"_objectIndenter");
            if (!indenter.isInline()) {
                JupyterPrettyPrinter jupyterPrettyPrinter = this;
                jupyterPrettyPrinter._nesting += -1;
                int cfr_ignored_0 = jupyterPrettyPrinter._nesting;
            }
            if (nrOfEntries > 0) {
                this._objectIndenter.writeIndentation(g, this._nesting);
            }
            JsonGenerator jsonGenerator = g;
            if (jsonGenerator == null) {
                Intrinsics.throwNpe();
            }
            jsonGenerator.writeRaw('}');
        }

        public void writeEndArray(@NotNull JsonGenerator g, int nrOfValues) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            DefaultPrettyPrinter.Indenter indenter = this._arrayIndenter;
            Intrinsics.checkExpressionValueIsNotNull((Object)indenter, (String)"_arrayIndenter");
            if (!indenter.isInline()) {
                JupyterPrettyPrinter jupyterPrettyPrinter = this;
                jupyterPrettyPrinter._nesting += -1;
                int cfr_ignored_0 = jupyterPrettyPrinter._nesting;
            }
            if (nrOfValues > 0) {
                this._arrayIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw(']');
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "indenter", "Lcom/fasterxml/jackson/core/util/DefaultIndenter;", "prettyPrinter", "Lcom/fasterxml/jackson/core/PrettyPrinter;", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

