/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.opassign;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NotNull;

public class JSReplaceWithOperatorAssignmentIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        assert (rhs != null);
        return this.getText(rhs.getOperationNode().getText());
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new Predicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(0);
        }
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        JSExpression lhs = exp.getLOperand();
        assert (rhs != null);
        String operand = rhs.getOperationNode().getText();
        JSExpression rhsrhs = rhs.getROperand();
        assert (rhsrhs != null);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)(lhs.getText() + operand + '=' + rhsrhs.getText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention", "processIntention"));
    }

    private static class Predicate
    implements JSElementPredicate {
        private Predicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSAssignmentExpression)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)element;
            IElementType tokenType = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(tokenType)) {
                return false;
            }
            JSExpression lhs = assignment.getLOperand();
            JSExpression rhs = assignment.getROperand();
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryRhs = (JSBinaryExpression)rhs;
            JSExpression rhsRhs = binaryRhs.getROperand();
            JSExpression rhsLhs = binaryRhs.getLOperand();
            if (rhsRhs == null) {
                return false;
            }
            IElementType rhsTokenType = binaryRhs.getOperationSign();
            if (!Holder.ACCEPTABLE_OPERATORS.contains(rhsTokenType)) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects((JSExpression)lhs)) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)lhs, (JSExpression)rhsLhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention$Predicate", "satisfiedBy"));
        }
    }

    private static class Holder {
        private static final TokenSet ACCEPTABLE_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.MULT, JSTokenTypes.DIV, JSTokenTypes.PERC, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.LTLT, JSTokenTypes.GTGT, JSTokenTypes.GTGTGT, JSTokenTypes.AND, JSTokenTypes.XOR, JSTokenTypes.OR, JSTokenTypes.MULTMULT});

        private Holder() {
        }
    }
}

