/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static boolean isAssignment(JSStatement statement) {
        if (!(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
        return expressionStatement.getExpression() instanceof JSAssignmentExpression;
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull JSExpression newExpression, @NotNull JSExpression exp) throws IncorrectOperationException {
        String replacementString;
        JSExpression expressionToReplace;
        if (newExpression == null) {
            ConditionalUtils.$$$reportNull$$$0(0);
        }
        if (exp == null) {
            ConditionalUtils.$$$reportNull$$$0(1);
        }
        if ((expressionToReplace = BoolUtils.findNegation(exp)) == null) {
            expressionToReplace = exp;
            if (ComparisonUtils.isComparison((JSExpression)newExpression)) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)newExpression;
                IElementType operationSign = binaryExpression.getOperationSign();
                String negatedComparison = ComparisonUtils.getNegatedOperatorText((IElementType)operationSign);
                JSExpression leftOperand = binaryExpression.getLOperand();
                JSExpression rightOperand = binaryExpression.getROperand();
                assert (rightOperand != null);
                replacementString = leftOperand.getText() + negatedComparison + rightOperand.getText();
            } else {
                replacementString = '!' + JSParenthesesUtils.getParenthesized((JSExpression)newExpression, (int)3);
            }
        } else {
            replacementString = newExpression.getText();
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expressionToReplace, (String)replacementString);
    }

    public static void replaceExpressionWithNegatedExpressionString(@NotNull JSExpression exp, String newExpression) throws IncorrectOperationException {
        if (exp == null) {
            ConditionalUtils.$$$reportNull$$$0(2);
        }
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        String replacementString = newExpression;
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            replacementString = "!(" + newExpression + ')';
        } else {
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JSBinaryExpression && exp instanceof JSBinaryExpression) {
                IElementType parentSign = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childSign = ((JSBinaryExpression)exp).getOperationSign();
                if (childSign == JSTokenTypes.ANDAND && parentSign == JSTokenTypes.ANDAND) {
                    replacementString = "(" + newExpression + ")";
                }
            }
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expressionToReplace, (String)replacementString);
    }

    public static boolean isInIfCondition(JSExpression expression) {
        JSStatement ifStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSStatement.class);
        return ifStatement instanceof JSIfStatement && PsiTreeUtil.isAncestor((PsiElement)((JSIfStatement)ifStatement).getCondition(), (PsiElement)expression, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
        }
        objectArray2[1] = "org/intellij/idea/lang/javascript/psiutil/ConditionalUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpressionWithNegatedExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpressionWithNegatedExpressionString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

