/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.ControllerImpl;
import com.yourkit.api.ProbeActivityMode;
import com.yourkit.api.ProfilingModesExt;
import com.yourkit.util.Strings;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Controller {
    public static final long SNAPSHOT_WITHOUT_HEAP = 0L;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_HPROF = 17L;
    @NotNull
    private final ControllerImpl myImpl;
    private static final String CMD_PRINT_STATUS = "status";
    private static final String CMD_PRINT_STATUS_OLD = "print-current-status";
    private static final String CMD_CAPTURE_PERFORMANCE_SNAPSHOT = "capture-performance-snapshot";
    private static final String CMD_CAPTURE_MEMORY_SNAPSHOT = "capture-memory-snapshot";
    private static final String CMD_CAPTURE_HPROF_SNAPSHOT = "capture-hprof-snapshot";
    private static final String CMD_START_SAMPLING = "start-sampling";
    private static final String CMD_START_SAMPLING_OLD = "start-cpu-sampling";
    private static final String CMD_START_ASYNC_SAMPLING_CPU = "start-async-sampling-cpu";
    private static final String CMD_START_ASYNC_SAMPLING_PERIODIC = "start-async-sampling-periodic";
    private static final String CMD_START_TRACING = "start-tracing";
    private static final String CMD_START_TRACING_OLD = "start-cpu-tracing";
    private static final String CMD_START_CALL_COUNTING = "start-call-counting";
    private static final String CMD_START_CALL_COUNTING_OLD = "start-cpu-call-counting";
    private static final String OPT_ALLOC_SAMPLED = "alloc-sampled";
    private static final String CMD_STOP_CPU_PROFILING = "stop-cpu-profiling";
    private static final String CMD_CLEAR_CPU_DATA = "clear-cpu-data";
    private static final String CMD_START_ALLOC_ALL = "start-alloc-recording-all";
    private static final String CMD_START_ALLOC_ADAPTIVE = "start-alloc-recording-adaptive";
    private static final String CMD_START_ALLOC_PREFIX = "start-alloc-recording=";
    private static final String CMD_STOP_ALLOC = "stop-alloc-recording";
    private static final String CMD_CLEAR_ALLOC_DATA = "clear-alloc-data";
    private static final String CMD_PRINT_ALLOC_OBJECT_COUNT = "print-alloc-object-count";
    private static final String CMD_PRINT_ALLOC_OBJECT_SIZE = "print-alloc-object-size";
    private static final String CMD_START_MONITOR_PROFILING = "start-monitor-profiling";
    private static final String CMD_STOP_MONITOR_PROFILING = "stop-monitor-profiling";
    private static final String CMD_CLEAR_MONITOR_DATA = "clear-monitor-data";
    private static final String CMD_START_STACK_TELEMETRY = "start-stack-telemetry";
    private static final String CMD_START_STACK_TELEMETRY_OLD = "enable-stack-telemetry";
    private static final String CMD_STOP_STACK_TELEMETRY = "stop-stack-telemetry";
    private static final String CMD_STOP_STACK_TELEMETRY_OLD = "disable-stack-telemetry";
    private static final String CMD_FORCE_GC = "force-gc";
    private static final String CMD_CHARTS = "clear-charts";

    public Controller() throws Exception {
        this(Controller.getLocalhost(), Controller.getUsedPort());
    }

    @NotNull
    private static String getLocalhost() {
        String string = InetAddress.getLoopbackAddress().getHostAddress();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public Controller(@NotNull String host, int port) throws Exception {
        if (host == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl = new ControllerImpl(host, port);
    }

    @NotNull
    public String getSessionName() {
        String string = this.myImpl.getSessionName();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getHost() {
        String string = this.myImpl.getHost();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public int getPort() {
        return this.myImpl.getPort();
    }

    public int getPid() {
        return this.myImpl.getPid();
    }

    public static int getUsedPort() throws Exception {
        int port = -1;
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            Class<?> aClass = loader.loadClass("com.yourkit.runtime.Core");
            Field field = aClass.getDeclaredField("ourPort");
            port = (Integer)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (port == -1) {
            throw new Exception("To profile application, you should run it with the profiler agent");
        }
        return port;
    }

    @NotNull
    public String captureSnapshot(long snapshotFlags) throws Exception {
        if (snapshotFlags != 0L && snapshotFlags != 1L && snapshotFlags != 17L) {
            throw new IllegalArgumentException("illegal snapshot flags value " + snapshotFlags + "; use one of the " + this.getClass().getName() + ".SNAPSHOT_xxx constants");
        }
        String string = this.myImpl.captureSnapshot(snapshotFlags, null, null, null);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String captureMemorySnapshot() throws Exception {
        return this.captureSnapshot(1L);
    }

    public String capturePerformanceSnapshot() throws Exception {
        return this.captureSnapshot(0L);
    }

    public String captureHprofSnapshot() throws Exception {
        return this.captureSnapshot(17L);
    }

    public void startAllocationRecording(@Nullable String settings) throws Exception {
        this.myImpl.startAllocationRecording(settings);
    }

    public void stopAllocationRecording() throws Exception {
        this.myImpl.stopAllocationRecording();
    }

    public void clearAllocationData() throws Exception {
        this.myImpl.clearAllocationData();
    }

    public void startSampling(@Nullable String settings) throws Exception {
        this.myImpl.startSampling(settings);
    }

    public void startAsyncSamplingCpu(@Nullable String settings) throws Exception {
        this.myImpl.startAsyncSamplingCpu(settings);
    }

    public void startTracing(@Nullable String settings) throws Exception {
        this.myImpl.startTracing(settings);
    }

    public void startCallCounting() throws Exception {
        this.myImpl.startCallCounting();
    }

    public void stopCpuProfiling() throws Exception {
        this.myImpl.stopCpuProfiling();
    }

    public void clearCpuData() throws Exception {
        this.myImpl.clearCpuData();
    }

    public void startMonitorProfiling() throws Exception {
        this.myImpl.startMonitorProfiling();
    }

    public void stopMonitorProfiling() throws Exception {
        this.myImpl.stopMonitorProfiling();
    }

    public void clearMonitorData() throws Exception {
        this.myImpl.clearMonitorData();
    }

    public void startStackTelemetry() throws Exception {
        this.myImpl.startStackTelemetry();
    }

    public void stopStackTelemetry() throws Exception {
        this.myImpl.stopStackTelemetry();
    }

    public void startExceptionProfiling() throws Exception {
        this.myImpl.startExceptionProfiling();
    }

    public void stopExceptionProfiling() throws Exception {
        this.myImpl.stopExceptionProfiling();
    }

    public void clearExceptions() throws Exception {
        this.myImpl.clearExceptions();
    }

    public void clearEventTables(String ... tableNames) throws Exception {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.clearEventTables(Arrays.asList(tableNames));
    }

    public void advanceGeneration(@Nullable String description) throws Exception {
        this.myImpl.advanceGeneration(description == null ? "" : description);
    }

    public long[] forceGc() throws Exception {
        return this.myImpl.forceGc();
    }

    public long getStatus() throws Exception {
        return this.myImpl.getStatus();
    }

    public void setTriggers(String triggersDescription, boolean append) throws Exception {
        this.myImpl.setTriggers(triggersDescription, append);
    }

    @NotNull
    public String getTriggers() throws Exception {
        String string = this.myImpl.getTriggers();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public HashMap<String, ProbeActivityMode> getProbeActivityModes() throws Exception {
        HashMap<String, ProbeActivityMode> hashMap = this.myImpl.getProbes();
        if (hashMap == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return hashMap;
    }

    public void setProbeActivityModes(@NotNull HashMap<String, ProbeActivityMode> probeClassName2mode) throws Exception {
        if (probeClassName2mode == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myImpl.setProbes(probeClassName2mode);
    }

    public void clearCharts() throws Exception {
        this.myImpl.clearCharts();
    }

    public long getTotalCreatedObjectCount() throws Exception {
        return this.myImpl.getTotalCreatedObjectCount();
    }

    public long getTotalCreatedObjectSize() throws Exception {
        return this.myImpl.getTotalCreatedObjectSize();
    }

    public static boolean isCpuProfiling(long status) {
        return ProfilingModesExt.isCpuProfiling(status);
    }

    public static boolean isSampling(long status) {
        return ProfilingModesExt.isSampling(status) && ProfilingModesExt.isSamplingModeSync(status);
    }

    public static boolean isAsyncSamplingCpu(long status) {
        return ProfilingModesExt.isSampling(status) && ProfilingModesExt.isSamplingModeAsyncCpu(status);
    }

    public static boolean isTracing(long status) {
        return ProfilingModesExt.isTracing(status);
    }

    public static boolean isCallCounting(long status) {
        return ProfilingModesExt.isCallCounting(status);
    }

    public static boolean isMonitorProfiling(long status) {
        return ProfilingModesExt.isMonitorProfiling(status);
    }

    public static boolean isAllocationRecording(long status) {
        return ProfilingModesExt.isAllocationRecording(status);
    }

    public static boolean isStackTelemetry(long status) {
        return ProfilingModesExt.isStackTelemetry(status);
    }

    public static boolean isExceptionProfiling(long status) {
        return ProfilingModesExt.isExceptionProfiling(status);
    }

    public static boolean isDeadlockDetected(long status) {
        return ProfilingModesExt.isDeadlockDetected(status);
    }

    @Deprecated
    public static boolean isCPUCallCounting(long status) {
        return Controller.isCallCounting(status);
    }

    @Deprecated
    public static boolean isCPUTracing(long status) {
        return Controller.isTracing(status);
    }

    @Deprecated
    public static boolean isCPUSampling(long status) {
        return Controller.isSampling(status);
    }

    @Deprecated
    public static boolean isCPUProfiling(long status) {
        return Controller.isCpuProfiling(status);
    }

    @Deprecated
    public static boolean isExceptionTelemetry(long status) {
        return Controller.isExceptionProfiling(status);
    }

    @Deprecated
    public String captureHPROFSnapshot() throws Exception {
        return this.captureHprofSnapshot();
    }

    @Deprecated
    public void clearCPUData() throws Exception {
        this.clearCpuData();
    }

    @Deprecated
    public void disableExceptionTelemetry() throws Exception {
        this.stopExceptionProfiling();
    }

    @Deprecated
    public void disableStackTelemetry() throws Exception {
        this.stopStackTelemetry();
    }

    @Deprecated
    public void enableExceptionTelemetry() throws Exception {
        this.startExceptionProfiling();
    }

    @Deprecated
    public void enableStackTelemetry() throws Exception {
        this.startStackTelemetry();
    }

    @Deprecated
    public long[] forceGC() throws Exception {
        return this.forceGc();
    }

    @Deprecated
    public int getPID() {
        return this.getPid();
    }

    @Deprecated
    public void startCPUCallCounting() throws Exception {
        this.startCallCounting();
    }

    @Deprecated
    public void startCPUSampling(@Nullable String settings) throws Exception {
        this.startSampling(settings);
    }

    @Deprecated
    public void startCPUTracing(@Nullable String settings) throws Exception {
        this.startTracing(settings);
    }

    @Deprecated
    public void stopCPUProfiling() throws Exception {
        this.stopCpuProfiling();
    }

    private static void printHelp() {
        System.out.println("YourKit Java Profiler 2019.8-b126 command line tools\n\nUsage: java -jar yjp-controller-api-redist.jar <host> <port> <command>\n\nwhere <command> is one of:\n\nstatus\ncapture-memory-snapshot\ncapture-hprof-snapshot\ncapture-performance-snapshot\nstart-sampling\nstart-async-sampling-cpu\nstart-tracing\nstart-call-counting\nstop-cpu-profiling\nclear-cpu-data\nstart-alloc-recording-all [alloc-sampled] \n  // record all objects\nstart-alloc-recording-adaptive [alloc-sampled] \n  // record all objects with size >= 4 KB, and only each 10th smaller object\nstart-alloc-recording=<N>,<B> [alloc-sampled] \n  // record all objects with size >= <B> bytes, and only each <N>-th smaller object\nstop-alloc-recording\nclear-alloc-data\nprint-alloc-object-count\n  // get total count of all objects created during object allocation recording\nprint-alloc-object-size\n  // get total size in bytes of all objects created during object allocation recording in full mode\nstart-monitor-profiling\nstop-monitor-profiling\nclear-monitor-data\nstart-stack-telemetry\nstop-stack-telemetry\nforce-gc\nclear-charts\n\nExamples:\njava -jar yjp-controller-api-redist.jar localhost 10001 capture-memory-snapshot\njava -jar yjp-controller-api-redist.jar localhost 10001 start-sampling\n");
    }

    public static void main(@NotNull String[] args) throws Exception {
        String path;
        int port;
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (args.length < 3) {
            Controller.printHelp();
            return;
        }
        String host = args[0];
        String portStr = args[1];
        String command = args[2].toLowerCase();
        try {
            port = Integer.parseInt(portStr);
        }
        catch (Exception ignored) {
            System.out.println("Error: invalid port number specified: " + portStr);
            Controller.printHelp();
            return;
        }
        boolean allocSampled = false;
        for (int i = 3; i < args.length; ++i) {
            String option = args[i];
            if (!CMD_START_ALLOC_ALL.equals(command) && !CMD_START_ALLOC_ADAPTIVE.equals(command) && !command.startsWith(CMD_START_ALLOC_PREFIX) || !OPT_ALLOC_SAMPLED.equals(option)) {
                Controller.printHelp();
                return;
            }
            allocSampled = true;
        }
        if (CMD_CAPTURE_MEMORY_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureMemorySnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_HPROF_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.captureHprofSnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_CAPTURE_PERFORMANCE_SNAPSHOT.equals(command)) {
            Controller controller = new Controller(host, port);
            path = controller.capturePerformanceSnapshot();
            System.out.println("Snapshot captured: " + path);
            return;
        }
        if (CMD_START_SAMPLING.equals(command) || CMD_START_SAMPLING_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startSampling(null);
            System.out.println("CPU sampling started");
            return;
        }
        if (CMD_START_ASYNC_SAMPLING_CPU.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAsyncSamplingCpu(null);
            System.out.println("CPU sampling started (asynchronous, cpu)");
            return;
        }
        if (CMD_START_ASYNC_SAMPLING_PERIODIC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.myImpl.startAsyncSamplingPeriodic(null);
            System.out.println("CPU sampling started (asynchronous, periodic)");
            return;
        }
        if (CMD_START_TRACING.equals(command) || CMD_START_TRACING_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startTracing(null);
            System.out.println("CPU tracing started");
            return;
        }
        if (CMD_START_CALL_COUNTING.equals(command) || CMD_START_CALL_COUNTING_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startCallCounting();
            System.out.println("Call counting started");
            return;
        }
        if (CMD_STOP_CPU_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopCpuProfiling();
            System.out.println("CPU profiling stopped");
            return;
        }
        if (CMD_CLEAR_CPU_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearCpuData();
            System.out.println("CPU profiling data cleared");
            return;
        }
        if (CMD_START_ALLOC_ALL.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(ControllerImpl.composeAllocationRecordingSettings(1, 1, allocSampled));
            System.out.println("Allocation recording started (record all)");
            return;
        }
        if (CMD_START_ALLOC_ADAPTIVE.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(ControllerImpl.composeAllocationRecordingSettings(4096, 10, allocSampled));
            System.out.println("Allocation recording started (recordEach=10, sizeLimit=4096");
            return;
        }
        if (command.startsWith(CMD_START_ALLOC_PREFIX)) {
            Integer sizeLimit;
            String params = Strings.cutPrefix(command, CMD_START_ALLOC_PREFIX);
            String[] paramArr = params.split(",");
            Integer recordEach = paramArr.length == 2 ? Strings.parseInt(paramArr[0]) : null;
            Integer n = sizeLimit = paramArr.length == 2 ? Strings.parseInt(paramArr[1]) : null;
            if (recordEach == null || sizeLimit == null) {
                System.out.println("Error: invalid parameters of start-alloc-recording=");
                Controller.printHelp();
                return;
            }
            Controller controller = new Controller(host, port);
            controller.startAllocationRecording(ControllerImpl.composeAllocationRecordingSettings(sizeLimit, recordEach, allocSampled));
            System.out.println("Allocation recording started (recordEach=" + recordEach + ", sizeLimit=" + sizeLimit + ")");
            return;
        }
        if (CMD_STOP_ALLOC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopAllocationRecording();
            System.out.println("Allocation recording stopped");
            return;
        }
        if (CMD_CLEAR_ALLOC_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearAllocationData();
            System.out.println("Allocation data cleared");
            return;
        }
        if (CMD_PRINT_ALLOC_OBJECT_COUNT.equals(command)) {
            Controller controller = new Controller(host, port);
            System.out.println(controller.getTotalCreatedObjectCount());
            return;
        }
        if (CMD_PRINT_ALLOC_OBJECT_SIZE.equals(command)) {
            Controller controller = new Controller(host, port);
            System.out.println(controller.getTotalCreatedObjectSize());
            return;
        }
        if (CMD_START_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startMonitorProfiling();
            System.out.println("Monitor profiling started");
            return;
        }
        if (CMD_STOP_MONITOR_PROFILING.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopMonitorProfiling();
            System.out.println("Monitor profiling stopped");
            return;
        }
        if (CMD_CLEAR_MONITOR_DATA.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearMonitorData();
            System.out.println("Monitor data cleared");
            return;
        }
        if (CMD_FORCE_GC.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.forceGc();
            System.out.println("GC forced");
            return;
        }
        if (CMD_START_STACK_TELEMETRY.equals(command) || CMD_START_STACK_TELEMETRY_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.startStackTelemetry();
            System.out.println("Stack telemetry started");
            return;
        }
        if (CMD_STOP_STACK_TELEMETRY.equals(command) || CMD_STOP_STACK_TELEMETRY_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.stopStackTelemetry();
            System.out.println("Stack telemetry stopped");
            return;
        }
        if (CMD_CHARTS.equals(command)) {
            Controller controller = new Controller(host, port);
            controller.clearCharts();
            System.out.println("Telemetry charts cleared");
            return;
        }
        if (CMD_PRINT_STATUS.equals(command) || CMD_PRINT_STATUS_OLD.equals(command)) {
            Controller controller = new Controller(host, port);
            System.out.println("Host: " + controller.getHost());
            System.out.println("Agent port: " + controller.getPort());
            System.out.println("PID: " + controller.getPid());
            System.out.println("Session name: " + controller.getSessionName());
            System.out.println();
            long status = controller.getStatus();
            if (Controller.isAllocationRecording(status)) {
                System.out.println("Allocation recording: on");
            } else {
                System.out.println("Allocation recording: off");
            }
            if (Controller.isTracing(status)) {
                System.out.println("CPU profiling: on (tracing)");
            } else if (Controller.isSampling(status)) {
                System.out.println("CPU profiling: on (sampling)");
            } else if (Controller.isAsyncSamplingCpu(status)) {
                System.out.println("CPU profiling: on (async. sampling)");
            } else if (Controller.isCallCounting(status)) {
                System.out.println("CPU profiling: on (call counting)");
            } else {
                System.out.println("CPU profiling: off");
            }
            if (Controller.isMonitorProfiling(status)) {
                System.out.println("Monitor profiling: on");
            } else {
                System.out.println("Monitor profiling: off");
            }
            if (Controller.isStackTelemetry(status)) {
                System.out.println("Stack telemetry: on");
            } else {
                System.out.println("Stack telemetry: off");
            }
            if (Controller.isExceptionProfiling(status)) {
                System.out.println("Exception profiling: on");
            } else {
                System.out.println("Exception profiling: off");
            }
            System.out.println("Deadlock detected: " + Controller.isDeadlockDetected(status));
            return;
        }
        Controller.printHelp();
    }
}

