/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django;

import com.intellij.DynamicBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.facet.DjangoSettingsPanel;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.templateLanguages.TemplateLanguageConfigurable;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DjangoConfigurable
implements Configurable {
    private JPanel myMainPanel;
    private JCheckBox myEnableDjangoSupportCheckBox;
    private JPanel myDjangoConfigurationPlaceholder;
    private final DjangoSettingsPanel mySettingsPanel;
    private final Module myModule;

    public DjangoConfigurable(@NotNull Module module) {
        if (module == null) {
            DjangoConfigurable.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.$$$setupUI$$$();
        this.mySettingsPanel = new DjangoSettingsPanel(module.getProject());
        this.myDjangoConfigurationPlaceholder.add((Component)this.mySettingsPanel, "Center");
        this.myEnableDjangoSupportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DjangoConfigurable.this.updatePanelEnabled();
            }
        });
        this.updatePanelEnabled();
    }

    private void updatePanelEnabled() {
        if (this.myEnableDjangoSupportCheckBox.isSelected()) {
            UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)true, (boolean)true);
        } else {
            UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)false, (boolean)true);
        }
    }

    @Nls
    public String getDisplayName() {
        return DjangoBundle.message((String)"configurable.DjangoFacet.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "django_support";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myEnableDjangoSupportCheckBox.isSelected() != DjangoFacet.isPresent((Module)this.myModule)) {
            return true;
        }
        if (this.myEnableDjangoSupportCheckBox.isSelected()) {
            return this.mySettingsPanel.isModified((DjangoFacetConfiguration)DjangoFacet.getInstance((Module)this.myModule).getConfiguration());
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        if (this.myEnableDjangoSupportCheckBox.isSelected()) {
            DjangoFacet facet = DjangoFacet.getInstance((Module)this.myModule);
            if (facet == null) {
                DjangoFacetConfiguration configuration = DjangoFacetType.createDefaultConfiguration((Project)this.myModule.getProject());
                this.mySettingsPanel.apply(configuration);
                DjangoFacetType.createDjangoFacet((Module)this.myModule, (DjangoFacetConfiguration)configuration);
                TemplatesService instance = TemplatesService.getInstance((Module)this.myModule);
                if (instance.getTemplateLanguage().equals("None")) {
                    instance.setTemplateLanguage("Django");
                }
                TemplateLanguageConfigurable.reparseTemplateFiles((Project)this.myModule.getProject());
            } else {
                this.mySettingsPanel.apply((DjangoFacetConfiguration)facet.getConfiguration());
            }
        } else if (DjangoFacet.isPresent((Module)this.myModule)) {
            ModifiableFacetModel model = FacetManager.getInstance((Module)this.myModule).createModifiableModel();
            model.removeFacet((Facet)DjangoFacet.getInstance((Module)this.myModule));
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        }
    }

    public void reset() {
        this.myEnableDjangoSupportCheckBox.setEnabled(true);
        DjangoFacet instance = DjangoFacet.getInstance((Module)this.myModule);
        if (instance != null) {
            this.myEnableDjangoSupportCheckBox.setSelected(true);
            this.mySettingsPanel.setEnabled(true);
            this.mySettingsPanel.reset((DjangoFacetConfiguration)instance.getConfiguration());
        } else {
            this.myEnableDjangoSupportCheckBox.setSelected(false);
            this.mySettingsPanel.setEnabled(false);
        }
        this.updatePanelEnabled();
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDjangoConfigurationPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myEnableDjangoSupportCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", DjangoConfigurable.class).getString("enable.django.support.checkbox.text"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/django/DjangoConfigurable", "<init>"));
    }
}

