/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.function.BiFunction;
import org.angular2.codeInsight.Angular2TypeEvaluator;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.psi.Angular2Binding;
import org.angular2.lang.expr.psi.Angular2ElementVisitor;
import org.angular2.lang.expr.psi.Angular2TemplateBinding;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularInvalidExpressionResultTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularInvalidExpressionResultTypeInspection.$$$reportNull$$$0(0);
        }
        return new Angular2ElementVisitor(){

            @Override
            public void visitAngular2Binding(Angular2Binding binding) {
                this.validateBinding((JSElement)binding, (b, attribute) -> Pair.pair((Object)b.getExpression(), (Object)Angular2TypeEvaluator.resolvePropertyType(attribute)), Angular2AttributeType.PROPERTY_BINDING, Angular2AttributeType.BANANA_BOX_BINDING);
            }

            @Override
            public void visitAngular2TemplateBinding(Angular2TemplateBinding templateBinding) {
                this.validateBinding(templateBinding, (binding, descriptor) -> Pair.pair((Object)binding.getExpression(), (Object)binding.getKeyJSType()), Angular2AttributeType.TEMPLATE_BINDINGS);
            }

            private <T extends JSElement> void validateBinding(@Nullable T binding, @NotNull BiFunction<T, XmlAttribute, Pair<JSExpression, JSType>> getTypeAndExpression, Angular2AttributeType ... supportedTypes) {
                Angular2AttributeDescriptor descriptor;
                if (getTypeAndExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (supportedTypes == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (binding == null) {
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType(binding, XmlAttribute.class);
                if (attribute == null) {
                    attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)InjectedLanguageManager.getInstance((Project)binding.getProject()).getInjectionHost(binding), XmlAttribute.class);
                }
                if ((descriptor = (Angular2AttributeDescriptor)((Object)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)attribute, XmlAttribute::getDescriptor), Angular2AttributeDescriptor.class))) != null && ArrayUtil.contains((Object)((Object)descriptor.getInfo().type), (Object[])supportedTypes)) {
                    this.validateType(attribute, binding, getTypeAndExpression);
                }
            }

            private <T extends JSElement> void validateType(@NotNull XmlAttribute attribute, @NotNull T binding, @NotNull BiFunction<T, XmlAttribute, Pair<JSExpression, JSType>> getTypeAndExpression) {
                if (attribute == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (binding == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (getTypeAndExpression == null) {
                    1.$$$reportNull$$$0(4);
                }
                Pair<JSExpression, JSType> typeAndExpression = getTypeAndExpression.apply(binding, attribute);
                JSType expectedType = (JSType)typeAndExpression.second;
                JSExpression expression = (JSExpression)typeAndExpression.first;
                if (expectedType == null || expression == null) {
                    return;
                }
                JSType actualType = JSResolveUtil.getElementJSType((PsiElement)expression, (boolean)true);
                if (actualType != null && !expectedType.isDirectlyAssignableType(actualType, JSTypeComparingContextService.getProcessingContextWithCache(binding))) {
                    holder.registerProblem((PsiElement)expression, Angular2Bundle.message("angular.inspection.invalid-expr-result-type.message", actualType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expectedType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "getTypeAndExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "supportedTypes";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "binding";
                        break;
                    }
                }
                objectArray2[1] = "org/angular2/inspections/AngularInvalidExpressionResultTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateBinding";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "validateType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/angular2/inspections/AngularInvalidExpressionResultTypeInspection", "buildVisitor"));
    }
}

